/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureCodesProvider;
import java.io.Serializable;
import java.util.List;

@JsonObject(value="FeatureVectorWithDescription")
public class FeatureVectorWithDescription
extends FeatureVector
implements IFeatureCodesProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private FeatureVectorDatasetWellReference datasetWellReference;
    private List<String> featureNames;

    public FeatureVectorWithDescription(FeatureVectorDatasetWellReference dataset, List<String> featureNames, double[] values) {
        super(dataset.getWellPosition(), values);
        this.datasetWellReference = dataset;
        this.featureNames = featureNames;
    }

    public FeatureVectorDatasetWellReference getDatasetWellReference() {
        return this.datasetWellReference;
    }

    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    @Override
    public List<String> getFeatureCodes() {
        return this.featureNames;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.datasetWellReference == null ? 0 : this.datasetWellReference.hashCode());
        result = 31 * result + (this.featureNames == null ? 0 : this.featureNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureVectorWithDescription other = (FeatureVectorWithDescription)obj;
        if (this.datasetWellReference == null ? other.datasetWellReference != null : !this.datasetWellReference.equals(other.datasetWellReference)) {
            return false;
        }
        return !(this.featureNames == null ? other.featureNames != null : !this.featureNames.equals(other.featureNames));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("datasetCode: " + this.datasetWellReference.getDatasetCode());
        sb.append(", storeUrl: " + this.datasetWellReference.getDatastoreServerUrl());
        sb.append("\n\tfeatures: " + this.featureNames);
        sb.append("\n");
        sb.append(super.toString());
        return sb.toString();
    }

    private FeatureVectorWithDescription() {
        super(null, new double[0]);
    }

    private void setDatasetWellReference(FeatureVectorDatasetWellReference datasetWellReference) {
        this.datasetWellReference = datasetWellReference;
    }

    private void setFeatureNames(List<String> featureNames) {
        this.featureNames = featureNames;
    }

    private void setFeatureCodes(List<String> featureCodes) {
        this.featureNames = featureCodes;
    }
}

