/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class EntityType
extends BasicEntityType {
    private static final long serialVersionUID = 35L;
    public static final String ALL_TYPES_CODE = "(all)";
    public static final String DEFINED_IN_FILE = "(multiple)";

    public abstract List<? extends EntityTypePropertyType<?>> getAssignedPropertyTypes();

    public final boolean isAllTypesCode() {
        return EntityType.isAllTypesCode(this.getCode());
    }

    public static final boolean isDefinedInFileEntityTypeCode(String entityTypeCode) {
        return DEFINED_IN_FILE.equals(entityTypeCode);
    }

    public static final boolean isAllTypesCode(String entityTypeCode) {
        return ALL_TYPES_CODE.equals(entityTypeCode);
    }

    public final boolean isDefinedInFileEntityTypeCode() {
        return EntityType.isDefinedInFileEntityTypeCode(this.getCode());
    }

    public static <T extends EntityTypePropertyType<?>> List<T> sortedInternally(List<T> etpts) {
        Collections.sort(etpts, new Comparator<EntityTypePropertyType<?>>(){

            @Override
            public int compare(EntityTypePropertyType<?> o1, EntityTypePropertyType<?> o2) {
                return o1.getOrdinal().compareTo(o2.getOrdinal());
            }
        });
        return etpts;
    }

    public abstract boolean isEntityKind(EntityKind var1);
}

