/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class VocabularyTranslator {
    private VocabularyTranslator() {
    }

    public static final Vocabulary translate(VocabularyPE vocabulary) {
        return VocabularyTranslator.translate(vocabulary, false);
    }

    public static final Vocabulary translate(VocabularyPE vocabulary, boolean withTerms) {
        Set<VocabularyTermPE> terms;
        if (vocabulary == null) {
            return null;
        }
        Vocabulary result = new Vocabulary();
        result.setId(HibernateUtils.getId(vocabulary));
        result.setCode(vocabulary.getCode());
        result.setDescription(vocabulary.getDescription());
        result.setInternalNamespace(vocabulary.isInternalNamespace());
        result.setManagedInternally(vocabulary.isManagedInternally());
        result.setChosenFromList(vocabulary.isChosenFromList());
        result.setURLTemplate(vocabulary.getURLTemplate());
        result.setRegistrationDate(vocabulary.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(vocabulary.getRegistrator()));
        if (withTerms && (terms = vocabulary.getTerms()) != null) {
            result.setTerms(VocabularyTermTranslator.translateTermsList(terms));
        }
        return result;
    }

    public static List<Vocabulary> translate(List<VocabularyPE> vocabularies, boolean withTerms) {
        ArrayList<Vocabulary> result = new ArrayList<Vocabulary>();
        for (VocabularyPE v : vocabularies) {
            result.add(VocabularyTranslator.translate(v, withTerms));
        }
        return result;
    }
}

