/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UploadClientSortingUtils;
import ch.systemsx.cisd.openbis.dss.client.api.gui.tree.FilterableMutableTreeNode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataSetPickerDialog
extends AbstractEntityPickerDialog
implements TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    private final JTree tree = new JTree();
    private final JTextField filterField;
    private final JOptionPane optionPane;

    public DataSetPickerDialog(JFrame mainWindow, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Pick a data set", clientModel);
        this.tree.addTreeWillExpandListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.filterField = this.createFilterField();
        JPanel northPanel = DataSetPickerDialog.createFilterAndRefreshButtonPanel(this.filterField, this.refreshButton);
        this.optionPane = DataSetPickerDialog.createOptionPane(northPanel, this.tree, this);
        this.addTreeSelectionListener();
        this.setDialogData();
        this.setContentPane(this.optionPane);
    }

    @Override
    protected void setDialogData() {
        FilterableMutableTreeNode top = new FilterableMutableTreeNode("Experiments");
        List<String> projectIdentifiers = this.clientModel.getProjectIdentifiers();
        List<Experiment> experiments = this.clientModel.getOpenBISService().listExperimentsHavingDataSetsForProjects(projectIdentifiers);
        DataSetPickerDialog.createNodes(top, experiments);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.setRoot(top);
        this.updateTreeSelection();
    }

    private void addTreeSelectionListener() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DataSetPickerDialog.this.optionPane.setValue(0);
                }
            }
        });
    }

    private static JOptionPane createOptionPane(JPanel northPanel, final JTree tree, final JDialog parent) {
        JScrollPane scrollPane = new JScrollPane(tree);
        Object[] objects = new Object[]{"Filter experiments: ", northPanel, "Select data set:", scrollPane};
        final JOptionPane optionPane = new JOptionPane(objects, -1, 2);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    if ((Integer)evt.getNewValue() == 0 && tree.getSelectionPath() == null) {
                        JOptionPane.showMessageDialog(parent, "Data set needs to be selected!", "No data set selected!", 2);
                        optionPane.setValue(optionPane.getInitialValue());
                    } else if ((Integer)evt.getNewValue() == 0 && tree.getSelectionPath().getPath().length < 3) {
                        JOptionPane.showMessageDialog(parent, "Data set should be selected, not experiment!", "No data set selected!", 2);
                        optionPane.setValue(optionPane.getInitialValue());
                    } else {
                        parent.setVisible(false);
                    }
                }
            }
        });
        return optionPane;
    }

    private static void createNodes(FilterableMutableTreeNode top, List<Experiment> experiments) {
        UploadClientSortingUtils.sortExperimentsByIdentifier(experiments);
        for (Experiment experiment : experiments) {
            DefaultMutableTreeNode category = new DefaultMutableTreeNode(experiment.getIdentifier(), true);
            category.add(new DefaultMutableTreeNode("dummy child"));
            top.add(category);
        }
    }

    private JTextField createFilterField() {
        JTextField textField = new JTextField();
        textField.setEditable(true);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DataSetPickerDialog.this.updateTreeSelection();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DataSetPickerDialog.this.updateTreeSelection();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DataSetPickerDialog.this.updateTreeSelection();
            }
        });
        return textField;
    }

    private void updateTreeSelection() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        FilterableMutableTreeNode rootNode = (FilterableMutableTreeNode)treeModel.getRoot();
        rootNode.filter(this.filterField.getText());
        treeModel.reload();
    }

    public String pickDataSet() {
        this.pack();
        int height = this.getHeight() > 500 ? 500 : this.getHeight();
        int width = this.getWidth() > 600 ? 600 : this.getWidth();
        this.setSize(width, height);
        Point mwLocation = this.mainWindow.getLocationOnScreen();
        int x = mwLocation.x + this.mainWindow.getWidth() / 2 - this.getWidth() / 2;
        int y = mwLocation.y + this.mainWindow.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        this.setVisible(true);
        Object value = this.optionPane.getValue();
        this.optionPane.setValue(this.optionPane.getInitialValue());
        if (this.isDataSetPicked(value)) {
            return this.tree.getSelectionPath().getLastPathComponent().toString();
        }
        return null;
    }

    private boolean isDataSetPicked(Object optionPaneValue) {
        if (optionPaneValue == null || (Integer)optionPaneValue == 2) {
            return false;
        }
        return this.tree.getSelectionPath() != null;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (node.toString().equals("Data Sets")) {
            return;
        }
        node.removeAllChildren();
        if (node.getPath().length == 3) {
            List<DataSet> dataSets = this.listSampleDataSets(event);
            for (DataSet dataSet : dataSets) {
                node.add(new DefaultMutableTreeNode(dataSet.getCode()));
            }
        } else {
            if (((TreeNode)event.getPath().getLastPathComponent()).getParent() == null) {
                return;
            }
            List<Sample> samples = this.listExperimentSamples(event);
            List<DataSet> dataSets = this.listExperimentDataSets(event);
            if (dataSets.size() > 0) {
                DefaultMutableTreeNode dataSetsNode = new DefaultMutableTreeNode("Data Sets");
                node.add(dataSetsNode);
                for (DataSet dataSet : dataSets) {
                    dataSetsNode.add(new DefaultMutableTreeNode(dataSet.getCode()));
                }
            }
            for (Sample s : samples) {
                DefaultMutableTreeNode sampleNode = new DefaultMutableTreeNode(s.getIdentifier());
                sampleNode.add(new DefaultMutableTreeNode("dummy child"));
                node.add(sampleNode);
            }
        }
        if (node.getChildCount() == 0) {
            scheduler.schedule(new TimerTask(){

                @Override
                public void run() {
                    DataSetPickerDialog.this.tree.collapsePath(new TreePath(node.getPath()));
                }
            }, 1500L);
        }
    }

    protected List<DataSet> listExperimentDataSets(TreeExpansionEvent event) {
        List<String> experimentId = Collections.singletonList(event.getPath().getLastPathComponent().toString());
        List<DataSet> dataSets = this.clientModel.getOpenBISService().listDataSetsForExperiments(experimentId);
        UploadClientSortingUtils.sortDataSetsByCode(dataSets);
        return dataSets;
    }

    protected List<Sample> listExperimentSamples(TreeExpansionEvent event) {
        List<String> experimentId = Collections.singletonList(event.getPath().getLastPathComponent().toString());
        List<Sample> samples = this.clientModel.getOpenBISService().listSamplesForExperiments(experimentId);
        UploadClientSortingUtils.sortSamplesByIdentifier(samples);
        return samples;
    }

    protected List<DataSet> listSampleDataSets(TreeExpansionEvent event) {
        List<String> sampleId = Collections.singletonList(event.getPath().getLastPathComponent().toString());
        List<DataSet> dataSets = this.clientModel.getOpenBISService().listDataSetsForSamples(sampleId);
        UploadClientSortingUtils.sortDataSetsByCode(dataSets);
        return dataSets;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        node.removeAllChildren();
        node.add(new DefaultMutableTreeNode("dummy child"));
    }
}

