/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="property_types", uniqueConstraints={@UniqueConstraint(columnNames={"code", "is_internal_namespace", "dbin_id"})})
public final class PropertyTypePE
extends HibernateAbstractRegistrationHolder
implements Comparable<PropertyTypePE>,
IIdAndCodeHolder {
    public static final PropertyTypePE[] EMPTY_ARRAY = new PropertyTypePE[0];
    private static final long serialVersionUID = 35L;
    private String simpleCode;
    private DataTypePE type;
    private String description;
    private String label;
    private VocabularyPE vocabulary;
    private MaterialTypePE materialType;
    private boolean internalNamespace;
    private boolean managedInternally;
    private transient Long id;
    private DatabaseInstancePE databaseInstance;
    private Set<MaterialTypePropertyTypePE> materialTypePropertyTypes = new HashSet<MaterialTypePropertyTypePE>();
    private Set<ExperimentTypePropertyTypePE> experimentTypePropertyTypes = new HashSet<ExperimentTypePropertyTypePE>();
    private Set<SampleTypePropertyTypePE> sampleTypePropertyTypes = new HashSet<SampleTypePropertyTypePE>();
    private Set<DataSetTypePropertyTypePE> dataSetTypePropertyTypes = new HashSet<DataSetTypePropertyTypePE>();
    private String schema;
    private String transformation;

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="covo_id", updatable=false)
    public VocabularyPE getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(VocabularyPE vocabulary) {
        assert (this.materialType == null || vocabulary == null) : "Property cannot be of controled vocabulary and material type at the same moment";
        this.vocabulary = vocabulary;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="maty_prop_id", updatable=false)
    public MaterialTypePE getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(MaterialTypePE materialType) {
        assert (materialType == null || this.vocabulary == null) : "Property cannot be of controled vocabulary and material type at the same moment";
        this.materialType = materialType;
    }

    public void setSimpleCode(String simpleCode) {
        this.simpleCode = simpleCode.toUpperCase();
    }

    @NotNull(message="Database instance can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getSimpleCode() {
        return this.simpleCode;
    }

    public void setCode(String fullCode) {
        this.setInternalNamespace(CodeConverter.isInternalNamespace(fullCode));
        this.setSimpleCode(CodeConverter.tryToDatabase(fullCode));
    }

    @Override
    @Transient
    public String getCode() {
        return CodeConverter.tryToBusinessLayer(this.getSimpleCode(), this.isInternalNamespace());
    }

    @NotNull(message="Data type can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="daty_id", updatable=false)
    public final DataTypePE getType() {
        return this.type;
    }

    public final void setType(DataTypePE type) {
        this.type = type;
    }

    @NotNull(message="Description can not be null.")
    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    @NotNull(message="Label can not be null.")
    @Column(name="label")
    @Length(max=128, message="Given label '%s' is too long (maximal length: {max} characters).")
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    @Column(name="schema")
    public final String getSchema() {
        return this.schema;
    }

    public final void setSchema(String schema) {
        this.schema = schema;
    }

    @Column(name="transformation")
    public final String getTransformation() {
        return this.transformation;
    }

    public final void setTransformation(String transformation) {
        this.transformation = transformation;
    }

    @NotNull
    @Column(name="is_managed_internally")
    public boolean isManagedInternally() {
        return this.managedInternally;
    }

    public void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    @NotNull
    @Column(name="is_internal_namespace")
    public boolean isInternalNamespace() {
        return this.internalNamespace;
    }

    public void setInternalNamespace(boolean internalNamespace) {
        this.internalNamespace = internalNamespace;
    }

    @Override
    @SequenceGenerator(name="PROPERTY_TYPE_ID_SEQ", sequenceName="PROPERTY_TYPE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROPERTY_TYPE_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public final int compareTo(PropertyTypePE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyTypePE)) {
            return false;
        }
        PropertyTypePE that = (PropertyTypePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getSimpleCode(), (Object)that.getSimpleCode());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        builder.append(this.isInternalNamespace(), that.isInternalNamespace());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getSimpleCode());
        builder.append((Object)this.getDatabaseInstance());
        builder.append(this.isInternalNamespace());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getCode();
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="propertyTypeInternal")
    private Set<SampleTypePropertyTypePE> getSampleTypePropertyTypesInternal() {
        return this.sampleTypePropertyTypes;
    }

    private void setSampleTypePropertyTypesInternal(Set<SampleTypePropertyTypePE> sampleTypePropertyTypes) {
        this.sampleTypePropertyTypes = sampleTypePropertyTypes;
    }

    @Transient
    public Set<SampleTypePropertyTypePE> getSampleTypePropertyTypes() {
        return new UnmodifiableSetDecorator<SampleTypePropertyTypePE>(this.getSampleTypePropertyTypesInternal());
    }

    public final void setSampleTypePropertyTypes(Iterable<SampleTypePropertyTypePE> childs) {
        this.getSampleTypePropertyTypesInternal().clear();
        for (SampleTypePropertyTypePE child : childs) {
            this.addSampleTypePropertyType(child);
        }
    }

    public void addSampleTypePropertyType(SampleTypePropertyTypePE child) {
        PropertyTypePE parent = child.getPropertyType();
        if (parent != null) {
            parent.getSampleTypePropertyTypesInternal().remove(child);
        }
        child.setPropertyTypeInternal(this);
        this.getSampleTypePropertyTypesInternal().add(child);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="propertyTypeInternal")
    private Set<ExperimentTypePropertyTypePE> getExperimentTypePropertyTypesInternal() {
        return this.experimentTypePropertyTypes;
    }

    private void setExperimentTypePropertyTypesInternal(Set<ExperimentTypePropertyTypePE> experimentTypePropertyTypes) {
        this.experimentTypePropertyTypes = experimentTypePropertyTypes;
    }

    @Transient
    public Set<ExperimentTypePropertyTypePE> getExperimentTypePropertyTypes() {
        return new UnmodifiableSetDecorator<ExperimentTypePropertyTypePE>(this.getExperimentTypePropertyTypesInternal());
    }

    public final void setExperimentTypePropertyTypes(Iterable<ExperimentTypePropertyTypePE> childs) {
        this.getExperimentTypePropertyTypesInternal().clear();
        for (ExperimentTypePropertyTypePE child : childs) {
            this.addExperimentTypePropertyType(child);
        }
    }

    public void addExperimentTypePropertyType(ExperimentTypePropertyTypePE child) {
        PropertyTypePE parent = child.getPropertyType();
        if (parent != null) {
            parent.getExperimentTypePropertyTypesInternal().remove(child);
        }
        child.setPropertyTypeInternal(this);
        this.getExperimentTypePropertyTypesInternal().add(child);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="propertyTypeInternal")
    private Set<MaterialTypePropertyTypePE> getMaterialTypePropertyTypesInternal() {
        return this.materialTypePropertyTypes;
    }

    private void setMaterialTypePropertyTypesInternal(Set<MaterialTypePropertyTypePE> materialTypePropertyTypes) {
        this.materialTypePropertyTypes = materialTypePropertyTypes;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="propertyTypeInternal")
    private Set<DataSetTypePropertyTypePE> getDataSetTypePropertyTypesInternal() {
        return this.dataSetTypePropertyTypes;
    }

    private void setDataSetTypePropertyTypesInternal(Set<DataSetTypePropertyTypePE> dataSetTypePropertyTypes) {
        this.dataSetTypePropertyTypes = dataSetTypePropertyTypes;
    }

    @Transient
    public Set<MaterialTypePropertyTypePE> getMaterialTypePropertyTypes() {
        return new UnmodifiableSetDecorator<MaterialTypePropertyTypePE>(this.getMaterialTypePropertyTypesInternal());
    }

    public final void setMaterialTypePropertyTypes(Iterable<MaterialTypePropertyTypePE> childs) {
        this.getMaterialTypePropertyTypesInternal().clear();
        for (MaterialTypePropertyTypePE child : childs) {
            this.addMaterialTypePropertyType(child);
        }
    }

    public void addMaterialTypePropertyType(MaterialTypePropertyTypePE child) {
        PropertyTypePE parent = child.getPropertyType();
        if (parent != null) {
            parent.getMaterialTypePropertyTypesInternal().remove(child);
        }
        child.setPropertyTypeInternal(this);
        this.getMaterialTypePropertyTypesInternal().add(child);
    }

    public void addDataSetTypePropertyType(DataSetTypePropertyTypePE child) {
        PropertyTypePE parent = child.getPropertyType();
        if (parent != null) {
            parent.getDataSetTypePropertyTypesInternal().remove(child);
        }
        child.setPropertyTypeInternal(this);
        this.getDataSetTypePropertyTypesInternal().add(child);
    }

    @Transient
    public Set<DataSetTypePropertyTypePE> getDataSetTypePropertyTypes() {
        return new UnmodifiableSetDecorator<DataSetTypePropertyTypePE>(this.getDataSetTypePropertyTypesInternal());
    }
}

