/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractSwingGUI;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadTableModel;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class DataSetUploadOperation
implements Runnable {
    private final DataSetUploadTableModel tableModel;
    private final DataSetUploadClientModel clientModel;
    private final DataSetUploadClientModel.NewDataSetInfo newDataSetInfo;

    DataSetUploadOperation(DataSetUploadTableModel model, DataSetUploadClientModel clientModel, DataSetUploadClientModel.NewDataSetInfo newDataSetInfo) {
        this.tableModel = model;
        this.clientModel = clientModel;
        this.newDataSetInfo = newDataSetInfo;
    }

    @Override
    public void run() {
        try {
            if (this.newDataSetInfo.getStatus() == DataSetUploadClientModel.NewDataSetInfo.Status.QUEUED_FOR_UPLOAD) {
                this.newDataSetInfo.setStatus(DataSetUploadClientModel.NewDataSetInfo.Status.UPLOADING);
                this.tableModel.fireChanged(this.newDataSetInfo, DataSetUploadClientModel.NewDataSetInfo.Status.UPLOADING);
                this.createAdHocVocabularyTermsIfNeeded(this.newDataSetInfo);
                NewDataSetDTO cleanDto = this.clientModel.cleanNewDataSetDTO(this.newDataSetInfo.getNewDataSetBuilder().asNewDataSetDTO());
                this.clientModel.getOpenBISService().putDataSet(cleanDto, this.newDataSetInfo.getNewDataSetBuilder().getFile());
            }
            this.newDataSetInfo.setStatus(DataSetUploadClientModel.NewDataSetInfo.Status.COMPLETED_UPLOAD);
            this.tableModel.fireChanged(this.newDataSetInfo, DataSetUploadClientModel.NewDataSetInfo.Status.COMPLETED_UPLOAD);
        }
        catch (Throwable th) {
            this.newDataSetInfo.setStatus(DataSetUploadClientModel.NewDataSetInfo.Status.FAILED);
            this.tableModel.fireChanged(this.newDataSetInfo, DataSetUploadClientModel.NewDataSetInfo.Status.FAILED);
            AbstractSwingGUI.notifyUserOfThrowable(this.tableModel.getMainWindow(), this.newDataSetInfo.getNewDataSetBuilder().getFile().getAbsolutePath(), "Uploading", CheckedExceptionTunnel.unwrapIfNecessary((Throwable)th), null);
        }
    }

    private void createAdHocVocabularyTermsIfNeeded(DataSetUploadClientModel.NewDataSetInfo dataSetInfo) {
        NewDataSetMetadataDTO metadata = dataSetInfo.getNewDataSetBuilder().getDataSetMetadata();
        String dataSetTypeCode = metadata.tryDataSetType();
        if (dataSetTypeCode == null) {
            return;
        }
        DataSetType dataSetType = this.clientModel.getDataSetType(dataSetTypeCode);
        Map<String, String> vocabularyProperties = this.getVocabularyPropertyNamesToVocabularyMap(dataSetType);
        if (vocabularyProperties.isEmpty()) {
            return;
        }
        Map<String, String> dataSetProperties = metadata.getProperties();
        ArrayList<String> unmodifiableProperties = new ArrayList<String>(metadata.getUnmodifiableProperties());
        for (String property : unmodifiableProperties) {
            Vocabulary vocabulary;
            String term;
            if (!vocabularyProperties.keySet().contains(property) || (term = dataSetProperties.get(property)) == null || (vocabulary = this.clientModel.getVocabulary(vocabularyProperties.get(property))) == null || this.hasTerm(vocabulary, term)) continue;
            this.clientModel.addUnofficialVocabularyTerm(vocabulary, term, term.trim(), term, this.getMaxOrdinal(vocabulary));
        }
    }

    private boolean hasTerm(Vocabulary vocabulary, String termCode) {
        for (VocabularyTerm term : vocabulary.getTerms()) {
            if (!termCode.equalsIgnoreCase(term.getCode())) continue;
            return true;
        }
        return false;
    }

    private long getMaxOrdinal(Vocabulary vocabulary) {
        long maxOrdinal = -1L;
        for (VocabularyTerm term : vocabulary.getTerms()) {
            if (term.getOrdinal() <= maxOrdinal) continue;
            maxOrdinal = term.getOrdinal();
        }
        return maxOrdinal;
    }

    private Map<String, String> getVocabularyPropertyNamesToVocabularyMap(DataSetType dataSetType) {
        HashMap<String, String> vocabularyProperties = new HashMap<String, String>();
        for (PropertyTypeGroup typeGroup : dataSetType.getPropertyTypeGroups()) {
            for (PropertyType propertyType : typeGroup.getPropertyTypes()) {
                if (propertyType.getDataType() != DataTypeCode.CONTROLLEDVOCABULARY) continue;
                ControlledVocabularyPropertyType vocabPropertyType = (ControlledVocabularyPropertyType)propertyType;
                vocabularyProperties.put(propertyType.getCode(), vocabPropertyType.getVocabulary().getCode());
            }
        }
        return vocabularyProperties;
    }
}

