/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.springframework.remoting.RemoteAccessException;

public class DataStoreServiceFactory
implements IDataStoreServiceFactory {
    private static final int NUMBER_OF_CORE_THREADS = 10;
    private final Map<String, IDataStoreService> services = new HashMap<String, IDataStoreService>();
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, IDataStoreService.class);
    private static final ExecutorService executorService = new NamingThreadPoolExecutor("Monitoring Proxy").corePoolSize(10).daemonize();

    @Override
    public IDataStoreService create(String serverURL) {
        IDataStoreService service = this.services.get(serverURL);
        if (service == null) {
            service = HttpInvokerUtils.createServiceStub(IDataStoreService.class, String.valueOf(serverURL) + "/" + "datastore_server/dss", 300000L);
            this.services.put(serverURL, service);
        }
        return service;
    }

    @Override
    public IDataStoreService createMonitored(String serverURL, LogLevel logLevelForNotSuccessfulCalls) {
        try {
            return MonitoringProxy.create(IDataStoreService.class, this.create(serverURL)).errorLog(new Log4jSimpleLogger(machineLog)).logLevelForSuccessfulCalls(logLevelForNotSuccessfulCalls).logLevelForNotSuccessfulCalls(LogLevel.WARN).timing(TimingParameters.create(-1L, 5, 60000L)).exceptionClassSuitableForRetrying(RemoteAccessException.class).executorService(executorService).callAsynchronously(IDataStoreService.class.getMethod("cleanupSession", String.class)).get();
        }
        catch (SecurityException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

