/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.util.Locale;
import java.util.Properties;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"BMP", "FITS", "GIF", "JPEG", "PGM", "PNG", "Raw", "Text", "TIFF", "ZIP"};
    private static String fileType = "TIFF";
    private static int ndigits = 4;
    private static boolean useLabels;
    private static boolean firstTime;
    private int startAt;
    private boolean hyperstack;
    private int[] dim;

    public void run(String arg) {
        int maxImages;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp != null && imp.getStackSize() < 2) {
            IJ.error("Stack Writer", "This command requires a stack.");
            return;
        }
        int stackSize = imp.getStackSize();
        String name = imp.getTitle();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        this.hyperstack = imp.isHyperStack();
        LUT[] luts = null;
        int lutIndex = 0;
        int nChannels = imp.getNChannels();
        if (this.hyperstack) {
            this.dim = imp.getDimensions();
            if (imp.isComposite()) {
                luts = ((CompositeImage)imp).getLuts();
            }
            if (firstTime && ndigits == 4) {
                ndigits = 3;
                firstTime = false;
            }
        }
        GenericDialog gd = new GenericDialog("Save Image Sequence");
        gd.addChoice("Format:", choices, fileType);
        gd.addStringField("Name:", name, 12);
        if (!this.hyperstack) {
            gd.addNumericField("Start At:", this.startAt, 0);
        }
        gd.addNumericField("Digits (1-8):", ndigits, 0);
        if (!this.hyperstack) {
            gd.addCheckbox("Use slice labels as file names", useLabels);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        fileType = gd.getNextChoice();
        name = gd.getNextString();
        if (!this.hyperstack) {
            this.startAt = (int)gd.getNextNumber();
        }
        if (this.startAt < 0) {
            this.startAt = 0;
        }
        ndigits = (int)gd.getNextNumber();
        useLabels = !this.hyperstack ? gd.getNextBoolean() : false;
        int number = 0;
        if (ndigits < 1) {
            ndigits = 1;
        }
        if (ndigits > 8) {
            ndigits = 8;
        }
        if (stackSize > (maxImages = (int)Math.pow(10.0, ndigits)) && !useLabels && !this.hyperstack) {
            IJ.error("Stack Writer", "More than " + ndigits + " digits are required to generate \nunique file names for " + stackSize + " images.");
            return;
        }
        String format = fileType.toLowerCase(Locale.US);
        if (format.equals("gif") && !FileSaver.okForGif(imp)) {
            return;
        }
        if (format.equals("fits") && !FileSaver.okForFits(imp)) {
            return;
        }
        if (format.equals("text")) {
            format = "text image";
        }
        String extension = "." + format;
        if (format.equals("tiff")) {
            extension = ".tif";
        } else if (format.equals("text image")) {
            extension = ".txt";
        }
        String digits = this.getDigits(number);
        SaveDialog sd = new SaveDialog("Save Image Sequence", name + digits + extension, extension);
        String name2 = sd.getFileName();
        if (name2 == null) {
            return;
        }
        String directory = sd.getDirectory();
        ImageStack stack = imp.getStack();
        ImagePlus imp2 = new ImagePlus();
        imp2.setTitle(imp.getTitle());
        Calibration cal = imp.getCalibration();
        int nSlices = stack.getSize();
        String label = null;
        imp.lock();
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus("writing: " + i + "/" + nSlices);
            IJ.showProgress(i, nSlices);
            ImageProcessor ip = stack.getProcessor(i);
            if (luts != null && nChannels > 1 && this.hyperstack) {
                ip.setColorModel(luts[lutIndex++]);
                if (lutIndex >= luts.length) {
                    lutIndex = 0;
                }
            }
            imp2.setProcessor(null, ip);
            String label2 = stack.getSliceLabel(i);
            if (label2 != null && label2.indexOf("\n") != -1) {
                imp2.setProperty("Info", label2);
            } else {
                Properties props = imp2.getProperties();
                if (props != null) {
                    props.remove("Info");
                }
            }
            imp2.setCalibration(cal);
            digits = this.getDigits(number++);
            if (useLabels) {
                label = stack.getShortSliceLabel(i);
                if (label != null && label.equals("")) {
                    label = null;
                }
                if (label != null) {
                    label = label.replaceAll("/", "-");
                }
            }
            String path = label == null ? directory + name + digits + extension : directory + label + extension;
            IJ.saveAs(imp2, format, path);
        }
        imp.unlock();
        IJ.showStatus("");
    }

    String getDigits(int n) {
        if (this.hyperstack) {
            int c = n % this.dim[2] + 1;
            int z = n / this.dim[2] % this.dim[3] + 1;
            int t = n / (this.dim[2] * this.dim[3]) % this.dim[4] + 1;
            String cs = "";
            String zs = "";
            String ts = "";
            if (this.dim[2] > 1) {
                cs = "00000000" + c;
                cs = "_c" + cs.substring(cs.length() - ndigits);
            }
            if (this.dim[3] > 1) {
                zs = "00000000" + z;
                zs = "_z" + zs.substring(zs.length() - ndigits);
            }
            if (this.dim[4] > 1) {
                ts = "00000000" + t;
                ts = "_t" + ts.substring(ts.length() - ndigits);
            }
            return ts + zs + cs;
        }
        String digits = "00000000" + (this.startAt + n);
        return digits.substring(digits.length() - ndigits);
    }

    static {
        firstTime = true;
    }
}

