/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class Projector
implements PlugInFilter {
    static final int xAxis = 0;
    static final int yAxis = 1;
    static final int zAxis = 2;
    static final int nearestPoint = 0;
    static final int brightestPoint = 1;
    static final int meanValue = 2;
    static final int BIGPOWEROF2 = 8192;
    String[] axisList = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    String[] methodList = new String[]{"Nearest Point", "Brightest Point", "Mean Value"};
    private static int axisOfRotation = 1;
    private static int projectionMethod = 1;
    private double sliceInterval = 1.0;
    private static int initAngle = 0;
    private static int totalAngle = 360;
    private static int angleInc = 10;
    private static int opacity = 0;
    private static int depthCueSurf = 0;
    private static int depthCueInt = 50;
    private static boolean interpolate;
    private static boolean debugMode;
    private int transparencyLower = 1;
    private int transparencyUpper = 255;
    ImagePlus imp;
    ImageStack stack;
    ImageStack stack2;
    int width;
    int height;
    int imageWidth;
    int left;
    int right;
    int top;
    int bottom;
    byte[] projArray;
    byte[] opaArray;
    byte[] brightCueArray;
    short[] zBuffer;
    short[] cueZBuffer;
    short[] countBuffer;
    int[] sumBuffer;
    boolean isRGB;
    String label = "";
    boolean done;
    boolean batchMode = Interpreter.isBatchMode();

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null && imp.isHyperStack()) {
            IJ.error("3D Project", "Hyperstacks are currently not supported. Convert to\nRGB using Image>Type>RGB Color and try again.");
            return 4096;
        }
        return 2193;
    }

    public void run(ImageProcessor ip) {
        if (ip.isInvertedLut() && !IJ.showMessageWithCancel("3D Project", "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).")) {
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        this.imp.startTiming();
        boolean bl = this.isRGB = this.imp.getType() == 4;
        if (interpolate && this.sliceInterval > 1.0) {
            this.imp = this.zScale(this.imp);
            if (this.imp == null) {
                return;
            }
            this.sliceInterval = 1.0;
        }
        if (this.isRGB) {
            this.doRGBProjections(this.imp);
        } else {
            this.doProjections(this.imp);
        }
    }

    public boolean showDialog() {
        ImageProcessor ip = this.imp.getProcessor();
        double lower = ip.getMinThreshold();
        if (lower != -808080.0) {
            this.transparencyLower = (int)lower;
            this.transparencyUpper = (int)ip.getMaxThreshold();
        }
        Calibration cal = this.imp.getCalibration();
        GenericDialog gd = new GenericDialog("3D Projection");
        gd.addChoice("Projection Method:", this.methodList, this.methodList[projectionMethod]);
        gd.addChoice("Axis of Rotation:", this.axisList, this.axisList[axisOfRotation]);
        gd.addNumericField("Slice Spacing (" + cal.getUnits() + "):", cal.pixelDepth, 2);
        gd.addNumericField("Initial Angle (0-359 degrees):", initAngle, 0);
        gd.addNumericField("Total Rotation (0-359 degrees):", totalAngle, 0);
        gd.addNumericField("Rotation Angle Increment:", angleInc, 0);
        gd.addNumericField("Lower Transparency Bound:", this.transparencyLower, 0);
        gd.addNumericField("Upper Transparency Bound:", this.transparencyUpper, 0);
        gd.addNumericField("Opacity (0-100%):", opacity, 0);
        gd.addNumericField("Surface Depth-Cueing (0-100%):", 100 - depthCueSurf, 0);
        gd.addNumericField("Interior Depth-Cueing (0-100%):", 100 - depthCueInt, 0);
        gd.addCheckbox("Interpolate", interpolate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        projectionMethod = gd.getNextChoiceIndex();
        axisOfRotation = gd.getNextChoiceIndex();
        cal.pixelDepth = gd.getNextNumber();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        this.sliceInterval = cal.pixelDepth / cal.pixelWidth;
        initAngle = (int)gd.getNextNumber();
        totalAngle = (int)gd.getNextNumber();
        angleInc = (int)gd.getNextNumber();
        this.transparencyLower = (int)gd.getNextNumber();
        this.transparencyUpper = (int)gd.getNextNumber();
        opacity = (int)gd.getNextNumber();
        depthCueSurf = 100 - (int)gd.getNextNumber();
        depthCueInt = 100 - (int)gd.getNextNumber();
        interpolate = gd.getNextBoolean();
        return true;
    }

    public void doRGBProjections(ImagePlus imp) {
        RGBStackSplitter splitter = new RGBStackSplitter();
        splitter.split(imp.getStack(), true);
        ImagePlus red = new ImagePlus("Red", splitter.red);
        ImagePlus green = new ImagePlus("Green", splitter.green);
        ImagePlus blue = new ImagePlus("Blue", splitter.blue);
        Calibration cal = imp.getCalibration();
        Roi roi = imp.getRoi();
        if (roi != null) {
            red.setRoi(roi);
            green.setRoi(roi);
            blue.setRoi(roi);
        }
        red.setCalibration(cal);
        green.setCalibration(cal);
        blue.setCalibration(cal);
        this.label = "Red: ";
        red = this.doProjections(red);
        if (red == null || this.done) {
            return;
        }
        red.hide();
        this.label = "Green: ";
        green = this.doProjections(green);
        if (green == null || this.done) {
            return;
        }
        green.hide();
        this.label = "Blue: ";
        blue = this.doProjections(blue);
        if (blue == null || this.done) {
            return;
        }
        blue.hide();
        int w = red.getWidth();
        int h = red.getHeight();
        int d = red.getStackSize();
        RGBStackMerge merge = new RGBStackMerge();
        ImageStack stack = merge.mergeStacks(w, h, d, red.getStack(), green.getStack(), blue.getStack(), true);
        new ImagePlus("Projection of  " + imp.getShortTitle(), stack).show();
    }

    public ImagePlus doProjections(ImagePlus imp) {
        int i;
        int angle;
        boolean negInc;
        boolean minProjSize = true;
        this.stack = imp.getStack();
        if (angleInc == 0 && totalAngle != 0) {
            angleInc = 5;
        }
        boolean bl = negInc = angleInc < 0;
        if (negInc) {
            angleInc = -angleInc;
        }
        int nProjections = 0;
        if (angleInc == 0) {
            nProjections = 1;
        } else {
            for (angle = 0; angle <= totalAngle; angle += angleInc) {
                ++nProjections;
            }
        }
        if (angle > 360) {
            --nProjections;
        }
        if (nProjections <= 0) {
            nProjections = 1;
        }
        if (negInc) {
            angleInc = -angleInc;
        }
        ImageProcessor ip = imp.getProcessor();
        Rectangle r = ip.getRoi();
        this.left = r.x;
        this.top = r.y;
        this.right = r.x + r.width;
        this.bottom = r.y + r.height;
        int nSlices = imp.getStackSize();
        this.imageWidth = imp.getWidth();
        this.width = this.right - this.left;
        this.height = this.bottom - this.top;
        int xcenter = (this.left + this.right) / 2;
        int ycenter = (this.top + this.bottom) / 2;
        int zcenter = (int)((double)nSlices * this.sliceInterval / 2.0 + 0.5);
        int projwidth = 0;
        int projheight = 0;
        if (minProjSize && axisOfRotation != 2) {
            switch (axisOfRotation) {
                case 0: {
                    projheight = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
                    projwidth = this.width;
                    break;
                }
                case 1: {
                    projwidth = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
                    projheight = this.height;
                }
            }
        } else {
            projwidth = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
            projheight = (int)(Math.sqrt((double)nSlices * this.sliceInterval * (double)nSlices * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
        }
        if (projwidth % 2 == 1) {
            ++projwidth;
        }
        int projsize = projwidth * projheight;
        if (projwidth <= 0 || projheight <= 0) {
            IJ.error("'projwidth' or 'projheight' <= 0");
            return null;
        }
        try {
            this.allocateArrays(nProjections, projwidth, projheight);
        }
        catch (OutOfMemoryError e) {
            Object[] images = this.stack2.getImageArray();
            if (images != null) {
                for (int i2 = 0; i2 < images.length; ++i2) {
                    images[i2] = null;
                }
            }
            this.stack2 = null;
            IJ.error("Projector - Out of Memory", "To use less memory, use a rectanguar\nselection,  reduce \"Total Rotation\",\nand/or increase \"Angle Increment\".");
            return null;
        }
        ImagePlus projections = new ImagePlus("Projections of " + imp.getShortTitle(), this.stack2);
        projections.setCalibration(imp.getCalibration());
        projections.show();
        IJ.resetEscape();
        int theta = initAngle;
        IJ.resetEscape();
        for (int n = 0; n < nProjections; ++n) {
            int i3;
            IJ.showStatus(n + "/" + nProjections);
            if (!this.batchMode) {
                IJ.showProgress((double)n / (double)nProjections);
            }
            double thetarad = (double)theta * Math.PI / 180.0;
            int costheta = (int)(8192.0 * Math.cos(thetarad) + 0.5);
            int sintheta = (int)(8192.0 * Math.sin(thetarad) + 0.5);
            this.projArray = (byte[])this.stack2.getPixels(n + 1);
            if (this.projArray == null) break;
            if (projectionMethod == 0 || opacity > 0) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.zBuffer[i3] = Short.MAX_VALUE;
                }
            }
            if (opacity > 0 && projectionMethod != 0) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.opaArray[i3] = 0;
                }
            }
            if (projectionMethod == 1 && depthCueInt < 100) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.brightCueArray[i3] = 0;
                }
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.cueZBuffer[i3] = 0;
                }
            }
            if (projectionMethod == 2) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.sumBuffer[i3] = 0;
                }
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.countBuffer[i3] = 0;
                }
            }
            switch (axisOfRotation) {
                case 0: {
                    this.doOneProjectionX(nSlices, ycenter, zcenter, projwidth, projheight, costheta, sintheta);
                    break;
                }
                case 1: {
                    this.doOneProjectionY(nSlices, xcenter, zcenter, projwidth, projheight, costheta, sintheta);
                    break;
                }
                case 2: {
                    this.doOneProjectionZ(nSlices, xcenter, ycenter, zcenter, projwidth, projheight, costheta, sintheta);
                }
            }
            if (projectionMethod == 2) {
                for (i = 0; i < projsize; ++i) {
                    short count = this.countBuffer[i];
                    if (count == 0) continue;
                    this.projArray[i] = (byte)(this.sumBuffer[i] / count);
                }
            }
            if (opacity > 0 && projectionMethod != 0) {
                for (i3 = 0; i3 < projsize; ++i3) {
                    this.projArray[i3] = (byte)((opacity * (this.opaArray[i3] & 0xFF) + (100 - opacity) * (this.projArray[i3] & 0xFF)) / 100);
                }
            }
            if (axisOfRotation == 2) {
                for (i3 = projwidth; i3 < projsize - projwidth; ++i3) {
                    int curval = this.projArray[i3] & 0xFF;
                    int prevval = this.projArray[i3 - 1] & 0xFF;
                    int nextval = this.projArray[i3 + 1] & 0xFF;
                    int aboveval = this.projArray[i3 - projwidth] & 0xFF;
                    int belowval = this.projArray[i3 + projwidth] & 0xFF;
                    if (curval != 0 || prevval == 0 || nextval == 0 || aboveval == 0 || belowval == 0) continue;
                    this.projArray[i3] = (byte)((prevval + nextval + aboveval + belowval) / 4);
                }
            }
            theta = (theta + angleInc) % 360;
            if (projections.getWindow() == null && IJ.getInstance() != null && !this.batchMode) {
                this.done = true;
                break;
            }
            if (IJ.escapePressed()) {
                this.done = true;
                break;
            }
            projections.setSlice(n + 1);
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            break;
        }
        if (!this.batchMode) {
            IJ.showProgress(1.0);
        }
        if (debugMode) {
            if (this.projArray != null) {
                new ImagePlus("projArray", new ByteProcessor(projwidth, projheight, this.projArray, null)).show();
            }
            if (this.opaArray != null) {
                new ImagePlus("opaArray", new ByteProcessor(projwidth, projheight, this.opaArray, null)).show();
            }
            if (this.brightCueArray != null) {
                new ImagePlus("brightCueArray", new ByteProcessor(projwidth, projheight, this.brightCueArray, null)).show();
            }
            if (this.zBuffer != null) {
                new ImagePlus("zBuffer", new ShortProcessor(projwidth, projheight, this.zBuffer, null)).show();
            }
            if (this.cueZBuffer != null) {
                new ImagePlus("cueZBuffer", new ShortProcessor(projwidth, projheight, this.cueZBuffer, null)).show();
            }
            if (this.countBuffer != null) {
                new ImagePlus("countBuffer", new ShortProcessor(projwidth, projheight, this.countBuffer, null)).show();
            }
            if (this.sumBuffer != null) {
                float[] tmp = new float[projwidth * projheight];
                for (i = 0; i < projwidth * projheight; ++i) {
                    tmp[i] = this.sumBuffer[i];
                }
                new ImagePlus("sumBuffer", new FloatProcessor(projwidth, projheight, tmp, null)).show();
            }
        }
        return projections;
    }

    void allocateArrays(int nProjections, int projwidth, int projheight) {
        int projsize = projwidth * projheight;
        ColorModel cm = this.imp.getProcessor().getColorModel();
        if (this.isRGB) {
            cm = null;
        }
        this.stack2 = new ImageStack(projwidth, projheight, cm);
        this.projArray = new byte[projsize];
        for (int i = 0; i < nProjections; ++i) {
            this.stack2.addSlice(null, new byte[projsize]);
        }
        if (projectionMethod == 0 || opacity > 0) {
            this.zBuffer = new short[projsize];
        }
        if (opacity > 0 && projectionMethod != 0) {
            this.opaArray = new byte[projsize];
        }
        if (projectionMethod == 1 && depthCueInt < 100) {
            this.brightCueArray = new byte[projsize];
            this.cueZBuffer = new short[projsize];
        }
        if (projectionMethod == 2) {
            this.sumBuffer = new int[projsize];
            this.countBuffer = new short[projsize];
        }
    }

    void doOneProjectionX(int nSlices, int ycenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = zcenter + projheight / 2;
        int zmin = zcenter - projheight / 2;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - depthCueInt;
        int c100minusDepthCueSurf = 100 - depthCueSurf;
        boolean DepthCueIntLessThan100 = depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = depthCueSurf < 100;
        boolean OpacityOrNearestPt = projectionMethod == 0 || opacity > 0;
        boolean OpacityAndNotNearestPt = opacity > 0 && projectionMethod != 0;
        boolean MeanVal = projectionMethod == 2;
        boolean BrightestPt = projectionMethod == 1;
        int ycosthetainit = (this.top - ycenter - 1) * costheta;
        int ysinthetainit = (this.top - ycenter - 1) * sintheta;
        int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - 1;
        for (int k = 1; k <= nSlices; ++k) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * this.sliceInterval + 0.5) - zcenter;
            int zcostheta = z * costheta;
            int zsintheta = z * sintheta;
            int ycostheta = ycosthetainit;
            int ysintheta = ysinthetainit;
            for (int j = this.top; j < this.bottom; ++j) {
                int ynew = ((ycostheta += costheta) - zsintheta) / 8192 + ycenter - this.top;
                int znew = ((ysintheta += sintheta) + zcostheta) / 8192 + zcenter;
                int offset = offsetinit + ynew * projwidth;
                int lineIndex = j * this.imageWidth;
                for (int i = this.left; i < this.right; ++i) {
                    int thispixel = pixels[lineIndex + i] & 0xFF;
                    if (++offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (thispixel > this.transparencyUpper || thispixel < this.transparencyLower) continue;
                    if (OpacityOrNearestPt && znew < this.zBuffer[offset]) {
                        this.zBuffer[offset] = (short)znew;
                        if (OpacityAndNotNearestPt) {
                            this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        } else {
                            this.projArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        }
                    }
                    if (MeanVal) {
                        int n = offset;
                        this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                        int n2 = offset;
                        this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        continue;
                    }
                    if (!BrightestPt) continue;
                    if (DepthCueIntLessThan100) {
                        if (thispixel <= (this.brightCueArray[offset] & 0xFF) && (thispixel != (this.brightCueArray[offset] & 0xFF) || znew <= this.cueZBuffer[offset])) continue;
                        this.brightCueArray[offset] = (byte)thispixel;
                        this.cueZBuffer[offset] = (short)znew;
                        this.projArray[offset] = (byte)(depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - znew) / zmaxminuszmintimes100);
                        continue;
                    }
                    if (thispixel <= (this.projArray[offset] & 0xFF)) continue;
                    this.projArray[offset] = (byte)thispixel;
                }
            }
        }
    }

    void doOneProjectionY(int nSlices, int xcenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = zcenter + projwidth / 2;
        int zmin = zcenter - projwidth / 2;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - depthCueInt;
        int c100minusDepthCueSurf = 100 - depthCueSurf;
        boolean DepthCueIntLessThan100 = depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = depthCueSurf < 100;
        boolean OpacityOrNearestPt = projectionMethod == 0 || opacity > 0;
        boolean OpacityAndNotNearestPt = opacity > 0 && projectionMethod != 0;
        boolean MeanVal = projectionMethod == 2;
        boolean BrightestPt = projectionMethod == 1;
        int xcosthetainit = (this.left - xcenter - 1) * costheta;
        int xsinthetainit = (this.left - xcenter - 1) * sintheta;
        for (int k = 1; k <= nSlices; ++k) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * this.sliceInterval + 0.5) - zcenter;
            int zcostheta = z * costheta;
            int zsintheta = z * sintheta;
            int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - projwidth;
            for (int j = this.top; j < this.bottom; ++j) {
                int xcostheta = xcosthetainit;
                int xsintheta = xsinthetainit;
                offsetinit += projwidth;
                int lineOffset = j * this.imageWidth;
                for (int i = this.left; i < this.right; ++i) {
                    int thispixel = pixels[lineOffset + i] & 0xFF;
                    xcostheta += costheta;
                    xsintheta += sintheta;
                    if (thispixel > this.transparencyUpper || thispixel < this.transparencyLower) continue;
                    int xnew = (xcostheta + zsintheta) / 8192 + xcenter - this.left;
                    int znew = (zcostheta - xsintheta) / 8192 + zcenter;
                    int offset = offsetinit + xnew;
                    if (offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (OpacityOrNearestPt && znew < this.zBuffer[offset]) {
                        this.zBuffer[offset] = (short)znew;
                        if (OpacityAndNotNearestPt) {
                            this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        } else {
                            this.projArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                        }
                    }
                    if (MeanVal) {
                        int n = offset;
                        this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                        int n2 = offset;
                        this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        continue;
                    }
                    if (!BrightestPt) continue;
                    if (DepthCueIntLessThan100) {
                        if (thispixel <= (this.brightCueArray[offset] & 0xFF) && (thispixel != (this.brightCueArray[offset] & 0xFF) || znew <= this.cueZBuffer[offset])) continue;
                        this.brightCueArray[offset] = (byte)thispixel;
                        this.cueZBuffer[offset] = (short)znew;
                        this.projArray[offset] = (byte)(depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - znew) / zmaxminuszmintimes100);
                        continue;
                    }
                    if (thispixel <= (this.projArray[offset] & 0xFF)) continue;
                    this.projArray[offset] = (byte)thispixel;
                }
            }
        }
    }

    void doOneProjectionZ(int nSlices, int xcenter, int ycenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = (int)((double)(nSlices - 1) * this.sliceInterval + 0.5) - zcenter;
        int zmin = -zcenter;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - depthCueInt;
        int c100minusDepthCueSurf = 100 - depthCueSurf;
        boolean DepthCueIntLessThan100 = depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = depthCueSurf < 100;
        boolean OpacityOrNearestPt = projectionMethod == 0 || opacity > 0;
        boolean OpacityAndNotNearestPt = opacity > 0 && projectionMethod != 0;
        boolean MeanVal = projectionMethod == 2;
        boolean BrightestPt = projectionMethod == 1;
        int xcosthetainit = (this.left - xcenter - 1) * costheta;
        int xsinthetainit = (this.left - xcenter - 1) * sintheta;
        int ycosthetainit = (this.top - ycenter - 1) * costheta;
        int ysinthetainit = (this.top - ycenter - 1) * sintheta;
        int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - 1;
        for (int k = 1; k <= nSlices; ++k) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * this.sliceInterval + 0.5) - zcenter;
            int ycostheta = ycosthetainit;
            int ysintheta = ysinthetainit;
            for (int j = this.top; j < this.bottom; ++j) {
                ycostheta += costheta;
                ysintheta += sintheta;
                int xcostheta = xcosthetainit;
                int xsintheta = xsinthetainit;
                int lineIndex = j * this.imageWidth;
                for (int i = this.left; i < this.right; ++i) {
                    int thispixel = pixels[lineIndex + i] & 0xFF;
                    xcostheta += costheta;
                    xsintheta += sintheta;
                    if (thispixel > this.transparencyUpper || thispixel < this.transparencyLower) continue;
                    int ynew = (xsintheta + ycostheta) / 8192 + ycenter - this.top;
                    int xnew = (xcostheta - ysintheta) / 8192 + xcenter - this.left;
                    int offset = offsetinit + ynew * projwidth + xnew;
                    if (offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (OpacityOrNearestPt && z < this.zBuffer[offset]) {
                        this.zBuffer[offset] = (short)z;
                        if (OpacityAndNotNearestPt) {
                            this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - z) / zmaxminuszmintimes100) : (byte)thispixel;
                        } else if (DepthCueSurfLessThan100) {
                            int v = depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - z) / zmaxminuszmintimes100;
                            this.projArray[offset] = (byte)v;
                        } else {
                            this.projArray[offset] = (byte)thispixel;
                        }
                    }
                    if (MeanVal) {
                        int n = offset;
                        this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                        int n2 = offset;
                        this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        continue;
                    }
                    if (!BrightestPt) continue;
                    if (DepthCueIntLessThan100) {
                        if (thispixel <= (this.brightCueArray[offset] & 0xFF) && (thispixel != (this.brightCueArray[offset] & 0xFF) || z <= this.cueZBuffer[offset])) continue;
                        this.brightCueArray[offset] = (byte)thispixel;
                        this.cueZBuffer[offset] = (short)z;
                        this.projArray[offset] = (byte)(depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - z) / zmaxminuszmintimes100);
                        continue;
                    }
                    if (thispixel <= (this.projArray[offset] & 0xFF)) continue;
                    this.projArray[offset] = (byte)thispixel;
                }
            }
        }
    }

    ImagePlus zScale(ImagePlus imp) {
        IJ.showStatus("Z Scaling...");
        ImageStack stack1 = imp.getStack();
        int depth1 = stack1.getSize();
        ImagePlus imp2 = null;
        String title = imp.getTitle();
        ImageProcessor ip = imp.getProcessor();
        ColorModel cm = ip.getColorModel();
        int width1 = imp.getWidth();
        int height1 = imp.getHeight();
        Rectangle r = ip.getRoi();
        int width2 = r.width;
        int height2 = r.height;
        int depth2 = (int)((double)stack1.getSize() * this.sliceInterval + 0.5);
        imp2 = NewImage.createImage(title, width2, height2, depth2, this.isRGB ? 24 : 8, 1);
        if (imp2 == null || depth2 != imp2.getStackSize()) {
            return null;
        }
        ImageStack stack2 = imp2.getStack();
        ImageProcessor xzPlane1 = ip.createProcessor(width2, depth1);
        xzPlane1.setInterpolate(true);
        int[] line = new int[width2];
        for (int y = 0; y < height2; ++y) {
            int z;
            for (z = 0; z < depth1; ++z) {
                if (this.isRGB) {
                    this.getRGBRow(stack1, r.x, r.y + y, z, width1, width2, line);
                } else {
                    this.getByteRow(stack1, r.x, r.y + y, z, width1, width2, line);
                }
                xzPlane1.putRow(0, z, line, width2);
            }
            ImageProcessor xzPlane2 = xzPlane1.resize(width2, depth2);
            for (z = 0; z < depth2; ++z) {
                xzPlane2.getRow(0, z, line, width2);
                if (this.isRGB) {
                    this.putRGBRow(stack2, y, z, width2, line);
                    continue;
                }
                this.putByteRow(stack2, y, z, width2, line);
            }
            if (this.batchMode) continue;
            IJ.showProgress(y, height2 - 1);
        }
        ImageProcessor ip2 = imp2.getProcessor();
        ip2.setColorModel(cm);
        return imp2;
    }

    public void getByteRow(ImageStack stack, int x, int y, int z, int width1, int width2, int[] line) {
        byte[] pixels = (byte[])stack.getPixels(z + 1);
        int j = x + y * width1;
        for (int i = 0; i < width2; ++i) {
            line[i] = pixels[j++] & 0xFF;
        }
    }

    public void putByteRow(ImageStack stack, int y, int z, int width, int[] line) {
        byte[] pixels = (byte[])stack.getPixels(z + 1);
        int j = y * width;
        for (int i = 0; i < width; ++i) {
            pixels[j++] = (byte)line[i];
        }
    }

    public void getRGBRow(ImageStack stack, int x, int y, int z, int width1, int width2, int[] line) {
        int[] pixels = (int[])stack.getPixels(z + 1);
        int j = x + y * width1;
        for (int i = 0; i < width2; ++i) {
            line[i] = pixels[j++];
        }
    }

    public void putRGBRow(ImageStack stack, int y, int z, int width, int[] line) {
        int[] pixels = (int[])stack.getPixels(z + 1);
        int j = y * width;
        for (int i = 0; i < width; ++i) {
            pixels[j++] = line[i];
        }
    }
}

