/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.grid.AbstractFilterField;
import ch.systemsx.cisd.cifex.client.application.model.AbstractDataGridModel;
import ch.systemsx.cisd.cifex.client.application.ui.EmailLinkRenderer;
import ch.systemsx.cisd.cifex.client.application.ui.FileCountRenderer;
import ch.systemsx.cisd.cifex.client.application.ui.FileSizeRenderer;
import ch.systemsx.cisd.cifex.client.application.ui.UserDescriptionRenderer;
import ch.systemsx.cisd.cifex.client.application.utils.DateTimeUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractUserGridModel
extends AbstractDataGridModel {
    private static final long serialVersionUID = 1L;
    public static final String USER_CODE = "userCode";
    public static final String USER_EMAIL = "userEmail";
    public static final String FULL_NAME = "fullName";
    public static final String STATUS = "status";
    public static final String ACTIVE = "active";
    public static final String FILE_SIZE = "fileSize";
    public static final String FILE_COUNT = "fileCount";
    public static final String QUOTA_SIZE = "quotaSize";
    public static final String QUOTA_COUNT = "quotaCount";
    public static final String REGISTRATOR = "registrator";
    public static final String ACTION = "action";
    protected final UserInfoDTO currentUser;

    public static <M extends ModelData> List<AbstractFilterField<M>> createFilterItems(List<ColumnConfig> columnConfigs) {
        return AbstractUserGridModel.createFilterItems(columnConfigs, AbstractUserGridModel.getInitialFilters());
    }

    private static List<String> getInitialFilters() {
        return Arrays.asList(USER_CODE, FULL_NAME, STATUS);
    }

    public AbstractUserGridModel(UserInfoDTO currentUser) {
        this.currentUser = currentUser;
    }

    protected static final ColumnConfig createActionColumnConfig() {
        ColumnConfig actionColumn = AbstractUserGridModel.createSortableColumnConfig(ACTION, MessageDictionary.msg(MessageDictionary.LIST_USERSFILES_ACTIONS_COLUMN_HEADER), 200);
        return actionColumn;
    }

    protected static final ColumnConfig createUserCodeColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createSortableColumnConfig(USER_CODE, MessageDictionary.msg(MessageDictionary.USER_ID_LABEL), 180);
        return columnConfig;
    }

    protected static final ColumnConfig createUserEmailColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createSortableColumnConfig(USER_EMAIL, MessageDictionary.msg(MessageDictionary.LIST_USERS_EMAIL_COLUMN_HEADER), 180);
        columnConfig.setRenderer((GridCellRenderer)EmailLinkRenderer.USER_RENDERER);
        return columnConfig;
    }

    protected static final ColumnConfig createTotalFileSizeColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createSortableColumnConfig(FILE_SIZE, MessageDictionary.msg(MessageDictionary.LIST_USERS_FILESIZE_COLUMN_HEADER), 80);
        columnConfig.setRenderer((GridCellRenderer)FileSizeRenderer.FILE_SIZE_NULL_AS_MISSING_RENDERER);
        return columnConfig;
    }

    protected static final ColumnConfig createTotalFileCountColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createSortableColumnConfig(FILE_COUNT, MessageDictionary.msg(MessageDictionary.LIST_USERS_FILECOUNT_COLUMN_HEADER), 60);
        columnConfig.setRenderer((GridCellRenderer)FileCountRenderer.FILE_COUNT_RENDERER);
        return columnConfig;
    }

    protected static final ColumnConfig createRegistratorColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createColumnConfig(REGISTRATOR, MessageDictionary.msg(MessageDictionary.LIST_USERS_CREATOR_COLUMN_HEADER), 180);
        columnConfig.setRenderer((GridCellRenderer)UserDescriptionRenderer.USER_DESCRIPTION_RENDERER);
        return columnConfig;
    }

    protected static final ColumnConfig createStatusColumnConfig() {
        return AbstractUserGridModel.createSortableColumnConfig(STATUS, MessageDictionary.msg(MessageDictionary.LIST_USERS_STATUS_COLUMN_HEADER), 200);
    }

    protected static final ColumnConfig createActiveColumnConfig() {
        return AbstractUserGridModel.createSortableColumnConfig(ACTIVE, MessageDictionary.msg(MessageDictionary.USER_ACTIVE_LABEL), 80);
    }

    protected static final ColumnConfig createFullNameColumnConfig() {
        return AbstractUserGridModel.createSortableColumnConfig(FULL_NAME, MessageDictionary.msg(MessageDictionary.LIST_USERS_FULLNAME_COLUMN_HEADER), 180);
    }

    protected static final ColumnConfig createQuotaSizeColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createSortableColumnConfig(QUOTA_SIZE, MessageDictionary.msg(MessageDictionary.LIST_USERS_QUOTASIZE_COLUMN_HEADER), 80);
        columnConfig.setRenderer((GridCellRenderer)FileSizeRenderer.FILE_SIZE_NULL_AS_MISSING_RENDERER);
        columnConfig.setHidden(true);
        return columnConfig;
    }

    protected static final ColumnConfig createQuotaCountColumnConfig() {
        ColumnConfig columnConfig = AbstractUserGridModel.createSortableColumnConfig(QUOTA_COUNT, MessageDictionary.msg(MessageDictionary.LIST_USERS_QUOTACOUNT_COLUMN_HEADER), 80);
        columnConfig.setRenderer((GridCellRenderer)FileCountRenderer.FILE_COUNT_RENDERER);
        columnConfig.setHidden(true);
        return columnConfig;
    }

    protected final String getUserRoleDescription(UserInfoDTO user) {
        String stateField = "";
        if (user.isAdmin()) {
            stateField = MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_ADMIN_LABEL);
        } else if (user.isPermanent()) {
            stateField = String.valueOf(stateField) + MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_REGULAR_LABEL);
        } else {
            String expirationDate = user.getExpirationDate() != null ? DateTimeUtils.formatDate(user.getExpirationDate()) : "???";
            stateField = String.valueOf(stateField) + MessageDictionary.msg(MessageDictionary.CREATE_USER_ROLE_TEMP_LABEL, expirationDate);
        }
        return stateField;
    }
}

