/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.model.AbstractUserGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.DOMUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

public final class UserGridModel
extends AbstractUserGridModel {
    private static final long serialVersionUID = 1L;
    private static final long MB = 0x100000L;

    public UserGridModel(ViewContext viewContext, UserInfoDTO user) {
        super(viewContext.getModel().getUser());
        this.set("id", user.getID());
        this.set("userCode", user.getUserCode());
        this.set("userEmail", user.getEmail());
        this.set("fullName", user.getUserFullName());
        this.set("fileSize", user.getCurrentFileSize());
        this.set("fileCount", user.getCurrentFileCount());
        this.set("status", this.getUserRoleDescription(user));
        this.set("active", new Boolean(user.isActive()));
        this.set("quotaSize", this.getMaxFileSizePerQuotaGroup(user));
        this.set("quotaCount", this.getMaxFileCountPerQuotaGroup(user));
        this.set("registrator", user.getRegistrator());
        this.set("action", this.listActionsForUser(user));
    }

    private Long getMaxFileSizePerQuotaGroup(UserInfoDTO user) {
        if (user.isCustomMaxFileSizePerQuotaGroup()) {
            Long value = user.getMaxFileSizePerQuotaGroupInMB();
            if (value == null) {
                return Long.MAX_VALUE;
            }
            return value * 0x100000L;
        }
        return null;
    }

    private Integer getMaxFileCountPerQuotaGroup(UserInfoDTO user) {
        if (user.isCustomMaxFileCountPerQuotaGroup()) {
            Integer value = user.getMaxFileCountPerQuotaGroup();
            if (value == null) {
                return Integer.MAX_VALUE;
            }
            return value;
        }
        return null;
    }

    @Override
    public long getID() {
        return (Long)this.get("id");
    }

    public static final List<UserGridModel> convert(ViewContext context, List<UserInfoDTO> users) {
        ArrayList<UserGridModel> result = new ArrayList<UserGridModel>();
        for (UserInfoDTO user : users) {
            result.add(new UserGridModel(context, user));
        }
        return result;
    }

    public static final List<ColumnConfig> getColumnConfigs(boolean adminGrid) {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(UserGridModel.createIdColumnConfig());
        configs.add(UserGridModel.createUserCodeColumnConfig());
        configs.add(UserGridModel.createUserEmailColumnConfig());
        if (adminGrid) {
            configs.add(UserGridModel.createTotalFileSizeColumnConfig());
            configs.add(UserGridModel.createTotalFileCountColumnConfig());
        }
        configs.add(UserGridModel.createFullNameColumnConfig());
        configs.add(UserGridModel.createStatusColumnConfig());
        configs.add(UserGridModel.createActiveColumnConfig());
        if (adminGrid) {
            configs.add(UserGridModel.createQuotaSizeColumnConfig());
            configs.add(UserGridModel.createQuotaCountColumnConfig());
            configs.add(UserGridModel.createRegistratorColumnConfig());
        }
        configs.add(UserGridModel.createActionColumnConfig());
        return configs;
    }

    protected String listActionsForUser(UserInfoDTO user) {
        String actionLabel = DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_EDIT_LABEL), "edit");
        if (!user.equals(this.currentUser) && this.currentUser.isAdmin() && !user.isExternallyAuthenticated()) {
            actionLabel = String.valueOf(actionLabel) + " | " + DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_RENAME_LABEL), "change_user_code");
        }
        if (!user.equals(this.currentUser)) {
            actionLabel = String.valueOf(actionLabel) + " | " + DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_DELETE_LABEL), "delete");
        }
        return actionLabel;
    }
}

