/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.server.business.AbstractEMailBuilder;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.mail.IMailClient;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class EMailBuilderForUploadedFiles
extends AbstractEMailBuilder {
    private static final String FILE_FOR_DOWNLOAD_SUBJECT_LINE = "file-for-download-subject";
    private static final String FILE_FOR_DOWNLOAD_EMAIL_TEMPLATE_FILE_NAME = "etc/file-for-download-email.template";
    private final List<FileDTO> files = new ArrayList<FileDTO>();
    private String userCode;

    public EMailBuilderForUploadedFiles(IMailClient mailClient, UserDTO registrator, String email) {
        super(mailClient, registrator, email);
    }

    public void addFile(FileDTO file) {
        this.files.add(file);
    }

    public final void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @Override
    protected String createContent() {
        assert (this.files.size() > 0) : "No files to upload.";
        assert (this.userCode != null) : "Missing user code";
        return this.createContent(FILE_FOR_DOWNLOAD_EMAIL_TEMPLATE_FILE_NAME);
    }

    private StringBuilder addFileSection(StringBuilder builder) {
        for (FileDTO file : this.files) {
            builder.append(file.getName()).append("  ");
            this.addURL(builder, "fileId", file.getID(), "user", this.userCode);
            builder.append("\n");
        }
        return builder;
    }

    @Override
    protected Date tryGetExpirationDate() {
        Date minExpirationDate = new Date(Long.MAX_VALUE);
        for (FileDTO file : this.files) {
            Date expirationDate = file.getExpirationDate();
            if (expirationDate.getTime() >= minExpirationDate.getTime()) continue;
            minExpirationDate = expirationDate;
        }
        return minExpirationDate;
    }

    @Override
    protected String createSubject() {
        assert (this.files.size() > 0) : "No files to upload.";
        return StringUtils.capitalize((String)((String)this.emailDict.get(FILE_FOR_DOWNLOAD_SUBJECT_LINE)));
    }

    @Override
    protected String getUserCode() {
        return this.userCode;
    }

    @Override
    protected void addToDict(Properties emailProps, DateFormat dateFormat) {
        if (this.files.size() == 1) {
            this.emailDict.put("one-or-more-files", emailProps.getProperty("one-file"));
            this.emailDict.put("one-or-more-files2", emailProps.getProperty("one-file2"));
            this.emailDict.put("one-or-more-files3", emailProps.getProperty("one-file3"));
        } else {
            this.emailDict.put("one-or-more-files", emailProps.getProperty("multiple-files"));
            this.emailDict.put("one-or-more-files2", emailProps.getProperty("multiple-files2"));
            this.emailDict.put("one-or-more-files3", emailProps.getProperty("multiple-files3"));
        }
        this.emailDict.put("file-section", this.addFileSection(new StringBuilder()).toString());
    }
}

