/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.dataaccess.db.h2;

import java.sql.Connection;
import java.sql.SQLException;

public class AccountingStoredProcedures {
    public static void calcAccountingForAllQuotaGroups(Connection conn) throws SQLException {
        boolean startNewTransaction = conn.getAutoCommit();
        if (startNewTransaction) {
            conn.setAutoCommit(false);
        }
        conn.createStatement().execute("UPDATE QUOTA_GROUPS Q SET FILE_COUNT = (SELECT COUNT(*) FROM FILES F JOIN USERS U ON F.USER_ID = U.ID WHERE U.QUOTA_GROUP_ID = Q.ID)");
        conn.createStatement().execute("UPDATE QUOTA_GROUPS Q SET FILE_SIZE = (SELECT COALESCE(SUM(F.COMPLETE_SIZE), 0) FROM FILES F JOIN USERS U ON F.USER_ID = U.ID WHERE U.QUOTA_GROUP_ID = Q.ID)");
        if (startNewTransaction) {
            conn.commit();
        }
    }

    public static void calcAccountingForQuotaGroups(Connection conn, long ... quotaGroupIds) throws SQLException {
        boolean startNewTransaction = conn.getAutoCommit();
        if (startNewTransaction) {
            conn.setAutoCommit(false);
        }
        long[] lArray = quotaGroupIds;
        int n = quotaGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long quotaGroupId = lArray[n2];
            conn.createStatement().execute("UPDATE QUOTA_GROUPS Q SET FILE_COUNT = (SELECT COUNT(*) FROM FILES F JOIN USERS U ON F.USER_ID = U.ID WHERE U.QUOTA_GROUP_ID = Q.ID) WHERE Q.ID = " + quotaGroupId);
            conn.createStatement().execute("UPDATE QUOTA_GROUPS Q SET FILE_SIZE = (SELECT COALESCE(SUM(F.COMPLETE_SIZE), 0) FROM FILES F JOIN USERS U ON F.USER_ID = U.ID WHERE U.QUOTA_GROUP_ID = Q.ID) WHERE Q.ID = " + quotaGroupId);
            ++n2;
        }
        if (startNewTransaction) {
            conn.commit();
        }
    }
}

