/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.ArrayDataSetCache;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.DataSetCache;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.util.AbstractResultSetWrapper;
import net.lemnik.eodsql.spi.util.ConnectedDataSet;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.DisconnectedDataSet;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;
import net.lemnik.eodsql.spi.util.UpdatableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetWrapper
extends ResultSetWrapper<DataSet> {
    public static final String PARAMETER_DISCONNECTED = "net.lemnik.eodsql.spi.util.DataSetWrapper#disconnected";
    public static final String PARAMETER_UPDATABLE = "net.lemnik.eodsql.spi.util.DataSetWrapper#updatable";
    public static final String PARAMETER_CACHE_CLASS = "net.lemnik.eodsql.spi.util.DataSetWrapper#cacheClass";
    private boolean disconnected = false;
    private boolean updatable = false;
    private Class<? extends DataSetCache> cacheClass = ArrayDataSetCache.class;
    private DataObjectBinding binding;

    private DataSetWrapper(Class clazz, Map<String, Object> map) {
        if (map.containsKey("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding")) {
            DataObjectBinding dataObjectBinding = (DataObjectBinding)map.get("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding");
            dataObjectBinding.setObjectType(clazz);
            this.binding = dataObjectBinding;
        } else {
            this.binding = DataObjectBinding.getDataObjectBinding(clazz, AbstractResultSetWrapper.getBindingType(map));
        }
        this.disconnected = DataSetWrapper.isDisconnected(map);
        this.updatable = DataSetWrapper.isUpdatable(map);
        if (map.containsKey(PARAMETER_CACHE_CLASS)) {
            this.cacheClass = (Class)map.get(PARAMETER_CACHE_CLASS);
            if (!DataSetCache.class.isAssignableFrom(this.cacheClass)) {
                throw new IllegalArgumentException("The Cache Class parameter must be a Class of type DataSetCache.");
            }
        }
    }

    private DataSetCache createCache() throws SQLException {
        try {
            return this.cacheClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw (SQLException)new SQLException().initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (SQLException)new SQLException().initCause(illegalAccessException);
        }
    }

    private static boolean isDisconnected(Map<String, Object> map) {
        if (map.containsKey(PARAMETER_DISCONNECTED)) {
            return map.get(PARAMETER_DISCONNECTED).equals(Boolean.TRUE);
        }
        return false;
    }

    private static boolean isUpdatable(Map<String, Object> map) {
        if (map.containsKey(PARAMETER_UPDATABLE)) {
            return map.get(PARAMETER_UPDATABLE).equals(Boolean.TRUE);
        }
        return false;
    }

    @Override
    public DataSet wrap(Context context) throws SQLException {
        if (this.disconnected) {
            DisconnectedDataSet disconnectedDataSet = new DisconnectedDataSet(this.binding, context);
            return disconnectedDataSet;
        }
        if (this.updatable) {
            context.setAutoclose(false);
            UpdatableDataSet updatableDataSet = new UpdatableDataSet(this.binding, context, this.createCache());
            return updatableDataSet;
        }
        context.setAutoclose(false);
        ConnectedDataSet connectedDataSet = new ConnectedDataSet(this.binding, context, this.createCache());
        return connectedDataSet;
    }

    @Override
    public int getPreferredResultSetConcurrency() {
        return this.updatable ? 1008 : 1007;
    }

    @Override
    public int getPreferredResultSetType() {
        return this.updatable ? 1005 : 1004;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Factory
    implements ResultSetWrapper.Factory {
        private static final Set<Class> DATA_SET_TYPE = Collections.singleton(DataSet.class);

        Factory() {
        }

        @Override
        public boolean isTypeConstructable(Type type, Map<String, Object> map) throws InvalidQueryException {
            DataObjectBinding<?> dataObjectBinding;
            Class<?> clazz = AbstractResultSetWrapper.getDataObjectClass(type, DATA_SET_TYPE);
            if (clazz == null) {
                return false;
            }
            if (map.containsKey(DataSetWrapper.PARAMETER_CACHE_CLASS)) {
                dataObjectBinding = map.get(DataSetWrapper.PARAMETER_CACHE_CLASS);
                if (!(dataObjectBinding instanceof Class) || !DataSetCache.class.isAssignableFrom((Class)((Object)dataObjectBinding))) {
                    throw new InvalidQueryException("Parameter 'net.lemnik.eodsql.spi.util.DataSetWrapper#cacheClass' must be a Class<? extends DataSetCache>");
                }
                this.validateDataSetCache((Class)((Object)dataObjectBinding));
            }
            if (DataSetWrapper.isUpdatable(map)) {
                if (DataSetWrapper.isDisconnected(map)) {
                    throw new InvalidQueryException("A disconnected DataSet may not be updatable.");
                }
                dataObjectBinding = DataObjectBinding.getDataObjectBinding(clazz, AbstractResultSetWrapper.getBindingType(map));
                if (!dataObjectBinding.isUpdateCapable()) {
                    throw new InvalidDataTypeException("DataSet is updatable, but the data-type is not able to update.", clazz);
                }
            }
            return true;
        }

        private void validateDataSetCache(Class<? extends DataSetCache> clazz) {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvalidQueryException("Cannot find a null constrcutor in type: " + clazz.getName());
            }
            catch (SecurityException securityException) {
                throw new InvalidQueryException("Cannot access the null constrcutor in type: " + clazz.getName() + ", try making it public.");
            }
        }

        @Override
        public ResultSetWrapper create(Type type, Map<String, Object> map) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> clazz = ResultSetWrapper.toClass(parameterizedType.getActualTypeArguments()[0]);
            return new DataSetWrapper(clazz, map);
        }
    }
}

