/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.DisplaySettingsSerializationUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="persons", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "dbin_id"})})
@Friend(toClasses={RoleAssignmentPE.class})
public final class PersonPE
extends HibernateAbstractRegistrationHolder
implements Comparable<PersonPE>,
IIdHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    private static final String USER_CODE_REGEX = "^([a-zA-Z0-9_\\.\\-\\@])+$";
    public static final String SYSTEM_USER_ID = "system";
    private SpacePE homeSpace;
    private transient Long id;
    private String userId;
    private String firstName;
    private String lastName;
    private String email;
    private boolean systemUser;
    private DatabaseInstancePE databaseInstance;
    private Set<RoleAssignmentPE> roleAssignments = new HashSet<RoleAssignmentPE>();
    private Set<AuthorizationGroupPE> authorizationGroups = new HashSet<AuthorizationGroupPE>();
    private DisplaySettings displaySettings;
    private byte[] serializedDisplaySettings;
    private boolean active;

    private final void setSystemUser(boolean systemUser) {
        this.systemUser = systemUser;
    }

    @Column(name="first_name")
    @Length(max=30, message="Given first name '%s' is too long (maximal length: {max} characters).")
    @Field(index=Index.TOKENIZED, name="First Name", store=Store.YES)
    public final String getFirstName() {
        return this.firstName;
    }

    public final void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="last_name")
    @Length(max=30, message="Given last name '%s' is too long (maximal length: {max} characters).")
    @Field(index=Index.TOKENIZED, name="Last Name", store=Store.YES)
    public final String getLastName() {
        return this.lastName;
    }

    public final void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Email(message="Given email address '%s' is not a valid one.")
    @Length(max=50, message="Given email address '%s' is too long (maximal length: {max} characters).")
    @Field(index=Index.NO, name="Email", store=Store.YES)
    public final String getEmail() {
        return this.email;
    }

    public final void setEmail(String email) {
        this.email = email;
    }

    @Column(name="user_id")
    @Length(max=50, message="Given user id '%s' is too long (maximal length: {max} characters).")
    @NotNull(message="User id can not be null.")
    @Pattern(regexp="^([a-zA-Z0-9_\\.\\-\\@])+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="User code must not be empty and must contain only allowed characters: letters, digits, '_', '.', '-', '@'. Note that whitespaces are not allowed.")
    @Field(index=Index.TOKENIZED, name="User Id", store=Store.YES)
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(String userId) {
        this.userId = userId;
        this.setSystemUser(SYSTEM_USER_ID.equals(userId));
    }

    @Transient
    public final boolean isSystemUser() {
        return this.systemUser;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public final DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public final void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="space_id")
    public final SpacePE getHomeSpace() {
        return this.homeSpace;
    }

    public final void setHomeSpace(SpacePE homeSpace) {
        this.homeSpace = homeSpace;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="personInternal")
    private final Set<RoleAssignmentPE> getRoleAssignmentsInternal() {
        return this.roleAssignments;
    }

    private final void setRoleAssignmentsInternal(Set<RoleAssignmentPE> rolesAssignments) {
        this.roleAssignments = rolesAssignments;
    }

    public final void setRoleAssignments(Set<RoleAssignmentPE> rolesAssignments) {
        this.getRoleAssignmentsInternal().clear();
        for (RoleAssignmentPE child : rolesAssignments) {
            this.addRoleAssignment(child);
        }
    }

    @Transient
    public final Set<RoleAssignmentPE> getRoleAssignments() {
        return new UnmodifiableSetDecorator<RoleAssignmentPE>(this.getRoleAssignmentsInternal());
    }

    public void addRoleAssignment(RoleAssignmentPE roleAssignment) {
        PersonPE person = roleAssignment.getPerson();
        if (person != null) {
            person.removeRoleAssigment(roleAssignment);
        }
        roleAssignment.setPersonInternal(this);
        this.getRoleAssignmentsInternal().add(roleAssignment);
    }

    public void removeRoleAssigment(RoleAssignmentPE roleAssignment) {
        assert (roleAssignment != null) : "Unspecified role assignment.";
        this.getRoleAssignmentsInternal().remove(roleAssignment);
        roleAssignment.setPersonInternal(null);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="authorization_group_persons", joinColumns={@JoinColumn(name="pers_id", updatable=false)}, inverseJoinColumns={@JoinColumn(name="ag_id", updatable=false)})
    final Set<AuthorizationGroupPE> getAuthorizationGroupsInternal() {
        return this.authorizationGroups;
    }

    private final void setAuthorizationGroupsInternal(Set<AuthorizationGroupPE> authorizationGroups) {
        this.authorizationGroups = authorizationGroups;
    }

    @Transient
    public final void clearAuthorizationGroups() {
        this.authorizationGroups.clear();
    }

    @Transient
    public final Set<AuthorizationGroupPE> getAuthorizationGroups() {
        return new UnmodifiableSetDecorator<AuthorizationGroupPE>(this.getAuthorizationGroupsInternal());
    }

    @Transient
    public DisplaySettings getDisplaySettings() {
        if (this.displaySettings == null) {
            byte[] serializedSettings = this.getSerializedDisplaySettings();
            this.displaySettings = DisplaySettingsSerializationUtils.deserializeOrCreateDisplaySettings(serializedSettings);
        }
        return this.displaySettings;
    }

    public void setDisplaySettings(DisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        this.setSerializedDisplaySettings(DisplaySettingsSerializationUtils.serializeDisplaySettings(displaySettings));
    }

    @Column(name="display_settings", updatable=true)
    @Type(type="org.springframework.orm.hibernate3.support.BlobByteArrayType")
    private byte[] getSerializedDisplaySettings() {
        return this.serializedDisplaySettings;
    }

    private void setSerializedDisplaySettings(byte[] value) {
        this.serializedDisplaySettings = value;
    }

    @Column(name="is_active")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    @Override
    @SequenceGenerator(name="PERSON_ID_SEQ", sequenceName="PERSON_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PERSON_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersonPE)) {
            return false;
        }
        PersonPE that = (PersonPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getUserId(), (Object)that.getUserId());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getUserId());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("userId", (Object)this.userId);
        builder.append("firstName", (Object)this.firstName);
        builder.append("lastName", (Object)this.lastName);
        builder.append("email", (Object)this.email);
        builder.append("systemUser", this.systemUser);
        if (this.serializedDisplaySettings != null) {
            builder.append("displaySettings", (Object)("<" + this.serializedDisplaySettings.length + " bytes>"));
        }
        builder.append((Object)this.getDatabaseInstance());
        return builder.toString();
    }

    @Override
    public final int compareTo(PersonPE o) {
        String thatUserID = o.userId;
        if (this.userId == null) {
            return thatUserID == null ? 0 : -1;
        }
        if (thatUserID == null) {
            return 1;
        }
        return this.userId.compareTo(thatUserID);
    }

    @Transient
    public Set<RoleAssignmentPE> getAllPersonRoles() {
        HashSet<RoleAssignmentPE> result = new HashSet<RoleAssignmentPE>(this.getRoleAssignments());
        for (AuthorizationGroupPE ag : this.getAuthorizationGroups()) {
            result.addAll(ag.getRoleAssignments());
        }
        return result;
    }
}

