/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialTypeTranslator {
    private MaterialTypeTranslator() {
    }

    public static MaterialType translate(MaterialTypePE entityTypeOrNull, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        return MaterialTypeTranslator.translate(entityTypeOrNull, true, cacheOrNull);
    }

    public static MaterialType translate(MaterialTypePE entityTypeOrNull, boolean withProperties, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (entityTypeOrNull == null) {
            return null;
        }
        MaterialType result = MaterialTypeTranslator.translateSimple(entityTypeOrNull);
        if (!withProperties) {
            MaterialTypeTranslator.unsetMaterialTypes(entityTypeOrNull.getMaterialTypePropertyTypes());
        }
        result.setMaterialTypePropertyTypes(EntityType.sortedInternally(MaterialTypePropertyTypeTranslator.translate(entityTypeOrNull.getMaterialTypePropertyTypes(), result, cacheOrNull)));
        result.setValidationScript(ScriptTranslator.translate(entityTypeOrNull.getValidationScript()));
        return result;
    }

    public static MaterialType translateSimple(EntityTypePE entityTypeOrNull) {
        MaterialType result = new MaterialType();
        result.setId(HibernateUtils.getId(entityTypeOrNull));
        result.setCode(entityTypeOrNull.getCode());
        result.setDescription(entityTypeOrNull.getDescription());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(entityTypeOrNull.getDatabaseInstance()));
        return result;
    }

    private static void unsetMaterialTypes(Set<MaterialTypePropertyTypePE> materialTypePropertyTypes) {
        if (HibernateUtils.isInitialized(materialTypePropertyTypes)) {
            for (MaterialTypePropertyTypePE mtpt : materialTypePropertyTypes) {
                mtpt.getPropertyType().setMaterialType(null);
            }
        }
    }

    public static final List<MaterialType> translate(List<MaterialTypePE> materialTypes, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ArrayList<MaterialType> result = new ArrayList<MaterialType>(materialTypes.size());
        for (MaterialTypePE materialType : materialTypes) {
            result.add(MaterialTypeTranslator.translate(materialType, cacheOrNull));
        }
        return result;
    }

    public static MaterialTypePE translate(MaterialType type) {
        MaterialTypePE result = new MaterialTypePE();
        result.setCode(type.getCode());
        return result;
    }
}

