/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsImageUtils;
import ch.systemsx.cisd.imagereaders.bioformats.DefaultBioformatsImageReader;
import java.util.List;
import loci.formats.IFormatReader;

public class BioFormatsReaderLibrary
implements IImageReaderLibrary {
    public static final String SINGLE_IMAGE_PER_FILE_READER_SUFFIX = "##SINGLE_IMAGE";

    public String getName() {
        return "BioFormats";
    }

    public List<String> getReaderNames() {
        return BioFormatsImageUtils.getReaderNames();
    }

    public IImageReader tryGetReader(String readerName) {
        String readerNameToUse = readerName;
        boolean singleImagePerFile = readerName.toUpperCase().endsWith(SINGLE_IMAGE_PER_FILE_READER_SUFFIX);
        if (singleImagePerFile) {
            readerNameToUse = readerName.substring(0, readerName.length() - SINGLE_IMAGE_PER_FILE_READER_SUFFIX.length());
        }
        IFormatReader formatReaderOrNull = BioFormatsImageUtils.tryToCreateReaderByName(readerNameToUse);
        return this.tryAdaptFormatReader(formatReaderOrNull, singleImagePerFile);
    }

    public IImageReader tryGetReaderForFile(String fileName) {
        IFormatReader formatReaderOrNull = BioFormatsImageUtils.tryToCreateReaderForFile(fileName);
        return this.tryAdaptFormatReader(formatReaderOrNull, false);
    }

    protected IImageReader tryAdaptFormatReader(IFormatReader formatReaderOrNull, boolean singleImagePerFile) {
        return formatReaderOrNull == null ? null : this.adaptFormatReader(formatReaderOrNull, singleImagePerFile);
    }

    protected IImageReader adaptFormatReader(IFormatReader formatReader, boolean singleImagePerFile) {
        String libraryName = this.getName();
        String readerName = BioFormatsImageUtils.getReaderName(formatReader);
        return new DefaultBioformatsImageReader(libraryName, readerName, formatReader, singleImagePerFile);
    }
}

