/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LIFReader
extends FormatReader {
    public static final byte LIF_MAGIC_BYTE = 112;
    public static final byte LIF_MEMORY_BYTE = 42;
    private static final HashMap<String, Integer> CHANNEL_PRIORITIES = LIFReader.createChannelPriorities();
    private Vector<Long> offsets;
    private int[][] realChannel;
    private int lastChannel = 0;
    private Vector<String> lutNames = new Vector();
    private Vector<Double> physicalSizeXs = new Vector();
    private Vector<Double> physicalSizeYs = new Vector();
    private String[] descriptions;
    private String[] microscopeModels;
    private String[] serialNumber;
    private Double[] pinholes;
    private Double[] zooms;
    private Double[] zSteps;
    private Double[] tSteps;
    private Double[] lensNA;
    private Double[][] expTimes;
    private Double[][] gains;
    private Double[][] detectorOffsets;
    private String[][] channelNames;
    private Vector[] detectorModels;
    private Integer[][] exWaves;
    private Vector[] activeDetector;
    private HashMap[] detectorIndexes;
    private String[] immersions;
    private String[] corrections;
    private String[] objectiveModels;
    private Integer[] magnification;
    private Double[] posX;
    private Double[] posY;
    private Double[] posZ;
    private Double[] refractiveIndex;
    private Vector[] cutIns;
    private Vector[] cutOuts;
    private Vector[] filterModels;
    private double[][] timestamps;
    private Vector[] laserWavelength;
    private Vector[] laserIntensity;
    private ROI[][] imageROIs;
    private boolean alternateCenter = false;
    private String[] imageNames;
    private double[] acquiredDate;

    private static HashMap<String, Integer> createChannelPriorities() {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        h.put("red", new Integer(0));
        h.put("green", new Integer(1));
        h.put("blue", new Integer(2));
        h.put("cyan", new Integer(3));
        h.put("magenta", new Integer(4));
        h.put("yellow", new Integer(5));
        h.put("black", new Integer(6));
        h.put("gray", new Integer(7));
        h.put("", new Integer(8));
        return h;
    }

    public LIFReader() {
        super("Leica Image File Format", "lif");
        this.suffixNecessary = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean blockLen = true;
        if (!FormatTools.validStream(stream, 1, true)) {
            return false;
        }
        return stream.read() == 112;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= 9) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        block8: for (int i = 0; i < 256; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                }
            }
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 3 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= 9) {
            return null;
        }
        short[][] lut = new short[3][65536];
        block8: for (int i = 0; i < 65536; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[1][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[1][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                }
            }
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (!this.isRGB()) {
            int[] pos = this.getZCTCoords(no);
            this.lastChannel = this.realChannel[this.series][pos[1]];
        }
        if (this.series >= this.offsets.size()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        long offset = this.offsets.get(this.series);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int bpp = bytes * this.getRGBChannelCount();
        long planeSize = (long)this.getSizeX() * (long)this.getSizeY() * (long)bpp;
        long nextOffset = this.series + 1 < this.offsets.size() ? this.offsets.get(this.series + 1).longValue() : this.in.length();
        int bytesToSkip = (int)(nextOffset - offset - planeSize * (long)this.getImageCount());
        bytesToSkip /= this.getSizeY();
        if (this.getSizeX() % 4 == 0) {
            bytesToSkip = 0;
        }
        if (offset + (planeSize + (long)(bytesToSkip * this.getSizeY())) * (long)no >= this.in.length()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        this.in.seek(offset + planeSize * (long)no);
        this.in.skipBytes(bytesToSkip * this.getSizeY() * no);
        if (bytesToSkip == 0) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.in.skipBytes(y * (this.getSizeX() * bpp + bytesToSkip));
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * bpp);
                this.in.read(buf, row * w * bpp, w * bpp);
                this.in.skipBytes(bpp * (this.getSizeX() - w - x) + bytesToSkip);
            }
        }
        if (this.getRGBChannelCount() == 3) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), bytes, this.getRGBChannelCount());
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.realChannel = null;
            this.lastChannel = 0;
            this.lutNames.clear();
            this.physicalSizeXs.clear();
            this.physicalSizeYs.clear();
            this.serialNumber = null;
            this.microscopeModels = null;
            this.descriptions = null;
            this.lensNA = null;
            this.zooms = null;
            this.pinholes = null;
            this.tSteps = null;
            this.zSteps = null;
            this.gains = null;
            this.expTimes = this.gains;
            this.detectorOffsets = null;
            this.channelNames = null;
            this.detectorModels = null;
            this.exWaves = null;
            this.activeDetector = null;
            this.corrections = null;
            this.immersions = null;
            this.magnification = null;
            this.objectiveModels = null;
            this.posZ = null;
            this.posY = null;
            this.posX = null;
            this.refractiveIndex = null;
            this.filterModels = null;
            this.cutOuts = null;
            this.cutIns = null;
            this.timestamps = null;
            this.laserIntensity = null;
            this.laserWavelength = null;
            this.imageROIs = null;
            this.alternateCenter = false;
            this.imageNames = null;
            this.acquiredDate = null;
            this.detectorIndexes = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.offsets = new Vector();
        this.in.order(true);
        LOGGER.info("Reading header");
        byte checkOne = this.in.readByte();
        this.in.skipBytes(2);
        byte checkTwo = this.in.readByte();
        if (checkOne != 112 && checkTwo != 112) {
            throw new FormatException(id + " is not a valid Leica LIF file");
        }
        this.in.skipBytes(4);
        if (this.in.read() != 42) {
            throw new FormatException("Invalid XML description");
        }
        int nc = this.in.readInt();
        String xml = DataTools.stripString(this.in.readString(nc * 2));
        LOGGER.info("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            LOGGER.debug("Looking for a block at {}; {} blocks read", this.in.getFilePointer(), (Object)this.offsets.size());
            int check = this.in.readInt();
            if (check != 112) {
                throw new FormatException("Invalid Memory Block: found magic bytes " + check + ", expected " + 112);
            }
            this.in.skipBytes(4);
            check = this.in.read();
            if (check != 42) {
                throw new FormatException("Invalid Memory Description: found magic byte " + check + ", expected " + 42);
            }
            long blockLength = this.in.readInt();
            if (this.in.read() != 42) {
                this.in.seek(this.in.getFilePointer() - 5L);
                blockLength = this.in.readLong();
                check = this.in.read();
                if (check != 42) {
                    throw new FormatException("Invalid Memory Description: found magic byte " + check + ", expected " + 42);
                }
            }
            int descrLength = this.in.readInt() * 2;
            if (blockLength > 0L) {
                this.offsets.add(new Long(this.in.getFilePointer() + (long)descrLength));
            }
            this.in.seek(this.in.getFilePointer() + (long)descrLength + blockLength);
        }
        this.initMetadata(xml);
        xml = null;
        if (this.offsets.size() > this.getSeriesCount()) {
            Long[] storedOffsets = this.offsets.toArray(new Long[this.offsets.size()]);
            this.offsets.clear();
            int index = 0;
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                long end;
                this.setSeries(i);
                long nBytes = (long)FormatTools.getPlaneSize(this) * (long)this.getImageCount();
                long start = storedOffsets[index];
                long l = end = index == storedOffsets.length - 1 ? this.in.length() : storedOffsets[index + 1].longValue();
                while (end - start < nBytes && (end - start) / nBytes != 1L) {
                    start = storedOffsets[++index];
                    end = index == storedOffsets.length - 1 ? this.in.length() : storedOffsets[index + 1].longValue();
                }
                this.offsets.add(storedOffsets[index]);
                ++index;
            }
            this.setSeries(0);
        }
    }

    private void initMetadata(String xml) throws FormatException, IOException {
        OMEXMLMetadata omexml = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            omexml = service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", exc);
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", exc);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>" + xml + "</LEICA>";
        xml = XMLTools.sanitizeXML(xml);
        this.translateMetadata(this.getMetadataRoot(xml));
        for (int i = 0; i < this.imageNames.length; ++i) {
            this.setSeries(i);
            this.addSeriesMeta("Image name", this.imageNames[i]);
        }
        this.setSeries(0);
        this.realChannel = new int[this.getSeriesCount()][];
        int nextLut = 0;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.realChannel[i] = new int[this.core[i].sizeC];
            for (int q = 0; q < this.core[i].sizeC; ++q) {
                String lut;
                if (!CHANNEL_PRIORITIES.containsKey(lut = this.lutNames.get(nextLut++).toLowerCase())) {
                    lut = "";
                }
                this.realChannel[i][q] = CHANNEL_PRIORITIES.get(lut);
            }
            int[] sorted = new int[this.core[i].sizeC];
            Arrays.fill(sorted, -1);
            for (int q = 0; q < sorted.length; ++q) {
                int min = Integer.MAX_VALUE;
                int minIndex = -1;
                for (int n = 0; n < this.core[i].sizeC; ++n) {
                    if (this.realChannel[i][n] >= min || DataTools.containsValue(sorted, n)) continue;
                    min = this.realChannel[i][n];
                    minIndex = n;
                }
                sorted[q] = minIndex;
            }
        }
        MetadataTools.populatePixels(store, this, true, false);
        int roiCount = 0;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            Vector activeDetectors;
            int firstDetector;
            int nextFilter;
            this.setSeries(i);
            String instrumentID = MetadataTools.createLSID("Instrument", i);
            store.setInstrumentID(instrumentID, i);
            store.setMicroscopeModel(this.microscopeModels[i], i);
            store.setMicroscopeType(this.getMicroscopeType("Other"), i);
            String objectiveID = MetadataTools.createLSID("Objective", i, 0);
            store.setObjectiveID(objectiveID, i, 0);
            store.setObjectiveLensNA(this.lensNA[i], i, 0);
            store.setObjectiveSerialNumber(this.serialNumber[i], i, 0);
            if (this.magnification[i] != null && this.magnification[i] > 0) {
                store.setObjectiveNominalMagnification(new PositiveInteger(this.magnification[i]), i, 0);
            } else {
                LOGGER.warn("Expected positive value for NominalMagnification; got {}", this.magnification[i]);
            }
            store.setObjectiveImmersion(this.getImmersion(this.immersions[i]), i, 0);
            store.setObjectiveCorrection(this.getCorrection(this.corrections[i]), i, 0);
            store.setObjectiveModel(this.objectiveModels[i], i, 0);
            if (this.cutIns[i] != null && this.filterModels[i] != null) {
                boolean channel = false;
                if (this.cutIns[i].size() >= this.filterModels[i].size() * 2) {
                    int diff = this.cutIns[i].size() - this.filterModels[i].size();
                    for (int q = 0; q < diff; ++q) {
                        this.cutIns[i].remove(this.filterModels[i].size());
                    }
                }
                for (int filter = 0; filter < this.cutIns[i].size(); ++filter) {
                    String filterID = MetadataTools.createLSID("Filter", i, filter);
                    store.setFilterID(filterID, i, filter);
                    if (this.filterModels[i] != null && filter < this.filterModels[i].size()) {
                        store.setFilterModel((String)this.filterModels[i].get(filter), i, filter);
                    }
                    store.setTransmittanceRangeCutIn((PositiveInteger)this.cutIns[i].get(filter), i, filter);
                    store.setTransmittanceRangeCutOut((PositiveInteger)this.cutOuts[i].get(filter), i, filter);
                }
            }
            Vector lasers = this.laserWavelength[i];
            Vector laserIntensities = this.laserIntensity[i];
            int nextChannel = 0;
            if (lasers != null) {
                int start;
                int laserIndex = 0;
                while (laserIndex < lasers.size()) {
                    if ((Integer)lasers.get(laserIndex) == 0) {
                        lasers.removeElementAt(laserIndex);
                        continue;
                    }
                    ++laserIndex;
                }
                for (int laser = 0; laser < lasers.size(); ++laser) {
                    String id = MetadataTools.createLSID("LightSource", i, laser);
                    store.setLaserID(id, i, laser);
                    store.setLaserType(LaserType.OTHER, i, laser);
                    store.setLaserLaserMedium(LaserMedium.OTHER, i, laser);
                    Integer wavelength = (Integer)lasers.get(laser);
                    if (wavelength > 0) {
                        store.setLaserWavelength(new PositiveInteger(wavelength), i, laser);
                        continue;
                    }
                    LOGGER.warn("Expected positive value for Wavelength; got {}", wavelength);
                }
                Vector<Integer> validIntensities = new Vector<Integer>();
                for (int laser = 0; laser < laserIntensities.size(); ++laser) {
                    double intensity = (Double)laserIntensities.get(laser);
                    if (!(intensity < 100.0)) continue;
                    validIntensities.add(laser);
                }
                if (validIntensities.size() == this.getEffectiveSizeC() + 1) {
                    validIntensities.remove(1);
                }
                if ((start = validIntensities.size() - this.getEffectiveSizeC()) < 0) {
                    start = 0;
                }
                boolean noNames = true;
                if (this.channelNames[i] != null) {
                    for (String name : this.channelNames[i]) {
                        if (name == null || name.equals("")) continue;
                        noNames = false;
                        break;
                    }
                }
                nextFilter = 0;
                int k = start;
                while (k < validIntensities.size()) {
                    int index = (Integer)validIntensities.get(k);
                    double intensity = (Double)laserIntensities.get(index);
                    int laser = index % lasers.size();
                    Integer wavelength = (Integer)lasers.get(laser);
                    if (wavelength != 0) {
                        while (this.channelNames != null && nextChannel < this.getEffectiveSizeC() && this.channelNames[i] != null && (this.channelNames[i][nextChannel] == null || this.channelNames[i][nextChannel].equals("")) && !noNames) {
                            ++nextChannel;
                        }
                        if (nextChannel < this.getEffectiveSizeC()) {
                            String id = MetadataTools.createLSID("LightSource", i, laser);
                            store.setChannelLightSourceSettingsID(id, i, nextChannel);
                            store.setChannelLightSourceSettingsAttenuation(new PercentFraction(Float.valueOf((float)intensity / 100.0f)), i, nextChannel);
                            if (wavelength > 0) {
                                store.setChannelExcitationWavelength(new PositiveInteger(wavelength), i, nextChannel);
                                if (this.cutIns[i] != null && nextFilter < this.cutIns[i].size()) {
                                    Integer cutIn = (Integer)((PositiveInteger)this.cutIns[i].get(nextFilter)).getValue();
                                    while (cutIn - wavelength > 20 && ++nextFilter < this.cutIns[i].size()) {
                                        cutIn = (Integer)((PositiveInteger)this.cutIns[i].get(nextFilter)).getValue();
                                    }
                                    if (nextFilter < this.cutIns[i].size()) {
                                        String fid = MetadataTools.createLSID("Filter", i, nextFilter++);
                                    }
                                }
                            } else {
                                LOGGER.warn("Expected positive value for ExcitationWavelength; got {}", wavelength);
                            }
                        }
                    }
                    ++k;
                    ++nextChannel;
                }
            }
            store.setImageInstrumentRef(instrumentID, i);
            store.setObjectiveSettingsID(objectiveID, i);
            store.setObjectiveSettingsRefractiveIndex(this.refractiveIndex[i], i);
            store.setImageDescription(this.descriptions[i], i);
            if (this.acquiredDate[i] > 0.0) {
                store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate((long)(this.acquiredDate[i] * 1000.0), 1, "yyyy-MM-dd'T'HH:mm:ss", true)), i);
            }
            store.setImageName(this.imageNames[i].trim(), i);
            if (this.physicalSizeXs.get(i) > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.physicalSizeXs.get(i)), i);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", this.physicalSizeXs.get(i));
            }
            if (this.physicalSizeYs.get(i) > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.physicalSizeYs.get(i)), i);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", this.physicalSizeYs.get(i));
            }
            if (this.zSteps[i] != null && this.zSteps[i] > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(this.zSteps[i]), i);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", this.zSteps[i]);
            }
            store.setPixelsTimeIncrement(this.tSteps[i], i);
            Vector detectors = this.detectorModels[i];
            if (detectors != null) {
                nextChannel = 0;
                int start = detectors.size() - this.getEffectiveSizeC();
                if (start < 0) {
                    start = 0;
                }
                for (int detector = start; detector < detectors.size(); ++detector) {
                    int index;
                    int dIndex = detector - start;
                    String detectorID = MetadataTools.createLSID("Detector", i, dIndex);
                    store.setDetectorID(detectorID, i, dIndex);
                    store.setDetectorModel((String)detectors.get(detector), i, dIndex);
                    store.setDetectorZoom(this.zooms[i], i, dIndex);
                    store.setDetectorType(DetectorType.PMT, i, dIndex);
                    if (this.activeDetector[i] == null || (index = this.activeDetector[i].size() - this.getEffectiveSizeC() + dIndex) < 0 || index >= this.activeDetector[i].size() || !((Boolean)this.activeDetector[i].get(index)).booleanValue() || this.detectorOffsets[i] == null || nextChannel >= this.detectorOffsets[i].length) continue;
                    store.setDetectorOffset(this.detectorOffsets[i][nextChannel++], i, dIndex);
                }
            }
            int nextDetector = firstDetector = (activeDetectors = this.activeDetector[i]) == null ? 0 : activeDetectors.size() - this.getEffectiveSizeC();
            nextFilter = 0;
            int nextFilterDetector = 0;
            if (activeDetectors != null && activeDetectors.size() > this.cutIns[i].size() && ((Boolean)activeDetectors.get(activeDetectors.size() - 1)).booleanValue() && ((Boolean)activeDetectors.get(activeDetectors.size() - 2)).booleanValue()) {
                nextFilterDetector = activeDetectors.size() - this.cutIns[i].size();
                if (this.cutIns[i].size() > this.filterModels[i].size()) {
                    nextFilterDetector += this.filterModels[i].size();
                    nextFilter += this.filterModels[i].size();
                }
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                String filterID;
                if (activeDetectors != null) {
                    while (nextDetector >= 0 && nextDetector < activeDetectors.size() && !((Boolean)activeDetectors.get(nextDetector)).booleanValue()) {
                        ++nextDetector;
                    }
                    if (nextDetector < activeDetectors.size() && detectors != null && nextDetector - firstDetector < detectors.size()) {
                        String detectorID = MetadataTools.createLSID("Detector", i, nextDetector - firstDetector);
                        store.setDetectorSettingsID(detectorID, i, c);
                        ++nextDetector;
                        if (this.detectorOffsets[i] != null && c < this.detectorOffsets[i].length) {
                            store.setDetectorSettingsOffset(this.detectorOffsets[i][c], i, c);
                        }
                        if (this.gains[i] != null) {
                            store.setDetectorSettingsGain(this.gains[i][c], i, c);
                        }
                    }
                }
                if (this.channelNames[i] != null) {
                    store.setChannelName(this.channelNames[i][c], i, c);
                }
                store.setChannelPinholeSize(this.pinholes[i], i, c);
                if (this.exWaves[i] != null) {
                    if (this.exWaves[i][c] != null && this.exWaves[i][c] > 1) {
                        store.setChannelExcitationWavelength(new PositiveInteger(this.exWaves[i][c]), i, c);
                    } else {
                        LOGGER.warn("Expected positive value for ExcitationWavelength; got {}", this.exWaves[i][c]);
                    }
                }
                Color channelColor = this.getChannelColor(this.realChannel[i][c]);
                store.setChannelColor(channelColor, i, c);
                if ((Integer)channelColor.getValue() == -1 || nextFilter < 0) continue;
                if (nextDetector - firstDetector != this.getSizeC() && this.cutIns[i] != null && nextDetector >= this.cutIns[i].size()) {
                    while (nextFilterDetector < firstDetector) {
                        filterID = MetadataTools.createLSID("Filter", i, nextFilter);
                        store.setFilterID(filterID, i, nextFilter);
                        ++nextFilterDetector;
                        ++nextFilter;
                    }
                }
                while (activeDetectors != null && nextFilterDetector < activeDetectors.size() && !((Boolean)activeDetectors.get(nextFilterDetector)).booleanValue()) {
                    filterID = MetadataTools.createLSID("Filter", i, nextFilter);
                    store.setFilterID(filterID, i, nextFilter);
                    ++nextFilterDetector;
                    ++nextFilter;
                }
                filterID = MetadataTools.createLSID("Filter", i, nextFilter);
                store.setFilterID(filterID, i, nextFilter);
                store.setLightPathEmissionFilterRef(filterID, i, c, 0);
                ++nextFilterDetector;
                ++nextFilter;
            }
            for (int image = 0; image < this.getImageCount(); ++image) {
                store.setPlanePositionX(this.posX[i], i, image);
                store.setPlanePositionY(this.posY[i], i, image);
                store.setPlanePositionZ(this.posZ[i], i, image);
                if (this.timestamps[i] != null) {
                    double timestamp = this.timestamps[i][image];
                    if (this.timestamps[i][0] == this.acquiredDate[i]) {
                        timestamp -= this.acquiredDate[i];
                    } else if (timestamp == this.acquiredDate[i] && image > 0) {
                        timestamp = this.timestamps[i][0];
                    }
                    store.setPlaneDeltaT(timestamp, i, image);
                }
                if (this.expTimes[i] == null) continue;
                int c = this.getZCTCoords(image)[1];
                store.setPlaneExposureTime(this.expTimes[i][c], i, image);
            }
            if (this.imageROIs[i] == null) continue;
            for (int roi = 0; roi < this.imageROIs[i].length; ++roi) {
                if (this.imageROIs[i][roi] == null) continue;
                this.imageROIs[i][roi].storeROI(store, i, roiCount++, roi);
            }
        }
    }

    private Element getMetadataRoot(String xml) throws FormatException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            ByteArrayInputStream s = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Element root = parser.parse(s).getDocumentElement();
            s.close();
            return root;
        }
        catch (ParserConfigurationException e) {
            throw new FormatException(e);
        }
        catch (SAXException e) {
            throw new FormatException(e);
        }
    }

    private void translateMetadata(Element root) throws FormatException {
        Element realRoot = (Element)root.getChildNodes().item(0);
        NodeList toPrune = this.getNodes(realRoot, "LDM_Block_Sequential_Master");
        if (toPrune != null) {
            for (int i = 0; i < toPrune.getLength(); ++i) {
                Element prune = (Element)toPrune.item(i);
                Element parent = (Element)prune.getParentNode();
                parent.removeChild(prune);
            }
        }
        NodeList imageNodes = this.getNodes(realRoot, "Image");
        this.core = new CoreMetadata[imageNodes.getLength()];
        this.acquiredDate = new double[imageNodes.getLength()];
        this.descriptions = new String[imageNodes.getLength()];
        this.laserWavelength = new Vector[imageNodes.getLength()];
        this.laserIntensity = new Vector[imageNodes.getLength()];
        this.timestamps = new double[imageNodes.getLength()][];
        this.activeDetector = new Vector[imageNodes.getLength()];
        this.serialNumber = new String[imageNodes.getLength()];
        this.lensNA = new Double[imageNodes.getLength()];
        this.magnification = new Integer[imageNodes.getLength()];
        this.immersions = new String[imageNodes.getLength()];
        this.corrections = new String[imageNodes.getLength()];
        this.objectiveModels = new String[imageNodes.getLength()];
        this.posX = new Double[imageNodes.getLength()];
        this.posY = new Double[imageNodes.getLength()];
        this.posZ = new Double[imageNodes.getLength()];
        this.refractiveIndex = new Double[imageNodes.getLength()];
        this.cutIns = new Vector[imageNodes.getLength()];
        this.cutOuts = new Vector[imageNodes.getLength()];
        this.filterModels = new Vector[imageNodes.getLength()];
        this.microscopeModels = new String[imageNodes.getLength()];
        this.detectorModels = new Vector[imageNodes.getLength()];
        this.detectorIndexes = new HashMap[imageNodes.getLength()];
        this.zSteps = new Double[imageNodes.getLength()];
        this.tSteps = new Double[imageNodes.getLength()];
        this.pinholes = new Double[imageNodes.getLength()];
        this.zooms = new Double[imageNodes.getLength()];
        this.expTimes = new Double[imageNodes.getLength()][];
        this.gains = new Double[imageNodes.getLength()][];
        this.detectorOffsets = new Double[imageNodes.getLength()][];
        this.channelNames = new String[imageNodes.getLength()][];
        this.exWaves = new Integer[imageNodes.getLength()][];
        this.imageROIs = new ROI[imageNodes.getLength()][];
        this.imageNames = new String[imageNodes.getLength()];
        for (int i = 0; i < imageNodes.getLength(); ++i) {
            Element image = (Element)imageNodes.item(i);
            this.setSeries(i);
            this.translateImageNames(image, i);
            this.translateImageNodes(image, i);
            this.translateAttachmentNodes(image, i);
            this.translateScannerSettings(image, i);
            this.translateFilterSettings(image, i);
            this.translateTimestamps(image, i);
            this.translateLaserLines(image, i);
            this.translateROIs(image, i);
            this.translateSingleROIs(image, i);
            this.translateDetectors(image, i);
            Stack<String> nameStack = new Stack<String>();
            HashMap<String, Integer> indexes = new HashMap<String, Integer>();
            this.populateOriginalMetadata(image, nameStack, indexes);
            indexes.clear();
        }
        this.setSeries(0);
    }

    private void populateOriginalMetadata(Element root, Stack<String> nameStack, HashMap<String, Integer> indexes) {
        String name = root.getNodeName();
        if (root.hasAttributes() && !name.equals("Element") && !name.equals("Attachment") && !name.equals("LMSDataContainerHeader")) {
            nameStack.push(name);
            String suffix = root.getAttribute("Identifier");
            String value = root.getAttribute("Variant");
            if (suffix == null || suffix.trim().length() == 0) {
                suffix = root.getAttribute("Description");
            }
            StringBuffer key = new StringBuffer();
            for (String k : nameStack) {
                key.append(k);
                key.append("|");
            }
            if (suffix != null && value != null && suffix.length() > 0 && value.length() > 0 && !suffix.equals("HighInteger") && !suffix.equals("LowInteger")) {
                Integer i = indexes.get(key.toString() + suffix);
                String storedKey = key.toString() + suffix + " " + (i == null ? 0 : i);
                indexes.put(key.toString() + suffix, i == null ? 1 : i + 1);
                this.addSeriesMeta(storedKey, value);
            } else {
                NamedNodeMap attributes = root.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (attr.getName().equals("HighInteger") || attr.getName().equals("LowInteger")) continue;
                    Integer index = indexes.get(key.toString() + attr.getName());
                    if (index == null) {
                        index = 0;
                    }
                    String storedKey = key.toString() + attr.getName() + " " + index;
                    indexes.put(key.toString() + attr.getName(), index + 1);
                    this.addSeriesMeta(storedKey, attr.getValue());
                }
            }
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.populateOriginalMetadata((Element)child, nameStack, indexes);
        }
        if (root.hasAttributes() && !name.equals("Element") && !name.equals("Attachment") && !name.equals("LMSDataContainerHeader")) {
            nameStack.pop();
        }
    }

    private void translateImageNames(Element imageNode, int image) {
        Vector<String> names = new Vector<String>();
        Element parent = imageNode;
        while ((parent = (Element)parent.getParentNode()) != null && !parent.getNodeName().equals("LEICA")) {
            if (!parent.getNodeName().equals("Element")) continue;
            names.add(parent.getAttribute("Name"));
        }
        this.imageNames[image] = "";
        for (int i = names.size() - 2; i >= 0; --i) {
            int n = image;
            this.imageNames[n] = this.imageNames[n] + (String)names.get(i);
            if (i <= 0) continue;
            int n2 = image;
            this.imageNames[n2] = this.imageNames[n2] + "/";
        }
    }

    private void translateDetectors(Element imageNode, int image) throws FormatException {
        NodeList definitions = this.getNodes(imageNode, "ATLConfocalSettingDefinition");
        if (definitions == null) {
            return;
        }
        Vector<String> channels = new Vector<String>();
        int nextChannel = 0;
        for (int definition = 0; definition < definitions.getLength(); ++definition) {
            Element definitionNode = (Element)definitions.item(definition);
            String parentName = definitionNode.getParentNode().getNodeName();
            boolean isMaster = parentName.endsWith("Master");
            NodeList detectors = this.getNodes(definitionNode, "Detector");
            if (detectors == null) {
                return;
            }
            for (int d = 0; d < detectors.getLength(); ++d) {
                Element detector = (Element)detectors.item(d);
                NodeList multibands = this.getNodes(definitionNode, "MultiBand");
                String v = detector.getAttribute("Gain");
                Double gain = v == null || v.trim().length() == 0 ? null : new Double(v);
                v = detector.getAttribute("Offset");
                Double offset = v == null || v.trim().length() == 0 ? null : new Double(v);
                boolean active = "1".equals(detector.getAttribute("IsActive"));
                if (active) {
                    int channel;
                    String c = detector.getAttribute("Channel");
                    int n = channel = c == null ? 0 : Integer.parseInt(c);
                    if (this.detectorIndexes[image] != null && this.detectorModels[image] != null) {
                        this.detectorModels[image].add(this.detectorIndexes[image].get(channel));
                    }
                    Element multiband = null;
                    if (multibands != null) {
                        for (int i = 0; i < multibands.getLength(); ++i) {
                            Element mb = (Element)multibands.item(i);
                            if (channel != Integer.parseInt(mb.getAttribute("Channel"))) continue;
                            multiband = mb;
                            break;
                        }
                    }
                    if (multiband != null) {
                        String dye = multiband.getAttribute("DyeName");
                        if (!channels.contains(dye)) {
                            channels.add(dye);
                        }
                        double cutIn = new Double(multiband.getAttribute("LeftWorld"));
                        double cutOut = new Double(multiband.getAttribute("RightWorld"));
                        if ((int)cutIn > 0) {
                            if (this.cutIns[image] == null) {
                                this.cutIns[image] = new Vector();
                            }
                            this.cutIns[image].add(new PositiveInteger((int)Math.round(cutIn)));
                        } else {
                            LOGGER.warn("Expected positive value for CutIn; got {}", cutIn);
                        }
                        if ((int)cutOut > 0) {
                            if (this.cutOuts[image] == null) {
                                this.cutOuts[image] = new Vector();
                            }
                            this.cutOuts[image].add(new PositiveInteger((int)Math.round(cutOut)));
                        } else {
                            LOGGER.warn("Expected positive value for CutOut; got {}", cutOut);
                        }
                    } else {
                        channels.add("");
                    }
                    if (!isMaster) {
                        if (channel < nextChannel) {
                            nextChannel = 0;
                        }
                        if (nextChannel < this.getEffectiveSizeC()) {
                            if (this.gains[image] != null) {
                                this.gains[image][nextChannel] = gain;
                            }
                            if (this.detectorOffsets[image] != null) {
                                this.detectorOffsets[image][nextChannel] = offset;
                            }
                        }
                        ++nextChannel;
                    }
                }
                if (!active || this.activeDetector[image] == null) continue;
                this.activeDetector[image].add(active);
            }
        }
        if (channels != null && this.channelNames[image] != null) {
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                int index = i + channels.size() - this.getEffectiveSizeC();
                if (index < 0 || index >= channels.size()) continue;
                this.channelNames[image][i] = (String)channels.get(index);
            }
        }
    }

    private void translateROIs(Element imageNode, int image) throws FormatException {
        NodeList rois = this.getNodes(imageNode, "Annotation");
        if (rois == null) {
            return;
        }
        this.imageROIs[image] = new ROI[rois.getLength()];
        for (int r = 0; r < rois.getLength(); ++r) {
            String color;
            Element roiNode = (Element)rois.item(r);
            ROI roi = new ROI();
            String type = roiNode.getAttribute("type");
            if (type != null) {
                roi.type = Integer.parseInt(type);
            }
            if ((color = roiNode.getAttribute("color")) != null) {
                roi.color = Long.parseLong(color);
            }
            roi.name = roiNode.getAttribute("name");
            roi.fontName = roiNode.getAttribute("fontName");
            roi.fontSize = roiNode.getAttribute("fontSize");
            roi.transX = this.parseDouble(roiNode.getAttribute("transTransX"));
            roi.transY = this.parseDouble(roiNode.getAttribute("transTransY"));
            roi.scaleX = this.parseDouble(roiNode.getAttribute("transScalingX"));
            roi.scaleY = this.parseDouble(roiNode.getAttribute("transScalingY"));
            roi.rotation = this.parseDouble(roiNode.getAttribute("transRotation"));
            String linewidth = roiNode.getAttribute("linewidth");
            if (linewidth != null) {
                try {
                    roi.linewidth = Integer.parseInt(linewidth);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            roi.text = roiNode.getAttribute("text");
            NodeList vertices = this.getNodes(roiNode, "Vertex");
            if (vertices == null) continue;
            for (int v = 0; v < vertices.getLength(); ++v) {
                Element vertex = (Element)vertices.item(v);
                String xx = vertex.getAttribute("x");
                String yy = vertex.getAttribute("y");
                if (xx != null) {
                    roi.x.add(this.parseDouble(xx));
                }
                if (yy == null) continue;
                roi.y.add(this.parseDouble(yy));
            }
            this.imageROIs[image][r] = roi;
            if (this.getNodes(imageNode, "ROI") == null) continue;
            this.alternateCenter = true;
        }
    }

    private void translateSingleROIs(Element imageNode, int image) throws FormatException {
        if (this.imageROIs[image] != null) {
            return;
        }
        NodeList children = this.getNodes(imageNode, "ROI");
        if (children == null) {
            return;
        }
        if ((children = this.getNodes((Element)children.item(0), "Children")) == null) {
            return;
        }
        if ((children = this.getNodes((Element)children.item(0), "Element")) == null) {
            return;
        }
        this.imageROIs[image] = new ROI[children.getLength()];
        for (int r = 0; r < children.getLength(); ++r) {
            String color;
            NodeList rois = this.getNodes((Element)children.item(r), "ROISingle");
            Element roiNode = (Element)rois.item(0);
            ROI roi = new ROI();
            String type = roiNode.getAttribute("RoiType");
            if (type != null) {
                roi.type = Integer.parseInt(type);
            }
            if ((color = roiNode.getAttribute("Color")) != null) {
                roi.color = Long.parseLong(color);
            }
            Element parent = (Element)roiNode.getParentNode();
            parent = (Element)parent.getParentNode();
            roi.name = parent.getAttribute("Name");
            NodeList vertices = this.getNodes(roiNode, "P");
            double sizeX = this.physicalSizeXs.get(image);
            double sizeY = this.physicalSizeYs.get(image);
            for (int v = 0; v < vertices.getLength(); ++v) {
                Element vertex = (Element)vertices.item(v);
                String xx = vertex.getAttribute("X");
                String yy = vertex.getAttribute("Y");
                if (xx != null) {
                    roi.x.add(this.parseDouble(xx) / sizeX);
                }
                if (yy == null) continue;
                roi.y.add(this.parseDouble(yy) / sizeY);
            }
            Element transform = (Element)this.getNodes(roiNode, "Transformation").item(0);
            roi.rotation = this.parseDouble(transform.getAttribute("Rotation"));
            Element scaling = (Element)this.getNodes(transform, "Scaling").item(0);
            roi.scaleX = this.parseDouble(scaling.getAttribute("XScale"));
            roi.scaleY = this.parseDouble(scaling.getAttribute("YScale"));
            Element translation = (Element)this.getNodes(transform, "Translation").item(0);
            roi.transX = this.parseDouble(translation.getAttribute("X")) / sizeX;
            roi.transY = this.parseDouble(translation.getAttribute("Y")) / sizeY;
            this.imageROIs[image][r] = roi;
        }
    }

    private void translateLaserLines(Element imageNode, int image) throws FormatException {
        NodeList aotfLists = this.getNodes(imageNode, "AotfList");
        if (aotfLists == null) {
            return;
        }
        this.laserWavelength[image] = new Vector();
        this.laserIntensity[image] = new Vector();
        int baseIntensityIndex = 0;
        for (int channel = 0; channel < aotfLists.getLength(); ++channel) {
            Element aotf = (Element)aotfLists.item(channel);
            NodeList laserLines = this.getNodes(aotf, "LaserLineSetting");
            if (laserLines == null) {
                return;
            }
            for (int laser = 0; laser < laserLines.getLength(); ++laser) {
                int qualifier;
                Element laserLine = (Element)laserLines.item(laser);
                String lineIndex = laserLine.getAttribute("LineIndex");
                String qual = laserLine.getAttribute("Qualifier");
                int index = lineIndex == null ? 0 : Integer.parseInt(lineIndex);
                int n = qualifier = qual == null ? 0 : Integer.parseInt(qual);
                if ((index += 2 - qualifier / 10) < 0) {
                    index = 0;
                }
                Integer wavelength = new Integer(laserLine.getAttribute("LaserLine"));
                if (index < this.laserWavelength[image].size()) {
                    this.laserWavelength[image].setElementAt(wavelength, index);
                } else {
                    for (int i = this.laserWavelength[image].size(); i < index; ++i) {
                        this.laserWavelength[image].add(new Integer(0));
                    }
                    this.laserWavelength[image].add(wavelength);
                }
                String intensity = laserLine.getAttribute("IntensityDev");
                double realIntensity = intensity == null ? 0.0 : new Double(intensity);
                realIntensity = 100.0 - realIntensity;
                int realIndex = baseIntensityIndex + index;
                if (realIndex < this.laserIntensity[image].size()) {
                    this.laserIntensity[image].setElementAt(realIntensity, realIndex);
                    continue;
                }
                while (realIndex < this.laserIntensity[image].size()) {
                    this.laserIntensity[image].add(100.0);
                }
                this.laserIntensity[image].add(realIntensity);
            }
            baseIntensityIndex += this.laserWavelength[image].size();
        }
    }

    private void translateTimestamps(Element imageNode, int image) throws FormatException {
        NodeList timestampNodes = this.getNodes(imageNode, "TimeStamp");
        if (timestampNodes == null) {
            return;
        }
        this.timestamps[image] = new double[this.getImageCount()];
        if (timestampNodes != null) {
            for (int stamp = 0; stamp < timestampNodes.getLength(); ++stamp) {
                if (stamp >= this.getImageCount()) continue;
                Element timestamp = (Element)timestampNodes.item(stamp);
                String stampHigh = timestamp.getAttribute("HighInteger");
                String stampLow = timestamp.getAttribute("LowInteger");
                long high = stampHigh == null ? 0L : Long.parseLong(stampHigh);
                long low = stampLow == null ? 0L : Long.parseLong(stampLow);
                long ms = DateTools.getMillisFromTicks(high, low);
                this.timestamps[image][stamp] = (double)ms / 1000.0;
            }
        }
        this.acquiredDate[image] = this.timestamps[image][0];
        NodeList relTimestampNodes = this.getNodes(imageNode, "RelTimeStamp");
        if (relTimestampNodes != null) {
            for (int stamp = 0; stamp < relTimestampNodes.getLength(); ++stamp) {
                if (stamp >= this.getImageCount()) continue;
                Element timestamp = (Element)relTimestampNodes.item(stamp);
                this.timestamps[image][stamp] = new Double(timestamp.getAttribute("Time"));
            }
        }
    }

    private void translateFilterSettings(Element imageNode, int image) throws FormatException {
        NodeList filterSettings = this.getNodes(imageNode, "FilterSettingRecord");
        if (filterSettings == null) {
            return;
        }
        this.activeDetector[image] = new Vector();
        this.cutIns[image] = new Vector();
        this.cutOuts[image] = new Vector();
        this.filterModels[image] = new Vector();
        this.detectorIndexes[image] = new HashMap();
        for (int i = 0; i < filterSettings.getLength(); ++i) {
            Element filterSetting = (Element)filterSettings.item(i);
            String object = filterSetting.getAttribute("ObjectName");
            String attribute = filterSetting.getAttribute("Attribute");
            String objectClass = filterSetting.getAttribute("ClassName");
            String variant = filterSetting.getAttribute("Variant");
            String data = filterSetting.getAttribute("Data");
            if (attribute.equals("NumericalAperture")) {
                this.lensNA[image] = new Double(variant);
                continue;
            }
            if (attribute.equals("OrderNumber")) {
                this.serialNumber[image] = variant;
                continue;
            }
            if (objectClass.equals("CDetectionUnit")) {
                int channel;
                if (!attribute.equals("State") || (channel = this.getChannelIndex(filterSetting)) < 0) continue;
                this.detectorIndexes[image].put(new Integer(data), object);
                this.activeDetector[image].add(variant.equals("Active"));
                continue;
            }
            if (attribute.equals("Objective")) {
                StringTokenizer tokens = new StringTokenizer(variant, " ");
                boolean foundMag = false;
                StringBuffer model = new StringBuffer();
                while (!foundMag) {
                    String token = tokens.nextToken();
                    int x = token.indexOf("x");
                    if (x != -1) {
                        foundMag = true;
                        int mag = (int)Double.parseDouble(token.substring(0, x));
                        String na = token.substring(x + 1);
                        this.magnification[image] = mag;
                        this.lensNA[image] = new Double(na);
                        continue;
                    }
                    model.append(token);
                    model.append(" ");
                }
                String immersion = "Other";
                if (tokens.hasMoreTokens() && ((immersion = tokens.nextToken()) == null || immersion.trim().equals(""))) {
                    immersion = "Other";
                }
                this.immersions[image] = immersion;
                String correction = "Other";
                if (tokens.hasMoreTokens() && ((correction = tokens.nextToken()) == null || correction.trim().equals(""))) {
                    correction = "Other";
                }
                this.corrections[image] = correction;
                this.objectiveModels[image] = model.toString().trim();
                continue;
            }
            if (attribute.equals("RefractionIndex")) {
                this.refractiveIndex[image] = new Double(variant);
                continue;
            }
            if (attribute.equals("XPos")) {
                this.posX[image] = new Double(variant);
                continue;
            }
            if (attribute.equals("YPos")) {
                this.posY[image] = new Double(variant);
                continue;
            }
            if (attribute.equals("ZPos")) {
                this.posZ[image] = new Double(variant);
                continue;
            }
            if (!objectClass.equals("CSpectrophotometerUnit")) continue;
            Integer v = null;
            try {
                v = new Integer((int)Double.parseDouble(variant));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String description = filterSetting.getAttribute("Description");
            if (description.endsWith("(left)")) {
                this.filterModels[image].add(object);
                if (v != null && v > 0) {
                    this.cutIns[image].add(new PositiveInteger(v));
                    continue;
                }
                LOGGER.warn("Expected positive value for CutIn; got {}", v);
                continue;
            }
            if (!description.endsWith("(right)")) continue;
            if (v != null && v > 0) {
                this.cutOuts[image].add(new PositiveInteger(v));
                continue;
            }
            LOGGER.warn("Expected positive value for CutOut; got {}", v);
        }
    }

    private void translateScannerSettings(Element imageNode, int image) throws FormatException {
        NodeList scannerSettings = this.getNodes(imageNode, "ScannerSettingRecord");
        if (scannerSettings == null) {
            return;
        }
        this.expTimes[image] = new Double[this.getEffectiveSizeC()];
        this.gains[image] = new Double[this.getEffectiveSizeC()];
        this.detectorOffsets[image] = new Double[this.getEffectiveSizeC()];
        this.channelNames[image] = new String[this.getEffectiveSizeC()];
        this.exWaves[image] = new Integer[this.getEffectiveSizeC()];
        this.detectorModels[image] = new Vector();
        for (int i = 0; i < scannerSettings.getLength(); ++i) {
            Element scannerSetting = (Element)scannerSettings.item(i);
            String id = scannerSetting.getAttribute("Identifier");
            if (id == null) {
                id = "";
            }
            String suffix = scannerSetting.getAttribute("Identifier");
            String value = scannerSetting.getAttribute("Variant");
            if (id.equals("SystemType")) {
                this.microscopeModels[image] = value;
                continue;
            }
            if (id.equals("dblPinhole")) {
                this.pinholes[image] = Double.parseDouble(value) * 1000000.0;
                continue;
            }
            if (id.equals("dblZoom")) {
                this.zooms[image] = new Double(value);
                continue;
            }
            if (id.equals("dblStepSize")) {
                this.zSteps[image] = Double.parseDouble(value) * 1000000.0;
                continue;
            }
            if (id.equals("nDelayTime_s")) {
                this.tSteps[image] = new Double(value);
                continue;
            }
            if (id.equals("CameraName")) {
                this.detectorModels[image].add(value);
                continue;
            }
            if (id.equals("eDirectional")) {
                this.addSeriesMeta("Reverse X orientation", value.equals("1"));
                continue;
            }
            if (id.equals("eDirectionalY")) {
                this.addSeriesMeta("Reverse Y orientation", value.equals("1"));
                continue;
            }
            if (id.indexOf("WFC") != 1) continue;
            int c = 0;
            try {
                c = Integer.parseInt(id.replaceAll("\\D", ""));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (c < 0 || c >= this.getEffectiveSizeC()) continue;
            if (id.endsWith("ExposureTime")) {
                this.expTimes[image][c] = new Double(value);
                continue;
            }
            if (id.endsWith("Gain")) {
                this.gains[image][c] = new Double(value);
                continue;
            }
            if (id.endsWith("WaveLength")) {
                Integer exWave = new Integer(value);
                if (exWave <= 0) continue;
                this.exWaves[image][c] = exWave;
                continue;
            }
            if (!id.endsWith("UesrDefName") || value.equals("None")) continue;
            this.channelNames[image][c] = value;
        }
    }

    private void translateAttachmentNodes(Element imageNode, int image) throws FormatException {
        NodeList attachmentNodes = this.getNodes(imageNode, "Attachment");
        if (attachmentNodes == null) {
            return;
        }
        for (int i = 0; i < attachmentNodes.getLength(); ++i) {
            Element attachment = (Element)attachmentNodes.item(i);
            if (!"ContextDescription".equals(attachment.getAttribute("Name"))) continue;
            this.descriptions[image] = attachment.getAttribute("Content");
        }
    }

    private void translateImageNodes(Element imageNode, int i) throws FormatException {
        this.core[i] = new CoreMetadata();
        this.core[i].orderCertain = true;
        this.core[i].metadataComplete = true;
        this.core[i].littleEndian = true;
        this.core[i].falseColor = true;
        NodeList channels = this.getChannelDescriptionNodes(imageNode);
        NodeList dimensions = this.getDimensionDescriptionNodes(imageNode);
        HashMap<Long, String> bytesPerAxis = new HashMap<Long, String>();
        Double physicalSizeX = null;
        Double physicalSizeY = null;
        this.core[i].sizeC = channels.getLength();
        for (int ch = 0; ch < channels.getLength(); ++ch) {
            long bytes;
            Element channel = (Element)channels.item(ch);
            this.lutNames.add(channel.getAttribute("LUTName"));
            String bytesInc = channel.getAttribute("BytesInc");
            long l = bytes = bytesInc == null ? 0L : Long.parseLong(bytesInc);
            if (bytes <= 0L) continue;
            bytesPerAxis.put(bytes, "C");
        }
        int extras = 1;
        block7: for (int dim = 0; dim < dimensions.getLength(); ++dim) {
            Element dimension = (Element)dimensions.item(dim);
            int id = Integer.parseInt(dimension.getAttribute("DimID"));
            int len = Integer.parseInt(dimension.getAttribute("NumberOfElements"));
            long nBytes = Long.parseLong(dimension.getAttribute("BytesInc"));
            Double physicalLen = new Double(dimension.getAttribute("Length"));
            String unit = dimension.getAttribute("Unit");
            physicalLen = physicalLen / (double)len;
            if (unit.equals("Ks")) {
                physicalLen = physicalLen / 1000.0;
            } else if (unit.equals("m")) {
                physicalLen = physicalLen * 1000000.0;
            }
            switch (id) {
                case 1: {
                    this.core[i].sizeX = len;
                    boolean bl = this.core[i].rgb = nBytes % 3L == 0L;
                    if (this.core[i].rgb) {
                        nBytes /= 3L;
                    }
                    this.core[i].pixelType = FormatTools.pixelTypeFromBytes((int)nBytes, false, true);
                    physicalSizeX = physicalLen;
                    continue block7;
                }
                case 2: {
                    if (this.core[i].sizeY != 0) {
                        if (this.core[i].sizeZ == 1) {
                            this.core[i].sizeZ = len;
                            bytesPerAxis.put(nBytes, "Z");
                            continue block7;
                        }
                        if (this.core[i].sizeT != 1) continue block7;
                        this.core[i].sizeT = len;
                        bytesPerAxis.put(nBytes, "T");
                        continue block7;
                    }
                    this.core[i].sizeY = len;
                    physicalSizeY = physicalLen;
                    continue block7;
                }
                case 3: {
                    if (this.core[i].sizeY == 0) {
                        this.core[i].sizeY = len;
                        this.core[i].sizeZ = 1;
                        bytesPerAxis.put(nBytes, "Y");
                        physicalSizeY = physicalLen;
                        continue block7;
                    }
                    this.core[i].sizeZ = len;
                    bytesPerAxis.put(nBytes, "Z");
                    continue block7;
                }
                case 4: {
                    if (this.core[i].sizeY == 0) {
                        this.core[i].sizeY = len;
                        this.core[i].sizeT = 1;
                        bytesPerAxis.put(nBytes, "Y");
                        physicalSizeY = physicalLen;
                        continue block7;
                    }
                    this.core[i].sizeT = len;
                    bytesPerAxis.put(nBytes, "T");
                    continue block7;
                }
                default: {
                    extras *= len;
                }
            }
        }
        this.physicalSizeXs.add(physicalSizeX);
        this.physicalSizeYs.add(physicalSizeY);
        if (extras > 1) {
            if (this.core[i].sizeZ == 1) {
                this.core[i].sizeZ = extras;
            } else {
                this.core[i].sizeT = this.core[i].sizeT == 0 ? extras : (this.core[i].sizeT *= extras);
            }
        }
        if (this.core[i].sizeC == 0) {
            this.core[i].sizeC = 1;
        }
        if (this.core[i].sizeZ == 0) {
            this.core[i].sizeZ = 1;
        }
        if (this.core[i].sizeT == 0) {
            this.core[i].sizeT = 1;
        }
        this.core[i].interleaved = this.core[i].rgb;
        this.core[i].indexed = !this.core[i].rgb;
        this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeT;
        if (!this.core[i].rgb) {
            this.core[i].imageCount *= this.core[i].sizeC;
        }
        Object[] bytes = bytesPerAxis.keySet().toArray(new Long[0]);
        Arrays.sort(bytes);
        this.core[i].dimensionOrder = "XY";
        for (Object nBytes : bytes) {
            String axis = (String)bytesPerAxis.get(nBytes);
            if (this.core[i].dimensionOrder.indexOf(axis) != -1) continue;
            this.core[i].dimensionOrder = this.core[i].dimensionOrder + axis;
        }
        if (this.core[i].dimensionOrder.indexOf("Z") == -1) {
            this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
        }
        if (this.core[i].dimensionOrder.indexOf("C") == -1) {
            this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
        }
        if (this.core[i].dimensionOrder.indexOf("T") == -1) {
            this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
        }
    }

    private NodeList getNodes(Element root, String nodeName) {
        NodeList nodes = root.getElementsByTagName(nodeName);
        if (nodes.getLength() == 0) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                NodeList childNodes;
                Node child = children.item(i);
                if (!(child instanceof Element) || (childNodes = this.getNodes((Element)child, nodeName)) == null) continue;
                return childNodes;
            }
            return null;
        }
        return nodes;
    }

    private Element getImageDescription(Element root) {
        return (Element)root.getElementsByTagName("ImageDescription").item(0);
    }

    private NodeList getChannelDescriptionNodes(Element root) {
        Element imageDescription = this.getImageDescription(root);
        Element channels = (Element)imageDescription.getElementsByTagName("Channels").item(0);
        return channels.getElementsByTagName("ChannelDescription");
    }

    private NodeList getDimensionDescriptionNodes(Element root) {
        Element imageDescription = this.getImageDescription(root);
        Element channels = (Element)imageDescription.getElementsByTagName("Dimensions").item(0);
        return channels.getElementsByTagName("DimensionDescription");
    }

    private int getChannelIndex(Element filterSetting) {
        int channel;
        String data = filterSetting.getAttribute("data");
        if (data == null || data.equals("")) {
            data = filterSetting.getAttribute("Data");
        }
        int n = channel = data == null || data.equals("") ? 0 : Integer.parseInt(data);
        if (channel < 0) {
            return -1;
        }
        return channel - 1;
    }

    private double parseDouble(String number) {
        if (number != null) {
            number = number.replaceAll(",", ".");
            try {
                return Double.parseDouble(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private Color getChannelColor(int colorCode) {
        switch (colorCode) {
            case 0: {
                return new Color(255, 0, 0, 255);
            }
            case 1: {
                return new Color(0, 255, 0, 255);
            }
            case 2: {
                return new Color(0, 0, 255, 255);
            }
            case 3: {
                return new Color(0, 255, 255, 255);
            }
            case 4: {
                return new Color(255, 0, 255, 255);
            }
            case 5: {
                return new Color(255, 255, 0, 255);
            }
        }
        return new Color(255, 255, 255, 255);
    }

    class ROI {
        public static final int TEXT = 512;
        public static final int SCALE_BAR = 8192;
        public static final int POLYGON = 32;
        public static final int RECTANGLE = 16;
        public static final int LINE = 256;
        public static final int ARROW = 2;
        public int type;
        public Vector<Double> x = new Vector();
        public Vector<Double> y = new Vector();
        public double transX;
        public double transY;
        public double scaleX;
        public double scaleY;
        public double rotation;
        public long color;
        public int linewidth;
        public String text;
        public String fontName;
        public String fontSize;
        public String name;
        private boolean normalized = false;

        ROI() {
        }

        public void storeROI(MetadataStore store, int series, int roi, int roiIndex) {
            MetadataLevel level = LIFReader.this.getMetadataOptions().getMetadataLevel();
            if (level == MetadataLevel.NO_OVERLAYS || level == MetadataLevel.MINIMUM) {
                return;
            }
            String roiID = MetadataTools.createLSID("ROI", roi);
            store.setImageROIRef(roiID, series, roiIndex);
            store.setROIID(roiID, roi);
            store.setLabelID(MetadataTools.createLSID("Shape", roi, 0), roi, 0);
            if (this.text == null) {
                this.text = this.name;
            }
            store.setLabelText(this.text, roi, 0);
            if (this.fontSize != null) {
                try {
                    int size = (int)Double.parseDouble(this.fontSize);
                    if (size > 0) {
                        store.setLabelFontSize(new NonNegativeInteger(size), roi, 0);
                    } else {
                        LOGGER.warn("Expected non-negative value for FontSize; got {}", size);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            store.setLabelStrokeWidth(new Double(this.linewidth), roi, 0);
            if (!this.normalized) {
                this.normalize();
            }
            double cornerX = this.x.get(0);
            double cornerY = this.y.get(0);
            store.setLabelX(cornerX, roi, 0);
            store.setLabelY(cornerY, roi, 0);
            int centerX = ((LIFReader)LIFReader.this).core[series].sizeX / 2 - 1;
            int centerY = ((LIFReader)LIFReader.this).core[series].sizeY / 2 - 1;
            double roiX = (double)centerX + this.transX;
            double roiY = (double)centerY + this.transY;
            if (LIFReader.this.alternateCenter) {
                roiX = this.transX - 2.0 * cornerX;
                roiY = this.transY - 2.0 * cornerY;
            }
            String shapeID = MetadataTools.createLSID("Shape", roi, 1);
            switch (this.type) {
                case 32: {
                    StringBuffer points = new StringBuffer();
                    for (int i = 0; i < this.x.size(); ++i) {
                        points.append(this.x.get(i) + roiX);
                        points.append(",");
                        points.append(this.y.get(i) + roiY);
                        if (i >= this.x.size() - 1) continue;
                        points.append(" ");
                    }
                    store.setPolygonID(shapeID, roi, 1);
                    store.setPolygonPoints(points.toString(), roi, 1);
                    break;
                }
                case 16: 
                case 512: {
                    store.setRectangleID(shapeID, roi, 1);
                    store.setRectangleX(roiX - Math.abs(cornerX), roi, 1);
                    store.setRectangleY(roiY - Math.abs(cornerY), roi, 1);
                    double width = 2.0 * Math.abs(cornerX);
                    double height = 2.0 * Math.abs(cornerY);
                    store.setRectangleWidth(width, roi, 1);
                    store.setRectangleHeight(height, roi, 1);
                    break;
                }
                case 2: 
                case 256: 
                case 8192: {
                    store.setLineID(shapeID, roi, 1);
                    store.setLineX1(roiX + this.x.get(0), roi, 1);
                    store.setLineY1(roiY + this.y.get(0), roi, 1);
                    store.setLineX2(roiX + this.x.get(1), roi, 1);
                    store.setLineY2(roiY + this.y.get(1), roi, 1);
                }
            }
        }

        private void normalize() {
            double coordinate2;
            int i;
            if (this.normalized) {
                return;
            }
            this.transX *= 1000000.0;
            this.transY *= 1000000.0;
            this.transX *= 1.0;
            this.transY *= 1.0;
            for (i = 0; i < this.x.size(); ++i) {
                coordinate2 = this.x.get(i) * 1000000.0;
                this.x.setElementAt(coordinate2 *= 1.0, i);
            }
            for (i = 0; i < this.y.size(); ++i) {
                coordinate2 = this.y.get(i) * 1000000.0;
                this.y.setElementAt(coordinate2 *= 1.0, i);
            }
            this.normalized = true;
        }
    }
}

