/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.plugins.DataSetMover;
import ch.systemsx.cisd.etlserver.plugins.IDataSetMover;
import ch.systemsx.cisd.etlserver.plugins.ISegmentedStoreShuffling;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class SegmentedStoreShufflingTask
implements IDataStoreLockingMaintenanceTask {
    private static final ISegmentedStoreShuffling DUMMY_SHUFFLING = new ISegmentedStoreShuffling(){
        private static final int N = 3;

        @Override
        public void init(ISimpleLogger logger) {
        }

        @Override
        public void shuffleDataSets(List<Share> sourceShares, List<Share> targetShares, IEncapsulatedOpenBISService service, IDataSetMover dataSetMover, ISimpleLogger logger) {
            logger.log(LogLevel.INFO, "Data Store Shares:");
            for (Share share : targetShares) {
                List<SimpleDataSetInformationDTO> dataSets = share.getDataSetsOrderedBySize();
                logger.log(LogLevel.INFO, "   " + (share.isIncoming() ? "Incoming" : "External") + " share " + share.getShareId() + " (free space: " + FileUtils.byteCountToDisplaySize((long)share.calculateFreeSpace()) + ") has " + dataSets.size() + " data sets occupying " + FileUtilities.byteCountToDisplaySize(share.getTotalSizeOfDataSets()) + ".");
                int i = 0;
                int n = Math.min(3, dataSets.size());
                while (i < n) {
                    SimpleDataSetInformationDTO dataSet = dataSets.get(i);
                    logger.log(LogLevel.INFO, "      " + dataSet.getDataSetCode() + " " + FileUtilities.byteCountToDisplaySize(dataSet.getDataSetSize()));
                    ++i;
                }
                if (dataSets.size() <= 3) continue;
                logger.log(LogLevel.INFO, "      ...");
            }
        }
    };
    @Private
    static final String SHUFFLING_SECTION_NAME = "shuffling";
    @Private
    static final String CLASS_PROPERTY_NAME = "class";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SegmentedStoreShufflingTask.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, SegmentedStoreShufflingTask.class);
    private final Set<String> incomingShares;
    private final IEncapsulatedOpenBISService service;
    private final IDataSetMover dataSetMover;
    private final IFreeSpaceProvider freeSpaceProvider;
    private final ISimpleLogger operationLogger;
    private File storeRoot;
    private String dataStoreCode;
    @Private
    ISegmentedStoreShuffling shuffling;

    public SegmentedStoreShufflingTask() {
        this(IncomingShareIdProvider.getIdsOfIncomingShares(), ServiceProvider.getOpenBISService(), new SimpleFreeSpaceProvider(), new DataSetMover(ServiceProvider.getOpenBISService(), ServiceProvider.getShareIdManager()), new Log4jSimpleLogger(operationLog));
    }

    SegmentedStoreShufflingTask(Set<String> incomingShares, IEncapsulatedOpenBISService service, IFreeSpaceProvider freeSpaceProvider, IDataSetMover dataSetMover, ISimpleLogger logger) {
        this.incomingShares = incomingShares;
        LogInitializer.init();
        this.freeSpaceProvider = freeSpaceProvider;
        this.service = service;
        this.dataSetMover = dataSetMover;
        this.operationLogger = logger;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.dataStoreCode = PropertyUtils.getMandatoryProperty(properties, "data-store-server-code").toUpperCase();
        this.storeRoot = new File(PropertyUtils.getMandatoryProperty(properties, "storeroot-dir"));
        if (!this.storeRoot.isDirectory()) {
            throw new ConfigurationFailureException("Store root does not exists or is not a directory: " + this.storeRoot.getAbsolutePath());
        }
        this.shuffling = this.createShuffling(properties);
        this.shuffling.init(this.operationLogger);
        operationLog.info((Object)("Plugin '" + pluginName + "' initialized: shuffling strategy: " + this.shuffling.getClass().getName() + ", data store code: " + this.dataStoreCode + ", data store root: " + this.storeRoot.getAbsolutePath() + ", incoming shares: " + this.incomingShares));
    }

    private ISegmentedStoreShuffling createShuffling(Properties properties) {
        Properties shufflingProps = PropertyParametersUtil.extractSingleSectionProperties(properties, SHUFFLING_SECTION_NAME, false).getProperties();
        String className = shufflingProps.getProperty(CLASS_PROPERTY_NAME);
        if (className == null) {
            return DUMMY_SHUFFLING;
        }
        try {
            return ClassUtils.create(ISegmentedStoreShuffling.class, className, shufflingProps);
        }
        catch (ConfigurationFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot find shuffling class '" + className + "'", CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }

    @Override
    public void execute() {
        operationLog.info((Object)"Starting segmented store shuffling.");
        List<Share> shares = this.listShares();
        ArrayList<Share> sourceShares = new ArrayList<Share>();
        TreeSet<String> nonEmptyShares = new TreeSet<String>();
        for (Share share : shares) {
            if (this.incomingShares.contains(share.getShareId()) || share.isWithdrawShare()) {
                sourceShares.add(share);
            }
            if (share.getDataSetsOrderedBySize().isEmpty()) continue;
            nonEmptyShares.add(share.getShareId());
        }
        this.shuffling.shuffleDataSets(sourceShares, shares, this.service, this.dataSetMover, this.operationLogger);
        operationLog.info((Object)"Segmented store shuffling finished.");
        TreeSet<String> emptyShares = new TreeSet<String>();
        for (Share share : this.listShares()) {
            if (!share.getDataSetsOrderedBySize().isEmpty() || !nonEmptyShares.contains(share.getShareId())) continue;
            emptyShares.add(share.getShareId());
        }
        if (!emptyShares.isEmpty()) {
            notificationLog.info((Object)("The following shares were emptied by shuffling: " + emptyShares));
        }
    }

    private List<Share> listShares() {
        return SegmentedStoreUtils.getSharesWithDataSets(this.storeRoot, this.dataStoreCode, true, Collections.<String>emptySet(), this.freeSpaceProvider, this.service, this.operationLogger);
    }

    @Override
    public boolean requiresDataStoreLock() {
        return true;
    }
}

