/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDataMergingReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MergedRowDataReportingPlugin
extends AbstractDataMergingReportingPlugin {
    private static final long serialVersionUID = 1L;

    public MergedRowDataReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        builder.addHeader("Data Set Code");
        if (!datasets.isEmpty()) {
            Object[] titles;
            IDataSetDirectoryProvider directoryProvider = context.getDirectoryProvider();
            DatasetDescription firstDataset = datasets.get(0);
            Object[] objectArray = titles = this.getHeaderTitles(firstDataset, directoryProvider);
            int n = titles.length;
            int n2 = 0;
            while (n2 < n) {
                String title = objectArray[n2];
                builder.addHeader(title);
                ++n2;
            }
            for (DatasetDescription dataset : datasets) {
                File dir;
                DatasetFileLines lines = this.loadFromDirectory(dataset, dir = this.getDataSubDir(directoryProvider, dataset));
                if (!Arrays.equals(titles, lines.getHeaderLabels())) {
                    throw UserFailureException.fromTemplate("All Data Set files should have the same headers, but file header of '%s': \n\t '%s' is different than file header of '%s': \n\t '%s'.", firstDataset.getDataSetCode(), StringUtils.join((Object[])titles, (String)"\t"), dataset.getDataSetCode(), StringUtils.join((Object[])lines.getHeaderLabels(), (String)"\t"));
                }
                MergedRowDataReportingPlugin.addDataRows(builder, dataset, lines, false);
            }
        }
        return builder.getTableModel();
    }
}

