/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServer;
import ch.systemsx.cisd.openbis.dss.generic.server.IServletPropertiesManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.ArchiverPluginFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.PluginTaskProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.ProcessingPluginTaskFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.ReportingPluginTaskFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SessionWorkspaceUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatastoreServiceDescriptions;
import java.io.File;
import java.util.Properties;

public class PluginTaskInfoProvider
implements IPluginTaskInfoProvider {
    public static final String STOREROOT_DIR_KEY = "storeroot-dir";
    @Private
    static final String ARCHIVER_SECTION_NAME = "archiver";
    private final PluginTaskProvider<IReportingPluginTask> reportingPlugins;
    private final PluginTaskProvider<IProcessingPluginTask> processingPlugins;
    private final ArchiverPluginFactory archiverTaskFactory;
    private final File storeRoot;
    private final File sessionWorkspaceRootDir;

    public static IPluginTaskInfoProvider create() {
        ConfigParameters servletPropertiesManager = DataStoreServer.getConfigParameters();
        ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
        String storeRootDir = ((Properties)properties).getProperty(STOREROOT_DIR_KEY);
        File storeRoot = new File(storeRootDir);
        File workspaceRoot = SessionWorkspaceUtil.getSessionWorkspace(properties);
        PluginTaskInfoProvider providers = new PluginTaskInfoProvider(properties, servletPropertiesManager, storeRoot, workspaceRoot);
        providers.check();
        providers.logConfigurations();
        return providers;
    }

    @Private
    public PluginTaskInfoProvider(Properties serviceProperties, IServletPropertiesManager servletPropertiesManager, File storeRoot, File sessionWorkspaceRoot) {
        this.storeRoot = storeRoot;
        this.sessionWorkspaceRootDir = sessionWorkspaceRoot;
        String datastoreCode = DssPropertyParametersUtil.getDataStoreCode(serviceProperties);
        this.reportingPlugins = PluginTaskInfoProvider.createReportingPluginsFactories(serviceProperties, servletPropertiesManager, datastoreCode, storeRoot);
        this.processingPlugins = PluginTaskInfoProvider.createProcessingPluginsFactories(serviceProperties, servletPropertiesManager, datastoreCode, storeRoot);
        this.archiverTaskFactory = this.createArchiverTaskFactory(serviceProperties, datastoreCode);
    }

    @Override
    public final File getStoreRoot() {
        return this.storeRoot;
    }

    @Override
    public File getSessionWorkspaceRootDir() {
        return this.sessionWorkspaceRootDir;
    }

    @Override
    public PluginTaskProvider<IReportingPluginTask> getReportingPluginsProvider() {
        return this.reportingPlugins;
    }

    @Override
    public PluginTaskProvider<IProcessingPluginTask> getProcessingPluginsProvider() {
        return this.processingPlugins;
    }

    @Override
    public ArchiverPluginFactory getArchiverPluginFactory() {
        return this.archiverTaskFactory;
    }

    private void check() {
        this.processingPlugins.check(true);
        this.reportingPlugins.check(false);
    }

    @Override
    public void logConfigurations() {
        this.processingPlugins.logConfigurations();
        this.reportingPlugins.logConfigurations();
        this.archiverTaskFactory.logConfiguration();
    }

    @Private
    static PluginTaskProvider<IReportingPluginTask> createReportingPluginsFactories(Properties serviceProperties, IServletPropertiesManager configParameters, String datastoreCode, File storeRoot) {
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PluginTaskInfoProvider.extractSectionProperties(serviceProperties, "reporting-plugins");
        ReportingPluginTaskFactory[] factories = new ReportingPluginTaskFactory[sectionsProperties.length];
        int i = 0;
        while (i < factories.length) {
            factories[i] = new ReportingPluginTaskFactory(configParameters, sectionsProperties[i], datastoreCode, storeRoot);
            ++i;
        }
        return new PluginTaskProvider<IReportingPluginTask>(factories);
    }

    @Private
    static PluginTaskProvider<IProcessingPluginTask> createProcessingPluginsFactories(Properties serviceProperties, IServletPropertiesManager configParameters, String datastoreCode, File storeRoot) {
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PluginTaskInfoProvider.extractSectionProperties(serviceProperties, "processing-plugins");
        ProcessingPluginTaskFactory[] factories = new ProcessingPluginTaskFactory[sectionsProperties.length];
        int i = 0;
        while (i < factories.length) {
            factories[i] = new ProcessingPluginTaskFactory(configParameters, sectionsProperties[i], datastoreCode, storeRoot);
            ++i;
        }
        return new PluginTaskProvider<IProcessingPluginTask>(factories);
    }

    private ArchiverPluginFactory createArchiverTaskFactory(Properties serviceProperties, String datastoreCode) {
        PropertyParametersUtil.SectionProperties sectionsProperties = PluginTaskInfoProvider.extractSingleSectionProperties(serviceProperties, ARCHIVER_SECTION_NAME);
        return new ArchiverPluginFactory(sectionsProperties);
    }

    private static PropertyParametersUtil.SectionProperties[] extractSectionProperties(Properties serviceProperties, String namesListPropertyKey) {
        return PropertyParametersUtil.extractSectionProperties(serviceProperties, namesListPropertyKey, false);
    }

    private static PropertyParametersUtil.SectionProperties extractSingleSectionProperties(Properties serviceProperties, String sectionName) {
        return PropertyParametersUtil.extractSingleSectionProperties(serviceProperties, sectionName, false);
    }

    @Override
    public DatastoreServiceDescriptions getPluginTaskDescriptions() {
        return new DatastoreServiceDescriptions(this.reportingPlugins.getPluginDescriptions(), this.processingPlugins.getPluginDescriptions());
    }
}

