/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1;

import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class FileInfoDssBuilder {
    private final File dataSetRootFile;
    private final File listingRootFile;

    public static List<FileInfoDssDTO> getFileInfos(File dataSetContents) {
        FileInfoDssBuilder fileInfoBuilder = new FileInfoDssBuilder(dataSetContents.getAbsolutePath(), dataSetContents.getAbsolutePath());
        ArrayList<FileInfoDssDTO> fileInfos = new ArrayList<FileInfoDssDTO>();
        try {
            fileInfoBuilder.appendFileInfosForFile(dataSetContents, fileInfos, true);
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error occurred while gathering information from the local data set contents: " + ioex.getMessage(), ioex);
        }
        return fileInfos;
    }

    public FileInfoDssBuilder(String dataSetRoot, String relativeRoot) {
        this.dataSetRootFile = new File(dataSetRoot);
        this.listingRootFile = new File(relativeRoot);
    }

    public void appendFileInfosForFile(File requestedFile, ArrayList<FileInfoDssDTO> list, boolean isRecursive) throws IOException {
        this.appendFileInfosForFile(requestedFile, list, isRecursive ? Integer.MAX_VALUE : 0, true);
    }

    private void appendFileInfosForFile(File requestedFile, ArrayList<FileInfoDssDTO> list, int maxDepth, boolean excludeTopLevelIfDirectory) throws IOException {
        File[] files;
        FileInfoDssDTO fileInfo = this.fileInfoForFile(requestedFile);
        if (!excludeTopLevelIfDirectory || !fileInfo.isDirectory()) {
            list.add(fileInfo);
        }
        if (!fileInfo.isDirectory() || maxDepth < 0) {
            return;
        }
        File[] fileArray = files = requestedFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.appendFileInfosForFile(file, list, maxDepth - 1, false);
            ++n2;
        }
    }

    private FileInfoDssDTO fileInfoForFile(File file) throws IOException {
        FileInfoDssDTO fileInfo = new FileInfoDssDTO(this.pathRelativeToDataSetRoot(file), this.pathRelativeToListingRoot(file), file.isDirectory(), file.isDirectory() ? -1L : file.length());
        return fileInfo;
    }

    private String pathRelativeToDataSetRoot(File file) throws IOException {
        URI dataSetRootUri = this.dataSetRootFile.toURI();
        URI fileUri = file.getCanonicalFile().toURI();
        String result = dataSetRootUri.relativize(fileUri).toString();
        result = URLDecoder.decode(result, "UTF-8");
        result = result.replaceAll("/+$", "");
        return result;
    }

    private String pathRelativeToListingRoot(File file) throws IOException {
        String result = this.listingRootFile.toURI().relativize(file.toURI()).toString();
        result = URLDecoder.decode(result, "UTF-8");
        return result;
    }
}

