/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class VocabularyTermsProvider
extends AbstractCommonTableModelProvider<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats> {
    private final Vocabulary vocabulary;

    public VocabularyTermsProvider(ICommonServer commonServer, String sessionToken, Vocabulary vocabulary) {
        super(commonServer, sessionToken);
        this.vocabulary = vocabulary;
    }

    @Override
    protected TypedTableModel<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats> createTableModel() {
        TypedTableModelBuilder<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats> builder = new TypedTableModelBuilder<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats>();
        List<VocabularyTermWithStats> terms = this.commonServer.listVocabularyTermsWithStatistics(this.sessionToken, this.vocabulary);
        builder.addColumn("CODE");
        builder.addColumn("LABEL").withDefaultWidth(200);
        builder.addColumn("DESCRIPTION").withDefaultWidth(300);
        builder.addColumn("ORDINAL").withDefaultWidth(100).hideByDefault();
        builder.addColumn("URL").withDefaultWidth(200);
        builder.addColumn("IS_OFFICIAL").withDefaultWidth(100).hideByDefault();
        builder.addColumn("REGISTRATOR").withDefaultWidth(200);
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("TERM_TOTAL_USAGE").withDefaultWidth(100);
        builder.addColumn("TERM_FOR_DATA_SET_USAGE").withDefaultWidth(100).hideByDefault();
        builder.addColumn("TERM_FOR_EXPERIMENTS_USAGE").withDefaultWidth(100).hideByDefault();
        builder.addColumn("TERM_FOR_MATERIALS_USAGE").withDefaultWidth(100).hideByDefault();
        builder.addColumn("TERM_FOR_SAMPLES_USAGE").withDefaultWidth(100).hideByDefault();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats termWithStats : VocabularyTermTranslator.translate(terms)) {
            builder.addRow(termWithStats);
            VocabularyTerm term = termWithStats.getTerm();
            builder.column("CODE").addString(term.getCode());
            builder.column("LABEL").addString(term.getLabel());
            builder.column("DESCRIPTION").addString(term.getDescription());
            builder.column("ORDINAL").addInteger(term.getOrdinal());
            builder.column("URL").addString(term.getUrl());
            builder.column("IS_OFFICIAL").addString(term.isOfficial() == null ? null : SimpleYesNoRenderer.render(term.isOfficial()));
            builder.column("REGISTRATOR").addPerson(term.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(term.getRegistrationDate());
            builder.column("TERM_TOTAL_USAGE").addInteger(Long.valueOf(termWithStats.getTotalUsageCounter()));
            builder.column("TERM_FOR_DATA_SET_USAGE").addInteger(termWithStats.getUsageCounter(EntityKind.DATA_SET));
            builder.column("TERM_FOR_EXPERIMENTS_USAGE").addInteger(termWithStats.getUsageCounter(EntityKind.EXPERIMENT));
            builder.column("TERM_FOR_MATERIALS_USAGE").addInteger(termWithStats.getUsageCounter(EntityKind.MATERIAL));
            builder.column("TERM_FOR_SAMPLES_USAGE").addInteger(termWithStats.getUsageCounter(EntityKind.SAMPLE));
        }
        return builder.getModel();
    }
}

