/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ExperimentToDataSetRelatedEntitiesTranslator {
    private final HashMap<String, ExperimentType> experimentTypesMap;
    private final List<Experiment> experiments;
    private final ArrayList<BasicEntityInformationHolder> entityInformationHolders;

    public ExperimentToDataSetRelatedEntitiesTranslator(List<ExperimentType> experimentTypes, List<Experiment> experiments) {
        this.experimentTypesMap = ExperimentToDataSetRelatedEntitiesTranslator.convertExperimentTypesListToMap(experimentTypes);
        this.experiments = experiments;
        this.entityInformationHolders = new ArrayList(experiments.size());
    }

    private static HashMap<String, ExperimentType> convertExperimentTypesListToMap(List<ExperimentType> experimentTypes) {
        HashMap<String, ExperimentType> map = new HashMap<String, ExperimentType>(experimentTypes.size());
        for (ExperimentType experimentType : experimentTypes) {
            map.put(experimentType.getCode(), experimentType);
        }
        return map;
    }

    public DataSetRelatedEntities convertToDataSetRelatedEntities() {
        for (Experiment experiment : this.experiments) {
            BasicEntityInformationHolder holderOrNull = this.tryConvertExperimentToEntityInformationHolder(experiment);
            if (holderOrNull == null) continue;
            this.entityInformationHolders.add(holderOrNull);
        }
        return new DataSetRelatedEntities(this.entityInformationHolders);
    }

    private BasicEntityInformationHolder tryConvertExperimentToEntityInformationHolder(Experiment experiment) {
        EntityType entityType = this.experimentTypesMap.get(experiment.getExperimentTypeCode());
        if (entityType == null) {
            return null;
        }
        BasicEntityInformationHolder holder = new BasicEntityInformationHolder(EntityKind.EXPERIMENT, entityType, experiment.getCode(), experiment.getId(), experiment.getPermId());
        return holder;
    }
}

