/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.common.ssl.SslCertificateHelper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IDataSetTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IExperimentTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IFileFormatTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMaterialTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyAssignmentImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.ISampleTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IScriptImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabularyImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.DataSetType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.DataSetTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExperimentTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.FileFormatTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MaterialTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyAssignment;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyAssignmentImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.SampleType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.SampleTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.Script;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ScriptImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyTermImmutable;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.ArrayList;
import java.util.List;

public class EncapsulatedCommonServer {
    private static final String SERVICE_PATH = "/rmi-common";
    private final ICommonServer commonServer;
    private final String sessionToken;

    public static EncapsulatedCommonServer create(String openBisUrl, String userID, String password) {
        SslCertificateHelper.trustAnyCertificate(openBisUrl);
        ICommonServer commonService = HttpInvokerUtils.createServiceStub(ICommonServer.class, String.valueOf(openBisUrl) + SERVICE_PATH, 300000L);
        SessionContextDTO session = commonService.tryAuthenticate(userID, password);
        if (session == null) {
            throw UserFailureException.fromTemplate("Invalid username/password combination", new Object[0]);
        }
        return new EncapsulatedCommonServer(commonService, session.getSessionToken());
    }

    public static EncapsulatedCommonServer create(ICommonServer commonServer, String sessionToken) {
        if (StringUtils.isBlank(sessionToken)) {
            throw UserFailureException.fromTemplate("The specified session token cannot be empty.", new Object[0]);
        }
        return new EncapsulatedCommonServer(commonServer, sessionToken);
    }

    private EncapsulatedCommonServer(ICommonServer commonServer, String sessionToken) {
        this.commonServer = commonServer;
        this.sessionToken = sessionToken;
    }

    public List<IExperimentTypeImmutable> listExperimentTypes() {
        ArrayList<IExperimentTypeImmutable> result = new ArrayList<IExperimentTypeImmutable>();
        for (ExperimentType type : this.commonServer.listExperimentTypes(this.sessionToken)) {
            result.add(new ExperimentTypeImmutable(type));
        }
        return result;
    }

    public List<ISampleTypeImmutable> listSampleTypes() {
        ArrayList<ISampleTypeImmutable> result = new ArrayList<ISampleTypeImmutable>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType type : this.commonServer.listSampleTypes(this.sessionToken)) {
            result.add(new SampleTypeImmutable(type));
        }
        return result;
    }

    public List<IDataSetTypeImmutable> listDataSetTypes() {
        ArrayList<IDataSetTypeImmutable> result = new ArrayList<IDataSetTypeImmutable>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType type : this.commonServer.listDataSetTypes(this.sessionToken)) {
            result.add(new DataSetTypeImmutable(type));
        }
        return result;
    }

    public List<IMaterialTypeImmutable> listMaterialTypes() {
        ArrayList<IMaterialTypeImmutable> result = new ArrayList<IMaterialTypeImmutable>();
        for (MaterialType type : this.commonServer.listMaterialTypes(this.sessionToken)) {
            result.add(new MaterialTypeImmutable(type));
        }
        return result;
    }

    public List<IPropertyTypeImmutable> listPropertyTypes() {
        ArrayList<IPropertyTypeImmutable> result = new ArrayList<IPropertyTypeImmutable>();
        for (PropertyType type : this.commonServer.listPropertyTypes(this.sessionToken, false)) {
            result.add(new PropertyTypeImmutable(type));
        }
        return result;
    }

    public List<IFileFormatTypeImmutable> listFileFormatTypes() {
        ArrayList<IFileFormatTypeImmutable> result = new ArrayList<IFileFormatTypeImmutable>();
        for (FileFormatType type : this.commonServer.listFileFormatTypes(this.sessionToken)) {
            result.add(new FileFormatTypeImmutable(type));
        }
        return result;
    }

    public List<IScriptImmutable> listScripts() {
        ArrayList<IScriptImmutable> result = new ArrayList<IScriptImmutable>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script script : this.commonServer.listScripts(this.sessionToken, null, null)) {
            result.add(new ScriptImmutable(script));
        }
        return result;
    }

    public void registerExperimentType(ExperimentTypeImmutable experimentType) {
        this.commonServer.registerExperimentType(this.sessionToken, experimentType.getExperimentType());
    }

    public void registerSampleType(SampleType sampleType) {
        this.commonServer.registerSampleType(this.sessionToken, sampleType.getSampleType());
    }

    public void registerDataSetType(DataSetType dataSetType) {
        this.commonServer.registerDataSetType(this.sessionToken, dataSetType.getDataSetType());
    }

    public void registerScript(Script script) {
        this.commonServer.registerScript(this.sessionToken, script.script);
    }

    public void registerMaterialType(MaterialTypeImmutable materialType) {
        this.commonServer.registerMaterialType(this.sessionToken, materialType.getMaterialType());
    }

    public void registerPropertyType(PropertyTypeImmutable propertyType) {
        this.commonServer.registerPropertyType(this.sessionToken, propertyType.getPropertyType());
    }

    public void registerPropertyAssignment(PropertyAssignment assignment) {
        this.commonServer.assignPropertyType(this.sessionToken, assignment.getAssignment());
    }

    public void registerFileFormatType(FileFormatTypeImmutable fileFormatType) {
        this.commonServer.registerFileFormatType(this.sessionToken, fileFormatType.getFileFormatType());
    }

    public void logout() {
        this.commonServer.logout(this.sessionToken);
    }

    public void registerVocabulary(VocabularyImmutable vocabulary) {
        NewVocabulary newVocabulary = this.asNewVocabulary(vocabulary.getVocabulary());
        this.commonServer.registerVocabulary(this.sessionToken, newVocabulary);
    }

    public void addVocabularyTerms(Long vocabularyId, List<VocabularyTerm> terms, Long previousTermOrdinal) {
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> list = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm>();
        for (VocabularyTerm vocabularyTerm : terms) {
            list.add(vocabularyTerm.getVocabularyTerm());
        }
        this.commonServer.addVocabularyTerms(this.sessionToken, new TechId(vocabularyId), list, previousTermOrdinal);
    }

    public void update(VocabularyTermImmutable term) {
        this.commonServer.updateVocabularyTerm(this.sessionToken, term.getVocabularyTerm());
    }

    public List<IPropertyAssignmentImmutable> listPropertyAssignments() {
        ArrayList<IPropertyAssignmentImmutable> assignments = new ArrayList<IPropertyAssignmentImmutable>();
        for (EntityTypePropertyType<?> etpt : this.commonServer.listEntityTypePropertyTypes(this.sessionToken)) {
            PropertyAssignmentImmutable assignment = new PropertyAssignmentImmutable(etpt);
            assignments.add(assignment);
        }
        return assignments;
    }

    public List<IVocabularyImmutable> listVocabularies() {
        ArrayList<IVocabularyImmutable> vocabularies = new ArrayList<IVocabularyImmutable>();
        for (Vocabulary vocabulary : this.commonServer.listVocabularies(this.sessionToken, true, false)) {
            vocabularies.add(new VocabularyImmutable(vocabulary));
        }
        return vocabularies;
    }

    private NewVocabulary asNewVocabulary(Vocabulary vocabulary) {
        NewVocabulary result = new NewVocabulary();
        result.setId(vocabulary.getId());
        result.setCode(vocabulary.getCode());
        result.setDescription(vocabulary.getDescription());
        result.setChosenFromList(vocabulary.isChosenFromList());
        result.setInternalNamespace(vocabulary.isInternalNamespace());
        result.setManagedInternally(vocabulary.isManagedInternally());
        result.setURLTemplate(vocabulary.getURLTemplate());
        result.setRegistrationDate(vocabulary.getRegistrationDate());
        result.setRegistrator(vocabulary.getRegistrator());
        result.setTerms(vocabulary.getTerms());
        return result;
    }

    public List<IExternalDataManagementSystemImmutable> listExternalDataManagementSystems() {
        ArrayList<IExternalDataManagementSystemImmutable> result = new ArrayList<IExternalDataManagementSystemImmutable>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem edms : this.commonServer.listExternalDataManagementSystems(this.sessionToken)) {
            result.add(new ExternalDataManagementSystemImmutable(edms));
        }
        return result;
    }

    public void createOrUpdateExternalDataManagementSystem(ExternalDataManagementSystem edms) {
        this.commonServer.createOrUpdateExternalDataManagementSystem(this.sessionToken, edms.getExternalDataManagementSystem());
    }

    public IExternalDataManagementSystemImmutable getExternalDataManagementSystem(String code) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem edms = this.commonServer.getExternalDataManagementSystem(this.sessionToken, code);
        if (edms != null) {
            return new ExternalDataManagementSystemImmutable(edms);
        }
        return null;
    }
}

