/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.IRangeType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.RangeType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ScreeningDisplaySettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScreeningDisplaySettingsManager {
    private static final String DELIMITER = ",";
    private final ScreeningDisplaySettings screeningSettings;

    public ScreeningDisplaySettingsManager(IViewContext<?> viewContext) {
        DisplaySettingsManager displaySettingsManager = viewContext.getDisplaySettingsManager();
        ScreeningDisplaySettings settingsOrNull = (ScreeningDisplaySettings)displaySettingsManager.tryGetTechnologySpecificSettings(viewContext.getTechnology());
        if (settingsOrNull == null) {
            settingsOrNull = new ScreeningDisplaySettings();
            displaySettingsManager.setTechnologySpecificSettings(viewContext.getTechnology(), settingsOrNull);
        }
        this.screeningSettings = settingsOrNull;
    }

    public List<String> tryGetDefaultChannels(String displayTypeID) {
        String channelListString = this.screeningSettings.getDefaultChannels().get(displayTypeID);
        if (channelListString != null) {
            return Arrays.asList(channelListString.split(DELIMITER));
        }
        return null;
    }

    public void setDefaultChannels(String displayTypeID, List<String> channels) {
        String channelListString = StringUtils.join(channels.toArray(new String[0]), DELIMITER);
        this.screeningSettings.getDefaultChannels().put(displayTypeID, channelListString);
    }

    public void setDefaultAnalysisProcedure(String analysisProcedure) {
        this.screeningSettings.setDefaultAnalysisProcedure(analysisProcedure);
    }

    public String getDefaultAnalysisProcedure() {
        return this.screeningSettings.getDefaultAnalysisProcedure();
    }

    public ImageResolution getDefaultResolution(String displayTypeId) {
        Map<String, ImageResolution> resolutions = this.screeningSettings.getDefaultResolutions();
        if (resolutions == null) {
            return null;
        }
        return resolutions.get(displayTypeId);
    }

    public void setDefaultResolution(String displayTypeId, ImageResolution resolution) {
        Map<String, ImageResolution> resolutions = this.screeningSettings.getDefaultResolutions();
        if (resolutions == null) {
            resolutions = new HashMap<String, ImageResolution>();
            this.screeningSettings.setDefaultResolutions(resolutions);
        }
        resolutions.put(displayTypeId, resolution);
    }

    public Map<String, String> getDefaultTransformationsForChannels(String displayTypeId) {
        Map<String, String> transformations = this.screeningSettings.getDefaultTransformations().get(displayTypeId);
        if (transformations == null) {
            transformations = new HashMap<String, String>();
            this.screeningSettings.getDefaultTransformations().put(displayTypeId, transformations);
        }
        return transformations;
    }

    public Integer getDefaultMovieDelay(String displayTypeId) {
        Map<String, Integer> delays = this.screeningSettings.getDefaultMovieDelays();
        if (delays != null && delays.get(displayTypeId) != null) {
            return delays.get(displayTypeId);
        }
        return 500;
    }

    public void setDefaultMovieDelay(String displayTypeId, Integer delay) {
        Map<String, Integer> delays = this.screeningSettings.getDefaultMovieDelays();
        if (delays == null) {
            delays = new HashMap<String, Integer>();
            this.screeningSettings.setDefaultMovieDelays(delays);
        }
        delays.put(displayTypeId, delay);
    }

    public IRangeType getHeatMapRangeType(String featureCode) {
        IRangeType rangeType;
        Map<String, IRangeType> featureRangeTypes = this.screeningSettings.getDefaultFeatureRangeTypes();
        if (featureRangeTypes != null && (rangeType = featureRangeTypes.get(featureCode)) != null) {
            return rangeType;
        }
        return RangeType.MIN_MAX;
    }

    public void setHeatMapRangeType(String featureCode, IRangeType rangeType) {
        Map<String, IRangeType> featureRangeTypes = this.screeningSettings.getDefaultFeatureRangeTypes();
        if (featureRangeTypes == null) {
            featureRangeTypes = new HashMap<String, IRangeType>();
            this.screeningSettings.setDefaultFeatureRangeTypes(featureRangeTypes);
        }
        featureRangeTypes.put(featureCode, rangeType);
    }

    public Map<String, IntensityRange> getIntensityRangesForChannels(String displayTypeId) {
        Map<String, IntensityRange> intensityRangesForChannels = this.screeningSettings.getIntensityRangesForChannels().get(displayTypeId);
        if (intensityRangesForChannels == null) {
            intensityRangesForChannels = new HashMap<String, IntensityRange>();
            this.screeningSettings.getIntensityRangesForChannels().put(displayTypeId, intensityRangesForChannels);
        }
        return intensityRangesForChannels;
    }
}

