/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageClickHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageChannelsReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.image.StackImage;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.image.StackImageInitializer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.ui.Widget;
import com.reveregroup.gwt.imagepreloader.FitImageLoadEvent;
import com.reveregroup.gwt.imagepreloader.FitImageLoadHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LazyImageSeriesFrame
extends LayoutContainer {
    private final int imageWidth;
    private final int imageHeight;
    private final String sessionId;
    private final LogicalImageChannelsReference channelReferences;
    private ImageChannelStack[][] tilesMap;
    private boolean needsImageDownload;
    private boolean imagesDownloaded;
    private List<ImagesDownloadListener> imagesDownloadListeners = new ArrayList<ImagesDownloadListener>();
    private LogicalImageClickHandler imageClickHandler;

    public LazyImageSeriesFrame(List<ImageChannelStack> seriesPointStacks, LogicalImageChannelsReference channelReferences, String sessionId, int imageWidth, int imageHeight) {
        LogicalImageReference images = channelReferences.getBasicImage();
        TableLayout tableLayout = new TableLayout(images.getTileColsNum());
        tableLayout.setCellSpacing(3);
        this.setLayout((Layout)tableLayout);
        this.tilesMap = LazyImageSeriesFrame.createTilesMap(seriesPointStacks, images);
        this.channelReferences = channelReferences;
        this.sessionId = sessionId;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.needsImageDownload = this.areImagesExistingOnServer();
    }

    public boolean needsImageDownload() {
        return this.needsImageDownload;
    }

    public boolean areImagesDownloaded() {
        return this.imagesDownloaded;
    }

    public synchronized void downloadImagesFromServer() {
        if (!this.needsImageDownload) {
            return;
        }
        this.needsImageDownload = false;
        FitImageLoadHandler loadAndErrorhandler = this.createLoadHandler();
        int row = 0;
        while (row < this.tilesMap.length) {
            int col = 0;
            while (col < this.tilesMap[row].length) {
                ImageChannelStack stackRef = this.tilesMap[row][col];
                if (stackRef != null) {
                    StackImageInitializer initializer = new StackImageInitializer();
                    initializer.setSessionId(this.sessionId);
                    initializer.setChannelReferences(this.channelReferences);
                    initializer.setStack(stackRef);
                    initializer.setImageWidth(this.imageWidth);
                    initializer.setImageHeight(this.imageHeight);
                    initializer.setImageLoadHandler(loadAndErrorhandler);
                    initializer.setImageClickHandler(this.imageClickHandler);
                    this.add((Component)new StackImage(initializer));
                } else {
                    LazyImageSeriesFrame.addDummyImage(this, this.imageWidth, this.imageHeight);
                }
                ++col;
            }
            ++row;
        }
    }

    private FitImageLoadHandler createLoadHandler() {
        final int totalTilesToDownload = this.getNumberOfTilesToDownload();
        return new FitImageLoadHandler(){
            int tilesDownloaded = 0;

            public void imageLoaded(FitImageLoadEvent event) {
                ++this.tilesDownloaded;
                if (this.tilesDownloaded >= totalTilesToDownload) {
                    LazyImageSeriesFrame.this.imagesDownloaded = true;
                    if (LazyImageSeriesFrame.this.imagesDownloadListeners != null) {
                        for (ImagesDownloadListener listener : LazyImageSeriesFrame.this.imagesDownloadListeners) {
                            listener.imagesDownloaded(LazyImageSeriesFrame.this);
                        }
                    }
                }
            }
        };
    }

    private int getNumberOfTilesToDownload() {
        int totalImagesToDownload = 0;
        ImageChannelStack[][] imageChannelStackArray = this.tilesMap;
        int n = this.tilesMap.length;
        int n2 = 0;
        while (n2 < n) {
            ImageChannelStack[] stackRefArray;
            ImageChannelStack[] imageChannelStackArray2 = stackRefArray = imageChannelStackArray[n2];
            int n3 = stackRefArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ImageChannelStack stackRef = imageChannelStackArray2[n4];
                if (stackRef != null) {
                    ++totalImagesToDownload;
                }
                ++n4;
            }
            ++n2;
        }
        return totalImagesToDownload;
    }

    private boolean areImagesExistingOnServer() {
        ImageChannelStack[][] imageChannelStackArray = this.tilesMap;
        int n = this.tilesMap.length;
        int n2 = 0;
        while (n2 < n) {
            ImageChannelStack[] stackRefArray;
            ImageChannelStack[] imageChannelStackArray2 = stackRefArray = imageChannelStackArray[n2];
            int n3 = stackRefArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ImageChannelStack stackRef = imageChannelStackArray2[n4];
                if (stackRef != null) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private static ImageChannelStack[][] createTilesMap(List<ImageChannelStack> stackReferences, LogicalImageReference images) {
        if (images.tryGetTileLocation() == null) {
            int rows = images.getTileRowsNum();
            int cols = images.getTileColsNum();
            ImageChannelStack[][] map = new ImageChannelStack[rows][cols];
            Iterator<ImageChannelStack> iterator = stackReferences.iterator();
            while (iterator.hasNext()) {
                ImageChannelStack stackRef;
                map[stackRef.getTileRow() - 1][stackRef.getTileCol() - 1] = stackRef = iterator.next();
            }
            return map;
        }
        ImageChannelStack[][] map = new ImageChannelStack[1][1];
        if (!stackReferences.isEmpty()) {
            map[0][0] = stackReferences.get(0);
        }
        return map;
    }

    private static void addDummyImage(LayoutContainer container, int imageWidth, int imageHeight) {
        Label dummy = new Label();
        dummy.setWidth(imageWidth);
        dummy.setHeight(imageHeight);
        container.add((Widget)dummy);
    }

    public void addImagesDownloadListener(ImagesDownloadListener imagesDownloadListener) {
        this.imagesDownloadListeners.add(imagesDownloadListener);
    }

    public void setImageClickHandler(LogicalImageClickHandler imageClickHandler) {
        this.imageClickHandler = imageClickHandler;
    }

    public static interface ImagesDownloadListener {
        public void imagesDownloaded(LazyImageSeriesFrame var1);
    }
}

