/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetOverlayImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageDatasetLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogicalImageLoader {
    private final Session session;
    private final IScreeningBusinessObjectFactory businessObjectFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public static LogicalImageInfo loadLogicalImageInfo(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, String datasetCode, String datastoreCode, WellLocation wellLocationOrNull) {
        LogicalImageInfo logicalImageInfo = new LogicalImageLoader(session, businessObjectFactory, managedPropertyEvaluatorFactory).tryLoadLogicalImageInfo(datasetCode, datastoreCode, wellLocationOrNull);
        if (logicalImageInfo == null) {
            throw new IllegalStateException(String.format("Dataset '%s' is not an image dataset.", datasetCode));
        }
        return logicalImageInfo;
    }

    public static ImageDatasetEnrichedReference getImageDatasetReference(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, String datasetCode, String datastoreCode) {
        return new LogicalImageLoader(session, businessObjectFactory, managedPropertyEvaluatorFactory).getImageDatasetReference(datasetCode, datastoreCode);
    }

    public LogicalImageLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    private ImageDatasetEnrichedReference getImageDatasetReference(String datasetCode, String datastoreCode) {
        IImageDatasetLoader datasetLoader = this.businessObjectFactory.tryCreateImageDatasetLoader(datasetCode, datastoreCode);
        if (datasetLoader == null) {
            throw new IllegalStateException(String.format("Dataset '%s' not an image dataset.", datasetCode));
        }
        return this.getImageDataset(datasetCode, datasetLoader);
    }

    LogicalImageInfo tryLoadLogicalImageInfo(String datasetCode, String datastoreCode, WellLocation wellLocationOrNull) {
        IImageDatasetLoader datasetLoader = this.businessObjectFactory.tryCreateImageDatasetLoader(datasetCode, datastoreCode);
        if (datasetLoader == null) {
            return null;
        }
        List<ImageChannelStack> stacks = datasetLoader.listImageChannelStacks(wellLocationOrNull);
        ImageDatasetEnrichedReference imageDataset = this.getImageDataset(datasetCode, datasetLoader);
        return new LogicalImageInfo(imageDataset, stacks);
    }

    private ImageDatasetEnrichedReference getImageDataset(String datasetCode, IImageDatasetLoader datasetLoader) {
        ImageDatasetParameters imageParameters = datasetLoader.getImageParameters();
        DataPE dataset = this.loadDatasetWithChildren(datasetCode);
        DatasetImagesReference datasetImagesReference = this.createDatasetImagesReference(this.translate(dataset), imageParameters);
        List<DatasetOverlayImagesReference> overlayDatasets = this.extractImageOverlays(dataset);
        return new ImageDatasetEnrichedReference(datasetImagesReference, overlayDatasets);
    }

    List<ImageDatasetEnrichedReference> loadImageDatasets(List<DataPE> datasets) {
        ArrayList<ImageDatasetEnrichedReference> refs = new ArrayList<ImageDatasetEnrichedReference>();
        List<DataPE> imageDatasets = ScreeningUtils.filterImageDatasets(datasets);
        for (DataPE imageDataset : imageDatasets) {
            DatasetImagesReference ref = this.tryLoadImageDatasetReference(imageDataset);
            if (ref == null) continue;
            List<DatasetOverlayImagesReference> overlays = this.extractImageOverlays(imageDataset);
            ImageDatasetEnrichedReference enrichedRef = new ImageDatasetEnrichedReference(ref, overlays);
            refs.add(enrichedRef);
        }
        return refs;
    }

    private List<DatasetOverlayImagesReference> extractImageOverlays(DataPE imageDataset) {
        List<AbstractExternalData> overlayDatasets = this.fetchOverlayDatasets(imageDataset);
        ArrayList<DatasetOverlayImagesReference> overlays = new ArrayList<DatasetOverlayImagesReference>();
        for (AbstractExternalData overlay : overlayDatasets) {
            DatasetOverlayImagesReference ref = this.tryLoadOverlayDatasetReference(overlay);
            if (ref == null) continue;
            overlays.add(ref);
        }
        return overlays;
    }

    private List<AbstractExternalData> fetchOverlayDatasets(DataPE imageDataset) {
        List<DataPE> overlayPEs = ScreeningUtils.filterImageOverlayDatasets(imageDataset.getChildren());
        Collection<Long> datasetIds = LogicalImageLoader.extractIds(overlayPEs);
        return this.businessObjectFactory.createDatasetLister(this.session).listByDatasetIds(datasetIds);
    }

    private DatasetOverlayImagesReference tryLoadOverlayDatasetReference(AbstractExternalData overlay) {
        DatasetImagesReference imageDatasetReference = this.tryLoadImageDatasetReference(overlay);
        if (imageDatasetReference == null) {
            return null;
        }
        String analysisProcedure = this.tryGetAnalysisProcedure(overlay);
        return DatasetOverlayImagesReference.create(imageDatasetReference.getDatasetReference(), imageDatasetReference.getImageParameters(), analysisProcedure);
    }

    private String tryGetAnalysisProcedure(AbstractExternalData dataset) {
        return EntityHelper.tryFindPropertyValue(dataset, "$ANALYSIS_PROCEDURE");
    }

    private DatasetImagesReference tryLoadImageDatasetReference(AbstractExternalData dataset) {
        ImageDatasetParameters imageParameters = ScreeningUtils.tryLoadImageParameters(dataset, this.businessObjectFactory);
        if (imageParameters == null) {
            return null;
        }
        return this.createDatasetImagesReference(dataset, imageParameters);
    }

    private DatasetImagesReference createDatasetImagesReference(AbstractExternalData dataset, ImageDatasetParameters imageParameters) {
        return DatasetImagesReference.create(ScreeningUtils.createDatasetReference(dataset), imageParameters);
    }

    DatasetImagesReference tryLoadImageDatasetReference(DataPE imageDataset) {
        return this.tryLoadImageDatasetReference(this.translate(imageDataset));
    }

    private DataPE loadDatasetWithChildren(String datasetPermId) {
        IDataBO dataBO = this.businessObjectFactory.createDataBO(this.session);
        dataBO.loadByCode(datasetPermId);
        dataBO.enrichWithChildren();
        DataPE dataSet = dataBO.getData();
        return dataSet;
    }

    private static Collection<Long> extractIds(List<DataPE> datasets) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DataPE dataset : datasets) {
            ids.add(HibernateUtils.getId(dataset));
        }
        return ids;
    }

    private AbstractExternalData translate(DataPE dataSet) {
        return DataSetTranslator.translate(dataSet, this.session.getBaseIndexURL(), null, this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
    }
}

