/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResultSetWrapper<T, V>
extends ResultSetWrapper<T> {
    protected DataObjectBinding<V> binding;

    protected AbstractResultSetWrapper(DataObjectBinding<V> dataObjectBinding) {
        this.binding = dataObjectBinding;
    }

    protected DataObjectBinding<V> getDataObjectBinding() {
        return this.binding;
    }

    @Override
    public String[] getKeyColumnNames() {
        return this.binding.getKeyColumnNames();
    }

    static Class<?> getDataObjectClass(Type type, Set<Class> set) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && set.contains((parameterizedType = (ParameterizedType)type).getRawType())) {
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length == 1 && AbstractResultSetWrapper.isStringObjectMap(typeArray[0])) {
                return Map.class;
            }
            if (typeArray.length != 1 || !(typeArray[0] instanceof Class)) {
                throw new InvalidQueryException("Generic must have a single solid type-argument");
            }
            Class clazz = (Class)typeArray[0];
            DataObjectBinding.validate(clazz);
            return clazz;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.binding + "]";
    }
}

