/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ComputeCRC32Checksum
extends AbstractCommand {
    private static final String NAME = "crc32";
    private static ComputeCRC32Checksum instance;

    private ComputeCRC32Checksum() {
        super(NAME);
    }

    public static final synchronized ComputeCRC32Checksum getInstance() {
        if (instance == null) {
            instance = new ComputeCRC32Checksum();
        }
        return instance;
    }

    @Override
    public int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        MinimalParameters parameters = new MinimalParameters(arguments, NAME, "filename [...]");
        if (parameters.getArgs().isEmpty()) {
            parameters.printHelp(false);
            System.exit(1);
        }
        for (String filename : parameters.getArgs()) {
            try {
                int crc32 = (int)FileUtils.checksumCRC32((File)new File(filename));
                System.out.printf("%s\t%x\n", filename, crc32);
            }
            catch (IOException iOException) {
                System.err.println("Error reading file '" + filename + "'.");
                System.exit(2);
            }
        }
        return 0;
    }
}

