/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.io;

import ch.systemsx.cisd.cifex.rpc.io.CloneableCRC32;
import java.io.IOException;
import java.io.RandomAccessFile;

class CRC32Utils {
    private static final int CHUNK_SIZE = 16384;

    CRC32Utils() {
    }

    static CloneableCRC32 computeCRC32(RandomAccessFile raFile, long count) throws IOException {
        CloneableCRC32 partialCrc32 = new CloneableCRC32();
        byte[] chunk = new byte[16384];
        long bytesToRead = count - raFile.getFilePointer();
        while (bytesToRead > 0L) {
            int actualCount = raFile.read(chunk, 0, (int)Math.min(bytesToRead, (long)chunk.length));
            partialCrc32.update(chunk, 0, actualCount);
            bytesToRead -= (long)actualCount;
        }
        return partialCrc32;
    }
}

