/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.dbmigration.IDataSourceFactory;
import ch.systemsx.cisd.dbmigration.MonitoringDataSource;
import javax.sql.DataSource;

public class BasicDataSourceFactory
implements IDataSourceFactory {
    private static final int DEFAULT_MAX_ACTIVE = 20;
    private static final int DEFAULT_MAX_IDLE = 20;
    private static final int DEFAULT_MAX_WAIT = 60000;
    private static final int DEFAULT_ACTIVE_CONNECTIONS_LOG_INTERVAL = 3600000;
    private static final int DEFAULT_ACTIVE_NUM_CONNECTIONS_LOG_THRESHOLD = 16;
    private long maxWaitMillis = 60000L;
    private int maxIdle = 20;
    private int maxActive = 20;
    private long activeConnectionsLogIntervalMillis = 3600000L;
    private int activeNumConnectionsLogThreshold = 16;
    private boolean activeNumConnectionLogThresholdIsDefault = true;
    private boolean maxIdleIsDefault = true;
    private boolean logStackTraceOnConnectionLogging = false;

    @Override
    public final DataSource createDataSource(String driver, String url, String owner, String password, String validationQuery) {
        MonitoringDataSource dataSource = new MonitoringDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(owner);
        dataSource.setPassword(password);
        dataSource.setMaxIdle(this.maxIdle);
        dataSource.setMaxActive(this.maxActive);
        dataSource.setMaxWait(this.maxWaitMillis * 1000L);
        dataSource.setActiveConnectionsLogInterval(this.activeConnectionsLogIntervalMillis);
        dataSource.setActiveConnectionsLogThreshold(this.activeNumConnectionsLogThreshold);
        dataSource.setLogStackTrace(this.logStackTraceOnConnectionLogging);
        dataSource.setValidationQuery(validationQuery);
        return dataSource;
    }

    @Override
    public long getMaxWait() {
        return this.maxWaitMillis;
    }

    @Override
    public void setMaxWait(long maxWait) {
        this.maxWaitMillis = maxWait;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        this.maxIdleIsDefault = false;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        if (this.activeNumConnectionLogThresholdIsDefault) {
            this.activeNumConnectionsLogThreshold = (int)(0.8 * (double)maxActive);
        }
        if (this.maxIdleIsDefault) {
            this.maxIdle = maxActive;
        }
    }

    @Override
    public long getActiveConnectionsLogInterval() {
        return this.activeConnectionsLogIntervalMillis;
    }

    @Override
    public void setActiveConnectionsLogInterval(long activeConnectionLogInterval) {
        this.activeConnectionsLogIntervalMillis = activeConnectionLogInterval;
    }

    @Override
    public int getActiveNumConnectionsLogThreshold() {
        return this.activeNumConnectionsLogThreshold;
    }

    @Override
    public void setActiveNumConnectionsLogThreshold(int activeConnectionsLogThreshold) {
        this.activeNumConnectionsLogThreshold = activeConnectionsLogThreshold;
        this.activeNumConnectionLogThresholdIsDefault = false;
    }

    @Override
    public boolean isLogStackTraceOnConnectionLogging() {
        return this.logStackTraceOnConnectionLogging;
    }

    @Override
    public void setLogStackTraceOnConnectionLogging(boolean logStackTrace) {
        this.logStackTraceOnConnectionLogging = logStackTrace;
    }
}

