/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.h2;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.MassUploadFileType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class H2MassUploader
extends SimpleJdbcDaoSupport
implements IMassUploader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, H2MassUploader.class);
    private final ISequenceNameMapper sequenceNameMapper;

    public H2MassUploader(DataSource dataSource, ISequenceNameMapper sequenceNameMapper) throws SQLException {
        this.sequenceNameMapper = sequenceNameMapper;
        this.setDataSource(dataSource);
    }

    @Override
    public void performMassUpload(String tableName, String data) {
        try {
            DatabaseMetaData dbMetaData = this.getConnection().getMetaData();
            try {
                BitSet isBinaryColumn = this.findBinaryColumns(dbMetaData, tableName);
                MassUploadRecord massUploadRecord = new MassUploadRecord(data, tableName, isBinaryColumn);
                this.performMassUpload(massUploadRecord);
            }
            finally {
                dbMetaData.getConnection().close();
            }
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void performMassUpload(String tableName, String[] columnNames, String data) {
        try {
            DatabaseMetaData dbMetaData = this.getConnection().getMetaData();
            try {
                BitSet isBinaryColumn = this.findBinaryColumns(dbMetaData, tableName, columnNames);
                MassUploadRecord massUploadRecord = new MassUploadRecord(data, tableName, isBinaryColumn);
                this.performMassUpload(massUploadRecord);
            }
            finally {
                dbMetaData.getConnection().close();
            }
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public final void performMassUpload(File[] massUploadFiles) {
        String task = "Get database metadata";
        try {
            ArrayList<MassUploadRecord> massUploadRecords = new ArrayList<MassUploadRecord>(massUploadFiles.length);
            DatabaseMetaData dbMetaData = this.getConnection().getMetaData();
            try {
                File[] fileArray = massUploadFiles;
                int n = massUploadFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File massUploadFile = fileArray[n2];
                    String[] splitName = StringUtils.split((String)massUploadFile.getName(), (String)"=");
                    assert (splitName.length == 2) : "Missing '=' in name of file '" + massUploadFile.getName() + "'.";
                    String tableNameWithExtension = splitName[1];
                    boolean tsvFileType = MassUploadFileType.TSV.isOfType(tableNameWithExtension);
                    assert (tsvFileType) : "Not a " + MassUploadFileType.TSV.getFileType() + " file: " + massUploadFile.getName();
                    String tableName = tableNameWithExtension.substring(0, tableNameWithExtension.lastIndexOf(46));
                    BitSet isBinaryColumn = this.findBinaryColumns(dbMetaData, tableName);
                    massUploadRecords.add(new MassUploadRecord(massUploadFile, tableName, isBinaryColumn));
                    ++n2;
                }
            }
            finally {
                task = "Close connection";
                dbMetaData.getConnection().close();
            }
            for (MassUploadRecord record : massUploadRecords) {
                this.performMassUpload(record);
            }
            for (MassUploadRecord record : massUploadRecords) {
                this.fixSequence(record.tableName);
            }
        }
        catch (SQLException ex) {
            throw new UncategorizedSQLException(task, "UNKNOWN", ex);
        }
    }

    private final void performMassUpload(final MassUploadRecord record) {
        try {
            int i;
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Perform mass upload of file '" + record.massUploadFile + "' to table '" + record.tableName + "'."));
            }
            final List<String[]> rows = record.data == null ? this.readTSVFile(record.massUploadFile) : this.readTSVFile(record.data);
            final int numberOfRows = rows.size();
            final int numberOfColumns = record.columnNamesOrNull != null ? record.columnNamesOrNull.length : (numberOfRows > 0 ? rows.get(0).length : 0);
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into ");
            insertSql.append(record.tableName);
            if (record.columnNamesOrNull != null) {
                insertSql.append(" (");
                i = 0;
                while (i < record.columnNamesOrNull.length) {
                    insertSql.append(record.columnNamesOrNull[i]);
                    if (i < record.columnNamesOrNull.length - 1) {
                        insertSql.append(',');
                    }
                    ++i;
                }
                insertSql.append(')');
            }
            insertSql.append(" values (");
            i = 0;
            while (i < numberOfColumns) {
                insertSql.append("?,");
                ++i;
            }
            insertSql.setLength(insertSql.length() - 1);
            insertSql.append(')');
            this.getJdbcTemplate().batchUpdate(insertSql.toString(), new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return numberOfRows;
                }

                public void setValues(PreparedStatement ps, int rowNo) throws SQLException {
                    int colNo = 0;
                    while (colNo < numberOfColumns) {
                        ps.setObject(colNo + 1, this.tryGetValue(rowNo, colNo));
                        ++colNo;
                    }
                }

                private Object tryGetValue(int rowNo, int colNo) {
                    String stringValueOrNull = ((String[])rows.get(rowNo))[colNo];
                    if (stringValueOrNull == null) {
                        return null;
                    }
                    if (record.isBinaryColumn.get(colNo)) {
                        return stringValueOrNull.getBytes();
                    }
                    return stringValueOrNull;
                }
            });
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private final BitSet findBinaryColumns(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        BitSet binary = new BitSet();
        ResultSet rs = dbMetaData.getColumns(null, null, tableName.toUpperCase(), "%");
        int columnNo = 0;
        while (rs.next()) {
            int typeCode = rs.getInt(5);
            binary.set(columnNo, typeCode == -2 || typeCode == -3);
            ++columnNo;
        }
        rs.close();
        return binary;
    }

    private final BitSet findBinaryColumns(DatabaseMetaData dbMetaData, String tableName, String[] columnNames) throws SQLException {
        ResultSet rs = dbMetaData.getColumns(null, null, tableName.toUpperCase(), "%");
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
        while (rs.next()) {
            String colName = rs.getString(4);
            int typeCode = rs.getInt(5);
            typeMap.put(colName, typeCode);
        }
        rs.close();
        BitSet binary = new BitSet();
        int i = 0;
        while (i < columnNames.length) {
            Integer typeCode = (Integer)typeMap.get(columnNames[i]);
            if (typeCode != null) {
                binary.set(i, typeCode == -2 || typeCode == -3);
            }
            ++i;
        }
        return binary;
    }

    private final List<String[]> readTSVFile(String data) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(data));
        return this.readTSVFile(reader);
    }

    private final List<String[]> readTSVFile(File tsvFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.openInputStream((File)tsvFile)));
        return this.readTSVFile(reader);
    }

    private final List<String[]> readTSVFile(BufferedReader reader) throws IOException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            String line = reader.readLine();
            int numberOfColumns = -1;
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] cols = StringUtils.splitPreserveAllTokens((String)line, (char)'\t');
                    if (numberOfColumns < 0) {
                        numberOfColumns = cols.length;
                    }
                    if (numberOfColumns != cols.length) {
                        throw new IllegalArgumentException("line '" + line + "', cols found: " + cols.length + ", cols expected: " + numberOfColumns);
                    }
                    int i = 0;
                    while (i < cols.length) {
                        cols[i] = StringUtils.replace((String)cols[i], (String)"\\\\011", (String)"\t");
                        cols[i] = StringUtils.replace((String)cols[i], (String)"\\\\012", (String)"\n");
                        if ("\\N".equals(cols[i])) {
                            cols[i] = null;
                        }
                        ++i;
                    }
                    result.add(cols);
                }
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return result;
    }

    private final void fixSequence(String tableName) {
        String sequenceName = this.sequenceNameMapper.getSequencerForTable(tableName);
        if (sequenceName == null) {
            return;
        }
        try {
            long maxId = this.getSimpleJdbcTemplate().queryForLong(String.format("select max(id) from %s", tableName), new Object[0]);
            long newSequenceValue = maxId + 1L;
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Updating sequence " + sequenceName + " for table " + tableName + " to value " + newSequenceValue));
            }
            this.getJdbcTemplate().execute(String.format("alter sequence %s restart with %d", sequenceName, newSequenceValue));
        }
        catch (DataAccessException ex) {
            operationLog.error((Object)("Failed to set new value for sequence '" + sequenceName + "' of table '" + tableName + "'."), (Throwable)ex);
        }
    }

    private static final class MassUploadRecord {
        final File massUploadFile;
        final String data;
        final String[] columnNamesOrNull;
        final String tableName;
        final BitSet isBinaryColumn;

        MassUploadRecord(File massUploadFile, String tableName, BitSet isBinaryColumn) {
            this.massUploadFile = massUploadFile;
            this.data = null;
            this.columnNamesOrNull = null;
            this.tableName = tableName;
            this.isBinaryColumn = isBinaryColumn;
        }

        MassUploadRecord(String data, String tableName, BitSet isBinaryColumn) {
            this(data, tableName, null, isBinaryColumn);
        }

        MassUploadRecord(String data, String tableName, String[] columnNamesOrNull, BitSet isBinaryColumn) {
            this.massUploadFile = null;
            this.data = data;
            this.columnNamesOrNull = columnNamesOrNull;
            this.tableName = tableName;
            this.isBinaryColumn = isBinaryColumn;
        }
    }
}

