/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import loci.formats.FormatTools;
import loci.formats.cache.CacheEvent;
import loci.formats.cache.CacheException;
import loci.formats.cache.CacheListener;
import loci.formats.cache.CacheReporter;
import loci.formats.cache.ICacheStrategy;

public abstract class CacheStrategy
implements CacheReporter,
Comparator,
ICacheStrategy {
    public static final int DEFAULT_RANGE = 0;
    protected int[] lengths;
    protected int[] order;
    protected int[] range;
    protected int[] priorities;
    private int[][] positions;
    private boolean dirty;
    protected Vector listeners;

    public CacheStrategy(int[] lengths) {
        this.lengths = lengths;
        this.order = new int[lengths.length];
        Arrays.fill(this.order, 0);
        this.range = new int[lengths.length];
        Arrays.fill(this.range, 0);
        this.priorities = new int[lengths.length];
        Arrays.fill(this.priorities, 0);
        this.positions = this.getPossiblePositions();
        this.dirty = true;
        this.listeners = new Vector();
    }

    protected abstract int[][] getPossiblePositions();

    public int distance(int axis, int value) {
        switch (this.order[axis]) {
            case 0: {
                if (value == 0) {
                    return 0;
                }
                int vb = this.lengths[axis] - value;
                return value <= vb ? value : vb;
            }
            case 1: {
                return value;
            }
            case -1: {
                if (value == 0) {
                    return 0;
                }
                return this.lengths[axis] - value;
            }
        }
        throw new IllegalStateException("unknown order: " + this.order[axis]);
    }

    protected int raster(int[] pos) {
        return FormatTools.positionToRaster(this.lengths, pos);
    }

    protected int[] pos(int raster) {
        return FormatTools.rasterToPosition(this.lengths, raster);
    }

    protected int[] pos(int raster, int[] pos) {
        return FormatTools.rasterToPosition(this.lengths, raster, pos);
    }

    protected int length() {
        return FormatTools.getRasterLength(this.lengths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(CacheListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheListener[] getCacheListeners() {
        Object[] l;
        Vector vector = this.listeners;
        synchronized (vector) {
            l = new CacheListener[this.listeners.size()];
            this.listeners.copyInto(l);
        }
        return l;
    }

    public int compare(Object o1, Object o2) {
        int diff;
        int i;
        int p;
        int[] p1 = (int[])o1;
        int[] p2 = (int[])o2;
        for (p = 10; p >= -10; --p) {
            int dist1 = 0;
            int dist2 = 0;
            for (i = 0; i < p1.length; ++i) {
                if (this.priorities[i] != p) continue;
                dist1 += this.distance(i, p1[i]);
                dist2 += this.distance(i, p2[i]);
            }
            diff = dist1 - dist2;
            if (diff == 0) continue;
            return diff;
        }
        for (p = 10; p >= -10; --p) {
            int div1 = 0;
            int div2 = 0;
            for (i = 0; i < p1.length; ++i) {
                if (this.priorities[i] != p) continue;
                if (p1[i] != 0) {
                    ++div1;
                }
                if (p2[i] == 0) continue;
                ++div2;
            }
            diff = div1 - div2;
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getLoadList(int[] pos) throws CacheException {
        int[][] loadList = null;
        int[][] nArray = this.positions;
        synchronized (this.positions) {
            int j;
            boolean ok;
            int[] ipos;
            int i;
            if (this.dirty) {
                Arrays.sort(this.positions, this);
                this.dirty = false;
            }
            int c = 0;
            for (i = 0; i < this.positions.length; ++i) {
                ipos = this.positions[i];
                ok = true;
                for (j = 0; j < ipos.length; ++j) {
                    if (this.distance(j, ipos[j]) <= this.range[j]) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                ++c;
            }
            loadList = new int[c][this.lengths.length];
            c = 0;
            for (i = 0; i < this.positions.length; ++i) {
                ipos = this.positions[i];
                ok = true;
                for (j = 0; j < ipos.length && c < loadList.length; ++j) {
                    int value;
                    if (this.distance(j, ipos[j]) > this.range[j]) {
                        ok = false;
                        break;
                    }
                    loadList[c][j] = value = (pos[j] + ipos[j]) % this.lengths[j];
                }
                if (!ok) continue;
                ++c;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loadList;
        }
    }

    public int[] getPriorities() {
        return this.priorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority, int axis) {
        if (priority < -10 || priority > 10) {
            throw new IllegalArgumentException("Invalid priority for axis #" + axis + ": " + priority);
        }
        int[][] nArray = this.positions;
        synchronized (this.positions) {
            this.priorities[axis] = priority;
            this.dirty = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.notifyListeners(new CacheEvent(this, 4));
            return;
        }
    }

    public int[] getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrder(int order, int axis) {
        if (order != 0 && order != 1 && order != -1) {
            throw new IllegalArgumentException("Invalid order for axis #" + axis + ": " + order);
        }
        int[][] nArray = this.positions;
        synchronized (this.positions) {
            this.order[axis] = order;
            this.dirty = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.notifyListeners(new CacheEvent(this, 5));
            return;
        }
    }

    public int[] getRange() {
        return this.range;
    }

    public void setRange(int num, int axis) {
        if (num < 0) {
            throw new IllegalArgumentException("Invalid range for axis #" + axis + ": " + num);
        }
        this.range[axis] = num;
        this.notifyListeners(new CacheEvent(this, 6));
    }

    public int[] getLengths() {
        return this.lengths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(CacheEvent e) {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CacheListener l = (CacheListener)this.listeners.elementAt(i);
                l.cacheUpdated(e);
            }
        }
    }
}

