/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.AffineTransform;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Union;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.LineCap;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Shape
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Shape.class);
    private String strokeDashArray;
    private Double strokeWidth;
    private Boolean locked;
    private FillRule fillRule;
    private Boolean visible;
    private LineCap lineCap;
    private NonNegativeInteger theC;
    private FontFamily fontFamily;
    private FontStyle fontStyle;
    private NonNegativeInteger fontSize;
    private Color fillColor;
    private String text;
    private Color strokeColor;
    private NonNegativeInteger theT;
    private String id;
    private NonNegativeInteger theZ;
    private AffineTransform transform;
    private Union union;

    public Shape() {
    }

    public Shape(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Transform_nodeList;
        List<Element> Label_nodeList;
        List<Element> Polygon_nodeList;
        List<Element> Polyline_nodeList;
        List<Element> Point_nodeList;
        List<Element> Ellipse_nodeList;
        List<Element> Mask_nodeList;
        List<Element> Rectangle_nodeList;
        List<Element> Line_nodeList;
        super.update(element, model);
        if (element.hasAttribute("StrokeDashArray")) {
            this.setStrokeDashArray(String.valueOf(element.getAttribute("StrokeDashArray")));
        }
        if (element.hasAttribute("StrokeWidth")) {
            this.setStrokeWidth(Double.valueOf(element.getAttribute("StrokeWidth")));
        }
        if (element.hasAttribute("Locked")) {
            this.setLocked(Boolean.valueOf(element.getAttribute("Locked")));
        }
        if (element.hasAttribute("FillRule")) {
            this.setFillRule(FillRule.fromString(element.getAttribute("FillRule")));
        }
        if (element.hasAttribute("Visible")) {
            this.setVisible(Boolean.valueOf(element.getAttribute("Visible")));
        }
        if (element.hasAttribute("LineCap")) {
            this.setLineCap(LineCap.fromString(element.getAttribute("LineCap")));
        }
        if (element.hasAttribute("TheC")) {
            this.setTheC(NonNegativeInteger.valueOf(element.getAttribute("TheC")));
        }
        if (element.hasAttribute("FontFamily")) {
            this.setFontFamily(FontFamily.fromString(element.getAttribute("FontFamily")));
        }
        if (element.hasAttribute("FontStyle")) {
            this.setFontStyle(FontStyle.fromString(element.getAttribute("FontStyle")));
        }
        if (element.hasAttribute("FontSize")) {
            this.setFontSize(NonNegativeInteger.valueOf(element.getAttribute("FontSize")));
        }
        if (element.hasAttribute("FillColor")) {
            this.setFillColor(Color.valueOf(element.getAttribute("FillColor")));
        }
        if (element.hasAttribute("Text")) {
            this.setText(String.valueOf(element.getAttribute("Text")));
        }
        if (element.hasAttribute("StrokeColor")) {
            this.setStrokeColor(Color.valueOf(element.getAttribute("StrokeColor")));
        }
        if (element.hasAttribute("TheT")) {
            this.setTheT(NonNegativeInteger.valueOf(element.getAttribute("TheT")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Shape missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("TheZ")) {
            this.setTheZ(NonNegativeInteger.valueOf(element.getAttribute("TheZ")));
        }
        if ((Line_nodeList = Shape.getChildrenByTagName(element, "Line")).size() > 1) {
            throw new RuntimeException(String.format("Line node list size %d != 1", Line_nodeList.size()));
        }
        if (Line_nodeList.size() != 0) {
            // empty if block
        }
        if ((Rectangle_nodeList = Shape.getChildrenByTagName(element, "Rectangle")).size() > 1) {
            throw new RuntimeException(String.format("Rectangle node list size %d != 1", Rectangle_nodeList.size()));
        }
        if (Rectangle_nodeList.size() != 0) {
            // empty if block
        }
        if ((Mask_nodeList = Shape.getChildrenByTagName(element, "Mask")).size() > 1) {
            throw new RuntimeException(String.format("Mask node list size %d != 1", Mask_nodeList.size()));
        }
        if (Mask_nodeList.size() != 0) {
            // empty if block
        }
        if ((Ellipse_nodeList = Shape.getChildrenByTagName(element, "Ellipse")).size() > 1) {
            throw new RuntimeException(String.format("Ellipse node list size %d != 1", Ellipse_nodeList.size()));
        }
        if (Ellipse_nodeList.size() != 0) {
            // empty if block
        }
        if ((Point_nodeList = Shape.getChildrenByTagName(element, "Point")).size() > 1) {
            throw new RuntimeException(String.format("Point node list size %d != 1", Point_nodeList.size()));
        }
        if (Point_nodeList.size() != 0) {
            // empty if block
        }
        if ((Polyline_nodeList = Shape.getChildrenByTagName(element, "Polyline")).size() > 1) {
            throw new RuntimeException(String.format("Polyline node list size %d != 1", Polyline_nodeList.size()));
        }
        if (Polyline_nodeList.size() != 0) {
            // empty if block
        }
        if ((Polygon_nodeList = Shape.getChildrenByTagName(element, "Polygon")).size() > 1) {
            throw new RuntimeException(String.format("Polygon node list size %d != 1", Polygon_nodeList.size()));
        }
        if (Polygon_nodeList.size() != 0) {
            // empty if block
        }
        if ((Label_nodeList = Shape.getChildrenByTagName(element, "Label")).size() > 1) {
            throw new RuntimeException(String.format("Label node list size %d != 1", Label_nodeList.size()));
        }
        if (Label_nodeList.size() != 0) {
            // empty if block
        }
        if ((Transform_nodeList = Shape.getChildrenByTagName(element, "Transform")).size() > 1) {
            throw new RuntimeException(String.format("Transform node list size %d != 1", Transform_nodeList.size()));
        }
        if (Transform_nodeList.size() != 0) {
            // empty if block
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(String strokeDashArray) {
        this.strokeDashArray = strokeDashArray;
    }

    public Double getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(Double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public FillRule getFillRule() {
        return this.fillRule;
    }

    public void setFillRule(FillRule fillRule) {
        this.fillRule = fillRule;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(LineCap lineCap) {
        this.lineCap = lineCap;
    }

    public NonNegativeInteger getTheC() {
        return this.theC;
    }

    public void setTheC(NonNegativeInteger theC) {
        this.theC = theC;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(FontFamily fontFamily) {
        this.fontFamily = fontFamily;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public NonNegativeInteger getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(NonNegativeInteger fontSize) {
        this.fontSize = fontSize;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public NonNegativeInteger getTheT() {
        return this.theT;
    }

    public void setTheT(NonNegativeInteger theT) {
        this.theT = theT;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public NonNegativeInteger getTheZ() {
        return this.theZ;
    }

    public void setTheZ(NonNegativeInteger theZ) {
        this.theZ = theZ;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public Union getUnion() {
        return this.union;
    }

    public void setUnion(Union union_BackReference) {
        this.union = union_BackReference;
    }

    protected Element asXMLElement(Document document, Element Shape_element) {
        if (!"Shape".equals(Shape_element.getTagName())) {
            Element abstractElement = document.createElementNS(NAMESPACE, "Shape");
            abstractElement.appendChild(Shape_element);
            Shape_element = abstractElement;
        }
        if (Shape_element == null) {
            Shape_element = document.createElementNS(NAMESPACE, "Shape");
        }
        if (this.strokeDashArray != null) {
            Shape_element.setAttribute("StrokeDashArray", this.strokeDashArray.toString());
        }
        if (this.strokeWidth != null) {
            Shape_element.setAttribute("StrokeWidth", this.strokeWidth.toString());
        }
        if (this.locked != null) {
            Shape_element.setAttribute("Locked", this.locked.toString());
        }
        if (this.fillRule != null) {
            Shape_element.setAttribute("FillRule", this.fillRule.toString());
        }
        if (this.visible != null) {
            Shape_element.setAttribute("Visible", this.visible.toString());
        }
        if (this.lineCap != null) {
            Shape_element.setAttribute("LineCap", this.lineCap.toString());
        }
        if (this.theC != null) {
            Shape_element.setAttribute("TheC", this.theC.toString());
        }
        if (this.fontFamily != null) {
            Shape_element.setAttribute("FontFamily", this.fontFamily.toString());
        }
        if (this.fontStyle != null) {
            Shape_element.setAttribute("FontStyle", this.fontStyle.toString());
        }
        if (this.fontSize != null) {
            Shape_element.setAttribute("FontSize", this.fontSize.toString());
        }
        if (this.fillColor != null) {
            Shape_element.setAttribute("FillColor", this.fillColor.toString());
        }
        if (this.text != null) {
            Shape_element.setAttribute("Text", this.text.toString());
        }
        if (this.strokeColor != null) {
            Shape_element.setAttribute("StrokeColor", this.strokeColor.toString());
        }
        if (this.theT != null) {
            Shape_element.setAttribute("TheT", this.theT.toString());
        }
        if (this.id != null) {
            Shape_element.setAttribute("ID", this.id.toString());
        }
        if (this.theZ != null) {
            Shape_element.setAttribute("TheZ", this.theZ.toString());
        }
        return super.asXMLElement(document, Shape_element);
    }
}

