/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.file.FileBasedLineStore;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.LineBasedUserStore;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.File;
import java.util.List;

public class FileAuthenticationService
implements IAuthenticationService {
    private static final String DUMMY_TOKEN_STR = "DUMMY-TOKEN";
    private final IUserStore userStore;

    private static IUserStore createUserStore(String passwordFileName) {
        FileBasedLineStore lineStore = new FileBasedLineStore(new File(passwordFileName), "Password file");
        return new LineBasedUserStore(lineStore);
    }

    public FileAuthenticationService(String passwordFileName) {
        this(FileAuthenticationService.createUserStore(passwordFileName));
    }

    public FileAuthenticationService(IUserStore userStore) {
        this.userStore = userStore;
    }

    @Override
    public String authenticateApplication() {
        return DUMMY_TOKEN_STR;
    }

    @Override
    public boolean authenticateUser(String dummyToken, String user, String password) {
        return this.userStore.isPasswordCorrect(user, password);
    }

    @Override
    public boolean authenticateUser(String user, String password) {
        return this.userStore.isPasswordCorrect(user, password);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String dummyToken, String user, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(user, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String user, String passwordOrNull) {
        UserEntry userOrNull = this.userStore.tryGetUser(user);
        if (userOrNull != null) {
            Principal principal = userOrNull.asPrincipal();
            if (passwordOrNull != null) {
                principal.setAuthenticated(this.authenticateUser(user, passwordOrNull));
            }
            return principal;
        }
        return null;
    }

    @Override
    public Principal getPrincipal(String applicationToken, String user) {
        return this.getPrincipal(user);
    }

    @Override
    public Principal getPrincipal(String user) {
        Principal principalOrNull = this.tryGetAndAuthenticateUser(user, null);
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + user + "'.");
        }
        return principalOrNull;
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String applicationToken, String email, String passwordOrNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String applicationToken, String emailQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String applicationToken, String lastNameQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String dummyToken, String userIdQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsListingByEmail() {
        return false;
    }

    @Override
    public boolean supportsListingByLastName() {
        return false;
    }

    @Override
    public boolean supportsListingByUserId() {
        return false;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        this.userStore.check();
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

