/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PlaceholderDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataSetUpdatable
extends DataSetImmutable
implements IDataSetUpdatable {
    private final DataSetBatchUpdatesDTO updates;
    private final DataSetBatchUpdateDetails updateDetails;

    public DataSetUpdatable(AbstractExternalData dataSet, IEncapsulatedBasicOpenBISService service) {
        super(dataSet, service);
        if (dataSet.getProperties() == null) {
            dataSet.setDataSetProperties(new ArrayList<IEntityProperty>());
        }
        this.updates = new DataSetBatchUpdatesDTO();
        this.updateDetails = new DataSetBatchUpdateDetails();
        this.initializeUpdates();
    }

    public DataSetUpdatable(DataSetImmutable dataSet) {
        this(dataSet.dataSet, dataSet.service);
    }

    private void initializeUpdates() {
        this.updates.setDatasetCode(this.dataSet.getCode());
        this.updates.setDatasetId(TechId.create(this.dataSet));
        this.updates.setDetails(this.updateDetails);
        this.updates.setVersion(this.dataSet.getVersion());
        List<IEntityProperty> emptyProps = Collections.emptyList();
        this.updates.setProperties(emptyProps);
        this.updateDetails.setPropertiesToUpdate(new HashSet<String>());
    }

    @Override
    public void setExperiment(IExperimentImmutable experiment) {
        this.updateDetails.setExperimentUpdateRequested(true);
        if (experiment == null) {
            this.dataSet.setExperiment(null);
            this.updates.setExperimentIdentifierOrNull(null);
        } else {
            ExperimentImmutable exp = (ExperimentImmutable)experiment;
            this.dataSet.setExperiment(exp.getExperiment());
            String identifierString = this.dataSet.getExperiment().getIdentifier();
            ExperimentIdentifier experimentIdentifier = ExperimentIdentifierFactory.parse(identifierString);
            this.updates.setExperimentIdentifierOrNull(experimentIdentifier);
        }
    }

    @Override
    public void setSample(ISampleImmutable sampleOrNull) {
        this.updateDetails.setSampleUpdateRequested(true);
        if (sampleOrNull == null) {
            this.dataSet.setSample(null);
            this.updates.setSampleIdentifierOrNull(null);
        } else {
            SampleImmutable samp = (SampleImmutable)sampleOrNull;
            this.dataSet.setSample(samp.getSample());
            this.setExperiment(sampleOrNull.getExperiment());
            String identifierString = this.dataSet.getSampleIdentifier();
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(identifierString);
            this.updates.setSampleIdentifierOrNull(sampleIdentifier);
        }
    }

    @Override
    public void setFileFormatType(String fileFormatTypeCode) {
        if (!this.isContainerDataSet()) {
            FileFormatType fileFormatType = new FileFormatType();
            fileFormatType.setCode(fileFormatTypeCode);
            this.dataSet.tryGetAsDataSet().setFileFormatType(fileFormatType);
            this.updateDetails.setFileFormatUpdateRequested(true);
            this.updates.setFileFormatTypeCode(fileFormatTypeCode);
        }
    }

    @Override
    public void setPropertyValue(String propertyCode, String propertyValue) {
        EntityHelper.createOrUpdateProperty(this.dataSet, propertyCode, propertyValue);
        this.updates.setProperties(this.dataSet.getProperties());
        Set<String> propertiesToUpdate = this.updateDetails.getPropertiesToUpdate();
        propertiesToUpdate.add(propertyCode);
        this.updateDetails.setPropertiesToUpdate(propertiesToUpdate);
    }

    @Override
    public void setParentDatasets(List<String> parentDataSetCodes) {
        List<AbstractExternalData> dummyParents = this.createDummyDataSetsFromCodes(parentDataSetCodes);
        this.dataSet.setParents(dummyParents);
        this.updateDetails.setParentsUpdateRequested(true);
        this.updates.setModifiedParentDatasetCodesOrNull(parentDataSetCodes.toArray(new String[0]));
    }

    @Override
    public void setContainedDataSetCodes(List<String> containedDataSetCodes) {
        if (this.isContainerDataSet()) {
            List<AbstractExternalData> dummyDataSets = this.createDummyDataSetsFromCodes(containedDataSetCodes);
            this.dataSet.tryGetAsContainerDataSet().setContainedDataSets(dummyDataSets);
            this.updateDetails.setContainerUpdateRequested(true);
            this.updates.setModifiedContainedDatasetCodesOrNull(containedDataSetCodes.toArray(new String[0]));
        }
    }

    private List<AbstractExternalData> createDummyDataSetsFromCodes(List<String> containedDataSetCodes) {
        ArrayList<AbstractExternalData> dummies = new ArrayList<AbstractExternalData>();
        if (containedDataSetCodes != null) {
            for (String code : containedDataSetCodes) {
                PlaceholderDataSet dummy = new PlaceholderDataSet();
                dummy.setCode(code);
                dummies.add(dummy);
            }
        }
        return dummies;
    }

    public AbstractExternalData getExternalData() {
        return this.dataSet;
    }

    public DataSetBatchUpdatesDTO getUpdates() {
        return this.updates;
    }

    @Override
    public void setExternalDataManagementSystem(IExternalDataManagementSystemImmutable externalDataManagementSystem) {
        if (this.isLinkDataSet()) {
            ExternalDataManagementSystem dummy = new ExternalDataManagementSystem();
            dummy.setCode(externalDataManagementSystem.getCode());
            this.dataSet.tryGetAsLinkDataSet().setExternalDataManagementSystem(dummy);
        }
    }

    @Override
    public void setExternalCode(String externalCode) {
        if (this.isLinkDataSet()) {
            this.dataSet.tryGetAsLinkDataSet().setExternalCode(externalCode);
        }
    }
}

