/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.validation.AbstractValidator;
import ch.systemsx.cisd.etlserver.validation.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class UniqueGroupValidator
extends AbstractValidator {
    static final int MIN_GROUP = 1;
    private final Pattern pattern;
    private final List<Integer> groups;
    private final UniquenessChecker checker;

    UniqueGroupValidator(String regularExpression, List<Integer> groups) {
        super(false, Collections.<String>emptySet());
        this.groups = groups;
        this.checker = new UniquenessChecker(groups.size());
        this.pattern = Pattern.compile(regularExpression);
    }

    @Override
    protected void assertValidNonEmptyValue(String value) {
        Matcher m = this.pattern.matcher(value);
        ArrayList<String> list = new ArrayList<String>();
        if (m.find()) {
            for (int g : this.groups) {
                if (g <= m.groupCount() || g > 1) {
                    list.add(m.group(g));
                    continue;
                }
                String message = String.format("Group '%s' not found. Value: '%s', pattern: '%s'", g, value, this.pattern.pattern());
                throw new UserFailureException(message);
            }
            Result result = this.checker.check(list, value);
            if (!result.isValid()) {
                throw new UserFailureException(result.toString());
            }
        } else {
            throw new UserFailureException(String.format("Value '%s' does not match the pattern '%s'", value, this.pattern.pattern()));
        }
    }

    private static class UniquenessChecker {
        Set<List<String>> values;
        private final int expectedSize;

        public UniquenessChecker(int expectedSize) {
            this.expectedSize = expectedSize;
            this.values = new HashSet<List<String>>();
        }

        public Result check(List<String> list, String oryginalValue) {
            if (list.size() != this.expectedSize) {
                String message = String.format("Wrong number of elements (%s instead of %s)", list.size(), this.expectedSize);
                return Result.failure(message);
            }
            if (this.values.contains(list)) {
                String message = String.format("Record '%s' breaks group uniqueness (repeated group: '%s')", oryginalValue, list);
                return Result.failure(message);
            }
            this.values.add(list);
            return Result.OK;
        }
    }
}

