/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeMetaprojectItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.widget.MetaprojectTreeItemWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;

public class MetaprojectTreeMetaprojectItemWidget
extends MetaprojectTreeItemWidget {
    private MetaprojectTreeMetaprojectItemData data;
    private Anchor link;

    public MetaprojectTreeMetaprojectItemWidget(IViewContext<?> viewContext, MetaprojectTreeMetaprojectItemData data) {
        super(viewContext);
        this.data = data;
        FlowPanel panel = new FlowPanel();
        panel.add(this.getLabel());
        panel.add(this.getLink());
        FocusPanel focusPanel = new FocusPanel();
        focusPanel.add((Widget)panel);
        focusPanel.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                MetaprojectTreeMetaprojectItemWidget.this.getLink().setVisible(true);
            }
        });
        focusPanel.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                MetaprojectTreeMetaprojectItemWidget.this.getLink().setVisible(MetaprojectTreeMetaprojectItemWidget.this.isSelected());
            }
        });
        focusPanel.setTitle(this.getTooltip());
        this.initWidget((Widget)focusPanel);
    }

    private Widget getLabel() {
        return new InlineLabel(String.valueOf(this.data.getMetaproject().getName()) + " ");
    }

    private Widget getLink() {
        if (this.link == null) {
            ClickHandler clickListener = new ClickHandler(){

                public void onClick(ClickEvent event) {
                    OpenEntityDetailsTabHelper.openMetaproject(MetaprojectTreeMetaprojectItemWidget.this.getViewContext(), MetaprojectTreeMetaprojectItemWidget.this.data.getMetaproject(), WidgetUtils.ifSpecialKeyPressed(event.getNativeEvent()));
                    event.stopPropagation();
                }
            };
            MouseDownHandler mouseDownHandler = new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    event.stopPropagation();
                }
            };
            this.link = LinkRenderer.getLinkAnchor(this.getViewContext().getMessage("metaproject_tree_info_link", new Object[0]), clickListener, LinkExtractor.createMetaprojectLink(this.data.getMetaproject().getName()));
            this.link.addMouseDownHandler(mouseDownHandler);
            this.link.setVisible(this.isSelected());
        }
        return this.link;
    }

    private String getTooltip() {
        String name = StringEscapeUtils.unescapeHtml(this.data.getMetaproject().getName());
        String description = this.data.getMetaproject().getDescription();
        description = description == null ? this.getViewContext().getMessage("metaproject_tree_description_not_available", new Object[0]) : StringEscapeUtils.unescapeHtml(description);
        return this.getViewContext().getMessage("metaproject_tree_metaproject_tooltip", name, description);
    }

    @Override
    protected void onSelectedChange() {
        this.getLink().setVisible(this.isSelected());
    }
}

