/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyTermValidator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;

public final class VocabularyRegistrationFieldSet
extends FieldSet {
    public static final String ID = "vocabulary_registration_field_set";
    private CodeField vocabularyCodeField;
    private MultilineVarcharField vocabularyDescriptionField;
    private CheckBox chosenFromListCheckbox;
    private VocabularyTermsSection vocabularyTermsSection;
    private final IMessageProvider messageProvider;
    private final int labelWidth;
    private final int fieldWidth;
    private final String idPrefix;
    private final String termsSessionKey;

    public VocabularyRegistrationFieldSet(IMessageProvider messageProvider, String idPrefix, int labelWidth, int fieldWidth, String termsSessionKey) {
        this.messageProvider = messageProvider;
        this.labelWidth = labelWidth;
        this.fieldWidth = fieldWidth;
        this.idPrefix = String.valueOf(idPrefix) + ID;
        this.termsSessionKey = termsSessionKey;
        this.createForm();
    }

    private void createForm() {
        this.setHeading(this.messageProvider.getMessage("vocabulary", new Object[0]));
        this.setLayout((Layout)this.createFormLayout());
        this.setWidth(this.labelWidth + this.fieldWidth + 40);
        this.vocabularyCodeField = this.createCodeField();
        this.add((Component)this.vocabularyCodeField);
        this.vocabularyDescriptionField = new DescriptionField(this.messageProvider, false, this.idPrefix);
        this.add((Component)this.vocabularyDescriptionField);
        this.createVocabularyTermsSection();
        this.chosenFromListCheckbox = this.createChosenFromListCheckbox();
        this.add((Component)this.chosenFromListCheckbox);
    }

    private void createVocabularyTermsSection() {
        this.vocabularyTermsSection = new VocabularyTermsSection();
    }

    private final FormLayout createFormLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.setLabelWidth(this.labelWidth);
        formLayout.setDefaultWidth(this.fieldWidth);
        return formLayout;
    }

    private final CodeField createCodeField() {
        CodeField codeField = CommonVocabularyRegistrationAndEditionFieldsFactory.createCodeField(this.messageProvider);
        codeField.setId(String.valueOf(this.idPrefix) + "_code");
        return codeField;
    }

    private CheckBox createChosenFromListCheckbox() {
        CheckBox checkBox = CommonVocabularyRegistrationAndEditionFieldsFactory.createChosenFromListCheckbox(this.messageProvider);
        checkBox.setId(String.valueOf(this.idPrefix) + "_chosen-from-list");
        FieldUtil.setValueWithoutEvents(checkBox, true);
        return checkBox;
    }

    public final NewVocabulary createVocabulary() {
        NewVocabulary vocabulary = new NewVocabulary();
        vocabulary.setCode(this.getVocabularyCodeValue());
        vocabulary.setDescription(this.getDescriptionValue());
        vocabulary.setChosenFromList(this.getChosenFromListValue());
        this.vocabularyTermsSection.setValues(vocabulary);
        return vocabulary;
    }

    public boolean isUploadFileDefined() {
        return this.vocabularyTermsSection.isUploadFileDefined();
    }

    private final String getVocabularyCodeValue() {
        return ((String)this.vocabularyCodeField.getValue()).toUpperCase();
    }

    private final String getDescriptionValue() {
        return StringUtils.trimToNull((String)this.vocabularyDescriptionField.getValue());
    }

    private final boolean getChosenFromListValue() {
        return this.chosenFromListCheckbox.getValue();
    }

    public final void setVisible(boolean visible) {
        super.setVisible(visible);
        FieldUtil.setVisibility(visible, new Field[]{this.vocabularyCodeField});
        this.vocabularyTermsSection.setVisible(visible);
    }

    public static class CommonVocabularyRegistrationAndEditionFieldsFactory {
        public static CodeField createCodeField(IMessageProvider messageProvider) {
            return new CodeField(messageProvider, messageProvider.getMessage("code", new Object[0]));
        }

        public static CheckBox createChosenFromListCheckbox(final IMessageProvider messageProvider) {
            final CheckBoxField result = new CheckBoxField(messageProvider.getMessage("vocabulary_show_available_terms_in_choosers", new Object[0]), false);
            result.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                public void handleEvent(FieldEvent be) {
                    if (result.getValue().booleanValue()) {
                        new ConfirmationDialog(messageProvider.getMessage("confirm_title", new Object[0]), messageProvider.getMessage("confirm_vocabulary_show_available_terms_in_chooosers_msg", new Object[0])){

                            @Override
                            protected void onYes() {
                            }

                            @Override
                            protected void onNo() {
                                FieldUtil.setValueWithoutEvents(result, false);
                            }
                        }.show();
                    }
                }
            });
            return result;
        }

        public static VarcharField createURLTemplateField(IMessageProvider messageProvider) {
            String fieldLabel = messageProvider.getMessage("vocabulary_terms_url_template", new Object[0]);
            String templatePattern = BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN;
            String regex = ".*" + templatePattern + ".*";
            final VarcharField result = new VarcharField(fieldLabel, false);
            result.setAutoValidate(false);
            result.setEmptyText("for example http://www.ebi.ac.uk/QuickGO/GTerm?id=${term}");
            result.setRegex(regex);
            result.getMessages().setRegexText("URL template must contain '${term}', which will be substituted with appropriate term automatically.");
            result.setId("vocabulary_registration_field_set-url");
            result.addListener(Events.Focus, (Listener)new Listener<FieldEvent>(){

                public void handleEvent(FieldEvent be) {
                    result.clearInvalid();
                }
            });
            return result;
        }
    }

    private class VocabularyTermsSection {
        private Radio freeText;
        private Radio fromFile;
        private TextArea termsArea;
        private VarcharField urlTemplateField;
        private FileUploadField uploadFileField;
        private LabelField fileFormatField;

        public VocabularyTermsSection() {
            VocabularyRegistrationFieldSet.this.add((Component)this.createSourceRadio());
            this.termsArea = this.createTermsArea();
            VocabularyRegistrationFieldSet.this.add((Component)this.termsArea);
            this.uploadFileField = this.createImportFileField();
            VocabularyRegistrationFieldSet.this.add((Component)this.uploadFileField);
            this.fileFormatField = this.createFileFormatField();
            VocabularyRegistrationFieldSet.this.add((Component)this.fileFormatField);
            this.urlTemplateField = this.createURLTemplateField();
            VocabularyRegistrationFieldSet.this.add((Component)this.urlTemplateField);
            this.updateSection();
        }

        public void setVisible(boolean visible) {
            FieldUtil.setVisibility(visible, new Field[]{this.termsArea, this.uploadFileField, this.fileFormatField});
            if (visible) {
                this.updateSection();
            }
        }

        private final RadioGroup createSourceRadio() {
            RadioGroup result = new RadioGroup();
            result.setSelectionRequired(true);
            result.setOrientation(Style.Orientation.HORIZONTAL);
            this.freeText = this.createRadio("specify the list of terms");
            this.fromFile = this.createRadio("load terms from a file");
            result.add(this.freeText);
            result.add(this.fromFile);
            FieldUtil.setValueWithoutEvents(result, this.freeText);
            result.setLabelSeparator("");
            Listener<BaseEvent> listener = new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    Boolean useFreeText = VocabularyTermsSection.this.freeText.getValue();
                    FieldUtil.setValueWithoutEvents(VocabularyRegistrationFieldSet.this.chosenFromListCheckbox, useFreeText);
                    VocabularyTermsSection.this.updateSection();
                }
            };
            this.freeText.addListener(Events.Change, (Listener)listener);
            this.fromFile.addListener(Events.Change, (Listener)listener);
            return result;
        }

        private final Radio createRadio(String label) {
            Radio result = new Radio();
            result.setBoxLabel(label);
            return result;
        }

        private VarcharField createURLTemplateField() {
            return CommonVocabularyRegistrationAndEditionFieldsFactory.createURLTemplateField(VocabularyRegistrationFieldSet.this.messageProvider);
        }

        private FileUploadField createImportFileField() {
            BasicFileFieldManager fileManager = new BasicFileFieldManager(VocabularyRegistrationFieldSet.this.termsSessionKey, 1, "File");
            fileManager.setMandatory();
            return (FileUploadField)fileManager.getFields().get(0);
        }

        private LabelField createFileFormatField() {
            LabelField result = new LabelField(VocabularyRegistrationFieldSet.this.messageProvider.getMessage("vocabulary_terms_file_format", new Object[0]));
            result.setFieldLabel("File format");
            result.setLabelSeparator(":");
            return result;
        }

        private final TextArea createTermsArea() {
            TextArea textArea = new TextArea();
            String fieldLabel = VocabularyRegistrationFieldSet.this.messageProvider.getMessage("vocabulary_terms", new Object[0]);
            VarcharField.configureField(textArea, fieldLabel, true);
            textArea.setHeight("10em");
            textArea.setId(String.valueOf(VocabularyRegistrationFieldSet.this.idPrefix) + "_terms");
            textArea.setEmptyText(VocabularyRegistrationFieldSet.this.messageProvider.getMessage("vocabulary_terms_empty", new Object[0]));
            textArea.setValidator((Validator)new VocabularyTermValidator(VocabularyRegistrationFieldSet.this.messageProvider));
            return textArea;
        }

        private void updateSection() {
            Boolean useFreeText = this.freeText.getValue();
            FieldUtil.setVisibility(useFreeText, new Field[]{this.termsArea});
            FieldUtil.setVisibility(useFreeText == false, new Field[]{this.uploadFileField, this.fileFormatField});
        }

        public void setValues(NewVocabulary vocabulary) {
            vocabulary.setUploadedFromFile(this.fromFile.getValue());
            vocabulary.setURLTemplate(this.getURLTemplateValue());
            vocabulary.setTerms(VocabularyTermValidator.getTerms(this.getTermsAreaValue()));
        }

        public boolean isUploadFileDefined() {
            return this.uploadFileField.isVisible() ? !StringUtils.isBlank(((String)this.uploadFileField.getValue()).toString()) : false;
        }

        private String getTermsAreaValue() {
            return this.termsArea.isVisible() ? (String)this.termsArea.getValue() : null;
        }

        private String getURLTemplateValue() {
            return this.urlTemplateField.isVisible() ? (String)this.urlTemplateField.getValue() : null;
        }
    }
}

