/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.coreplugin;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.ModuleEnabledChecker;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class CorePluginRegistrator
implements InitializingBean {
    private final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, this.getClass());
    private ICommonServerForInternalUse commonServer;
    private String pluginsFolderName;
    private ModuleEnabledChecker moduleEnabledChecker;

    public void registerPlugins() {
        if ("${core-plugins-folder}".equals(this.pluginsFolderName) || this.pluginsFolderName.contains("webapps/openbis/core-plugins")) {
            this.pluginsFolderName = "../../core-plugins";
        }
        CorePluginScanner pluginScanner = new CorePluginScanner(this.pluginsFolderName, CorePluginScanner.ScannerType.AS);
        String sessionToken = this.getSessionToken();
        for (CorePlugin plugin : pluginScanner.scanForPlugins()) {
            if (!this.moduleEnabledChecker.isModuleEnabled(plugin.getName())) continue;
            try {
                this.commonServer.registerPlugin(sessionToken, plugin, pluginScanner);
            }
            catch (Exception ex) {
                this.operationLog.error((Object)("Failed to install core plugin: " + plugin), (Throwable)ex);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.registerPlugins();
    }

    public void setPluginsFolderName(String pluginsFolderName) {
        this.pluginsFolderName = pluginsFolderName;
    }

    public void setEnabledTechnologies(String listOfEnabledTechnologies) {
        this.moduleEnabledChecker = new ModuleEnabledChecker(new ArrayList<String>(ServerUtils.extractSet(listOfEnabledTechnologies)));
    }

    public void setCommonServer(ICommonServerForInternalUse commonServer) {
        this.commonServer = commonServer;
    }

    private String getSessionToken() {
        SessionContextDTO sessionDTO = this.commonServer.tryToAuthenticateAsSystem();
        String sessionToken = sessionDTO.getSessionToken();
        return sessionToken;
    }
}

