/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.common.logging.ConsoleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationException;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationScriptRunner;
import ch.systemsx.cisd.openbis.generic.shared.cli.OpenBisConsoleClientArguments;
import java.io.File;
import java.io.OutputStream;

public class MasterDataRegistrationScriptRunnerStandalone {
    void runMe(String[] args) {
        Arguments arguments = new Arguments();
        CmdLineParser argumentsParser = new CmdLineParser((Object)arguments);
        try {
            argumentsParser.parseArgument(args);
        }
        catch (CmdLineException cmdLineException) {
            this.printHelp(argumentsParser);
            return;
        }
        if (arguments.isComplete()) {
            this.runMe(arguments);
        } else {
            this.printHelp(argumentsParser);
        }
    }

    private void printHelp(CmdLineParser argumentsParser) {
        argumentsParser.printUsage((OutputStream)System.out);
        String example = argumentsParser.printExample(ExampleMode.ALL);
        System.out.println(String.format("Example: java %s %s", this.getClass().getName(), example));
    }

    private void runMe(Arguments arguments) {
        EncapsulatedCommonServer commonServer = EncapsulatedCommonServer.create(arguments.getServerBaseUrl(), arguments.getUsername(), arguments.getPassword());
        MasterDataRegistrationScriptRunner scriptRunner = new MasterDataRegistrationScriptRunner(commonServer);
        File jythonScript = new File(arguments.scriptFileName);
        try {
            scriptRunner.executeScript(jythonScript);
        }
        catch (MasterDataRegistrationException mdre) {
            ConsoleLogger errorLogger = new ConsoleLogger();
            errorLogger.log(LogLevel.ERROR, "Failed to commit all transactions for script " + jythonScript.getAbsolutePath());
            mdre.logErrors(errorLogger);
        }
    }

    public static void main(String[] args) {
        MasterDataRegistrationScriptRunnerStandalone cliApplication = new MasterDataRegistrationScriptRunnerStandalone();
        cliApplication.runMe(args);
    }

    public static class Arguments
    extends OpenBisConsoleClientArguments {
        @Option(name="f", longName="script-file", usage="Jython script file", required=true)
        private String scriptFileName = "";

        public String getScriptFileName() {
            return this.scriptFileName;
        }
    }
}

