/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.demo.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AttachmentRegistrationHelper;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.plugin.demo.client.web.client.IDemoClientService;
import ch.systemsx.cisd.openbis.plugin.demo.shared.IDemoServer;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="demo-plugin-service")
public final class DemoClientService
extends AbstractClientService
implements IDemoClientService {
    @Resource(name="demo-plugin-server")
    private IDemoServer demoServer;

    public DemoClientService() {
    }

    @Private
    DemoClientService(IDemoServer demoServer, IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
        this.demoServer = demoServer;
    }

    @Override
    protected final IServer getServer() {
        return this.demoServer;
    }

    @Override
    public final SampleParentWithDerived getSampleGenerationInfo(TechId sampleId, String baseIndexURL) {
        String sessionToken = this.getSessionToken();
        SampleParentWithDerived sampleGenerationDTO = this.demoServer.getSampleInfo(sessionToken, sampleId);
        return sampleGenerationDTO;
    }

    @Override
    public final void registerSample(String sessionKey, final NewSample sample) {
        final String sessionToken = this.getSessionToken();
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                DemoClientService.this.demoServer.registerSample(sessionToken, sample, attachments);
            }
        }.process(sessionKey, this.getHttpSession(), sample.getAttachments());
    }

    @Override
    public int getNumberOfExperiments() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.demoServer.getNumberOfExperiments(sessionToken);
    }
}

