/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinByExperimentBrowserGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinSummaryGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinByExperimentCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AggregateFunction;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;

class ProteinByExperimentBrowerToolBar
extends ToolBar {
    private static final AggregateFunction DEFAULT_AGGREGATE_FUNCTION = AggregateFunction.MEAN;
    private final IViewContext<IPhosphoNetXClientServiceAsync> viewContext;
    private final ComboBox<FalseDiscoveryRateModel> fdrComboBox;
    private final ComboBox<AggregateFunctionModel> aggregateFunctionComboBox;
    private final VocabularyTermSelectionWidget treatmentTypeComboBox;
    private final CheckBox aggregateOriginalCheckBox;
    private ProteinByExperimentBrowserGrid browserGrid;
    private Experiment experiment;
    private ProteinSummaryGrid summaryGrid;

    ProteinByExperimentBrowerToolBar(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, Experiment experiment) {
        this.viewContext = viewContext;
        this.experiment = experiment;
        this.setBorders(true);
        this.setWidth(3000);
        this.add((Component)new LabelToolItem(String.valueOf(viewContext.getMessage("false_discovery_rate_filter_label", new Object[0])) + ":"));
        this.fdrComboBox = this.createFDRComboBox(new SelectionChangedListener<FalseDiscoveryRateModel>(){

            public void selectionChanged(SelectionChangedEvent<FalseDiscoveryRateModel> se) {
                ProteinByExperimentBrowerToolBar.this.update();
            }
        });
        this.add((Component)this.fdrComboBox);
        this.add((Component)new LabelToolItem(String.valueOf(viewContext.getMessage("aggregate_function_label", new Object[0])) + ":"));
        this.aggregateFunctionComboBox = this.createAggregateFunctionComboBox(new SelectionChangedListener<AggregateFunctionModel>(){

            public void selectionChanged(SelectionChangedEvent<AggregateFunctionModel> se) {
                ProteinByExperimentBrowerToolBar.this.update();
            }
        });
        this.add((Component)this.aggregateFunctionComboBox);
        this.add((Component)new LabelToolItem(String.valueOf(viewContext.getMessage("aggregate_on_treatment_type_label", new Object[0])) + ":"));
        this.treatmentTypeComboBox = new AggregateOnTreatmentTypeSelectionWidget(viewContext);
        this.treatmentTypeComboBox.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<VocabularyTermModel>(){

            public void selectionChanged(SelectionChangedEvent<VocabularyTermModel> se) {
                ProteinByExperimentBrowerToolBar.this.update();
            }
        });
        this.add((Component)this.treatmentTypeComboBox);
        this.add((Component)new LabelToolItem(String.valueOf(viewContext.getMessage("aggregate_original_label", new Object[0])) + ":"));
        this.aggregateOriginalCheckBox = new CheckBox();
        this.aggregateOriginalCheckBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                ProteinByExperimentBrowerToolBar.this.update();
            }
        });
        this.add((Component)this.aggregateOriginalCheckBox);
    }

    private ComboBox<FalseDiscoveryRateModel> createFDRComboBox(SelectionChangedListener<FalseDiscoveryRateModel> changedListener) {
        ComboBox comboBox = new ComboBox();
        ListStore listStore = new ListStore();
        FalseDiscoveryRateModel fdr0 = new FalseDiscoveryRateModel(0.0);
        listStore.add((ModelData)fdr0);
        listStore.add((ModelData)new FalseDiscoveryRateModel(0.01));
        listStore.add((ModelData)new FalseDiscoveryRateModel(0.025));
        listStore.add((ModelData)new FalseDiscoveryRateModel(0.05));
        listStore.add((ModelData)new FalseDiscoveryRateModel(0.1));
        comboBox.setStore(listStore);
        comboBox.setDisplayField("property");
        comboBox.setValue((ModelData)fdr0);
        comboBox.addSelectionChangedListener(changedListener);
        comboBox.setEnabled(true);
        comboBox.setWidth(60);
        comboBox.setTriggerAction(ComboBox.TriggerAction.ALL);
        return comboBox;
    }

    private ComboBox<AggregateFunctionModel> createAggregateFunctionComboBox(SelectionChangedListener<AggregateFunctionModel> changedListener) {
        ComboBox comboBox = new ComboBox();
        ListStore store = new ListStore();
        AggregateFunctionModel defaultModel = null;
        AggregateFunction[] aggregateFunctionArray = AggregateFunction.values();
        int n = aggregateFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AggregateFunction aggregateFunction = aggregateFunctionArray[n2];
            AggregateFunctionModel model = new AggregateFunctionModel(aggregateFunction);
            store.add((ModelData)model);
            if (aggregateFunction == DEFAULT_AGGREGATE_FUNCTION) {
                defaultModel = model;
            }
            ++n2;
        }
        comboBox.setStore(store);
        comboBox.setDisplayField("property");
        comboBox.setValue(defaultModel);
        comboBox.addSelectionChangedListener(changedListener);
        comboBox.setWidth(100);
        comboBox.setEnabled(true);
        comboBox.setTriggerAction(ComboBox.TriggerAction.ALL);
        return comboBox;
    }

    Experiment getExperimentOrNull() {
        return this.experiment;
    }

    void setBrowserGrid(ProteinByExperimentBrowserGrid browserGrid) {
        this.browserGrid = browserGrid;
    }

    void setSummaryGrid(ProteinSummaryGrid summaryGrid) {
        this.summaryGrid = summaryGrid;
    }

    void update() {
        if (this.experiment != null) {
            final TechId experimentID = TechId.create(this.experiment);
            this.browserGrid.setLoadMaskImmediately(true);
            this.browserGrid.setPostRefreshCallback(new IDataRefreshCallback(){

                @Override
                public void postRefresh(boolean wasSuccessful) {
                    if (ProteinByExperimentBrowerToolBar.this.summaryGrid != null) {
                        ProteinByExperimentBrowerToolBar.this.summaryGrid.setLoadMaskImmediately(true);
                        ProteinByExperimentBrowerToolBar.this.summaryGrid.update(experimentID);
                    }
                }
            });
            double falseDiscoveryRate = this.getSelection(this.fdrComboBox, 0.0);
            AggregateFunction aggregateFunction = this.getSelection(this.aggregateFunctionComboBox, DEFAULT_AGGREGATE_FUNCTION);
            VocabularyTermModel value = (VocabularyTermModel)this.treatmentTypeComboBox.getValue();
            String treatmentTypeCode = value == null ? null : value.getTerm().getCode();
            AbundanceColumnDefinitionsCallback callback = new AbundanceColumnDefinitionsCallback(this.viewContext, this.browserGrid, experimentID, falseDiscoveryRate, aggregateFunction, treatmentTypeCode, this.aggregateOriginalCheckBox.getValue());
            this.viewContext.getService().getAbundanceColumnDefinitionsForProteinByExperiment(experimentID, treatmentTypeCode, callback);
        }
    }

    ListProteinByExperimentCriteria getCriteria() {
        ListProteinByExperimentCriteria criteria = new ListProteinByExperimentCriteria();
        criteria.setExperimentID(TechId.create(this.experiment));
        criteria.setFalseDiscoveryRate(this.getSelection(this.fdrComboBox, 0.0));
        criteria.setAggregateFunction(this.getSelection(this.aggregateFunctionComboBox, DEFAULT_AGGREGATE_FUNCTION));
        VocabularyTermModel value = (VocabularyTermModel)this.treatmentTypeComboBox.getValue();
        String treatmentTypeCode = value == null ? null : value.getTerm().getCode();
        criteria.setTreatmentTypeCode(treatmentTypeCode);
        criteria.setAggregateOriginal(this.aggregateOriginalCheckBox.getValue());
        return criteria;
    }

    private <T> T getSelection(ComboBox<? extends SimpleModel<T>> comboBox, T defaultValue) {
        List selection = comboBox.getSelection();
        return selection.isEmpty() ? defaultValue : ((SimpleModel)((Object)selection.get(0))).getObject();
    }

    private static final class AbundanceColumnDefinitionsCallback
    extends AbstractAsyncCallback<List<AbundanceColumnDefinition>> {
        private final ProteinByExperimentBrowserGrid browserGrid;
        private final TechId experimentID;
        private final double falseDiscoveryRate;
        private final AggregateFunction aggregateFunction;
        private final String treatmentTypeCode;
        private final boolean aggregateOriginal;

        public AbundanceColumnDefinitionsCallback(IViewContext<?> viewContext, ProteinByExperimentBrowserGrid browserGrid, TechId experimentID, double falseDiscoveryRate, AggregateFunction aggregateFunction, String treatmentTypeCode, boolean aggregateOriginal) {
            super(viewContext);
            this.browserGrid = browserGrid;
            this.experimentID = experimentID;
            this.falseDiscoveryRate = falseDiscoveryRate;
            this.aggregateFunction = aggregateFunction;
            this.treatmentTypeCode = treatmentTypeCode;
            this.aggregateOriginal = aggregateOriginal;
        }

        @Override
        protected void process(List<AbundanceColumnDefinition> result) {
            this.browserGrid.update(this.experimentID, this.falseDiscoveryRate, this.aggregateFunction, this.treatmentTypeCode, this.aggregateOriginal, result);
        }
    }

    private static final class AggregateFunctionModel
    extends SimpleModel<AggregateFunction> {
        private static final long serialVersionUID = 1L;

        AggregateFunctionModel(AggregateFunction aggregateFunction) {
            super(aggregateFunction);
        }

        @Override
        protected String render(AggregateFunction modelObject) {
            return modelObject.getLabel();
        }
    }

    private static final class AggregateOnTreatmentTypeSelectionWidget
    extends VocabularyTermSelectionWidget {
        private final VocabularyTermModel nothingTermModel;

        AggregateOnTreatmentTypeSelectionWidget(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
            super("treatmentType", "treatmentType", false, null, viewContext, null, null);
            this.setAllowBlank(false);
            this.setForceSelection(true);
            VocabularyTerm nothingTerm = new VocabularyTerm();
            nothingTerm.setLabel("(nothing)");
            this.nothingTermModel = new VocabularyTermModel(nothingTerm);
            this.setValue((ModelData)this.nothingTermModel);
            viewContext.getService().getTreatmentTypeVocabulary((AsyncCallback<Vocabulary>)new AbstractAsyncCallback<Vocabulary>(viewContext){

                @Override
                protected void process(Vocabulary vocabulary) {
                    AggregateOnTreatmentTypeSelectionWidget.this.setVocabulary(vocabulary);
                }
            });
        }

        @Override
        protected List<VocabularyTermModel> convertItems(List<VocabularyTerm> result) {
            List<VocabularyTermModel> terms = super.convertItems(result);
            terms.add(0, this.nothingTermModel);
            return terms;
        }
    }

    private static final class FalseDiscoveryRateModel
    extends SimpleModel<Double> {
        private static final long serialVersionUID = 1L;

        FalseDiscoveryRateModel(Double falseDiscoveryRate) {
            super(falseDiscoveryRate);
        }

        @Override
        protected String render(Double modelObject) {
            int percent = (int)(100.0 * modelObject);
            int percentFraction = (int)(1000.0 * modelObject + 0.5) - 10 * percent;
            return String.valueOf(Integer.toString(percent)) + (percentFraction == 0 ? "" : "." + Integer.toString(percentFraction)) + "%";
        }
    }

    private static abstract class SimpleModel<T>
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY = "property";
        private final T object;

        SimpleModel(T object) {
            this.object = object;
            this.set(PROPERTY, this.render(object));
        }

        public final T getObject() {
            return this.object;
        }

        protected abstract String render(T var1);
    }
}

