/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.WizardPage;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.BiologicalSampleGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.MsInjectionAnnotationWizardState;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.MsInjectionSampleAnnotationModel;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import java.util.List;

public class BiologicalSampleChoosingPage
extends WizardPage<MsInjectionSampleAnnotationModel> {
    private final IViewContext<IPhosphoNetXClientServiceAsync> viewContext;
    private BiologicalSampleGrid sampleGrid;

    public BiologicalSampleChoosingPage(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, MsInjectionSampleAnnotationModel model) {
        super(viewContext, MsInjectionAnnotationWizardState.BIOLOGICAL_SAMPLE_CHOOSING, model);
        this.viewContext = viewContext;
        this.setLeftContentByDictionary();
    }

    @Override
    public void init() {
        this.addToRightContent((Component)new Label("Please choose a biological sample as annotation of the MS_INJECTION samples selected previously:"), new RowData(1.0, -1.0, new Margins(10)));
        this.sampleGrid = new BiologicalSampleGrid(this.viewContext);
        this.sampleGrid.addGridSelectionChangeListener(new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> se) {
                List selection = se.getSelection();
                boolean enabled = selection.size() == 1;
                BiologicalSampleChoosingPage.this.enableNextButton(enabled);
            }
        });
        this.addToRightContent((Component)this.sampleGrid, new RowData(1.0, 400.0, new Margins(20, 10, 10, 10)));
    }

    @Override
    public void deactivate() {
        List selectedItems = this.sampleGrid.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            ((MsInjectionSampleAnnotationModel)this.model).setBiologicalSample((Sample)selectedItems.get(0).getBaseObject().getObjectOrNull());
        }
    }

    @Override
    public void destroy() {
        this.sampleGrid.dispose();
    }
}

