/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumn;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AggregateFunction;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Treatment;
import java.util.HashMap;
import java.util.Map;

public class ProteinProvider
extends AbstractTableModelProvider<ProteinInfo> {
    private static final String ABUNDANCE_PROPERTY_KEY = "ABUNDANCE";
    private final IPhosphoNetXServer server;
    private final String sessionToken;
    private final TechId experimentID;
    private final double falseDiscoveryRate;
    private final AggregateFunction aggregateFunction;
    private final String treatmentTypeCode;
    private final boolean aggregateOnOriginal;

    public ProteinProvider(IPhosphoNetXServer server, String sessionToken, TechId experimentID, double falseDiscoveryRate, AggregateFunction function, String treatmentTypeCode, boolean aggregateOnOriginal) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.experimentID = experimentID;
        this.falseDiscoveryRate = falseDiscoveryRate;
        this.aggregateFunction = function;
        this.treatmentTypeCode = treatmentTypeCode;
        this.aggregateOnOriginal = aggregateOnOriginal;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected TypedTableModel<ProteinInfo> createTableModel() {
        try {
            abundanceColumnDefinitions = this.server.getAbundanceColumnDefinitionsForProteinByExperiment(this.sessionToken, this.experimentID, this.treatmentTypeCode);
            proteins = this.server.listProteinsByExperiment(this.sessionToken, this.experimentID, this.falseDiscoveryRate, this.aggregateFunction, this.treatmentTypeCode, this.aggregateOnOriginal);
            builder = new TypedTableModelBuilder<ProteinInfo>();
            builder.addColumn("ACCESSION_NUMBER");
            builder.addColumn("PROTEIN_DESCRIPTION");
            builder.addColumn("COVERAGE").withDefaultWidth(100);
            sampleIdToAbundanceColumnMap = new HashMap<Long, IColumn>();
            for (AbundanceColumnDefinition abundanceColumnDefinition : abundanceColumnDefinitions) {
                sampleID = abundanceColumnDefinition.getID();
                columnID = "abundance-" + Long.toString(sampleID);
                builder.addColumn(columnID).withDefaultWidth(100);
                column = builder.column(columnID);
                sampleIdToAbundanceColumnMap.put(sampleID, column);
                header = abundanceColumnDefinition.getSampleCode();
                properties = new HashMap<String, String>();
                properties.put("ABUNDANCE", header);
                treatments = abundanceColumnDefinition.getTreatments();
                if (!treatments.isEmpty()) {
                    if (header == null) {
                        header = "";
                        delim = "";
                    } else {
                        delim = ": ";
                    }
                    for (Treatment treatment : treatments) {
                        header = String.valueOf(header) + delim + treatment;
                        delim = ", ";
                        column.property(treatment.getTypeCode(), treatment.getValue());
                    }
                }
                column.withTitle(header);
            }
            for (ProteinInfo protein : proteins) {
                builder.addRow(protein);
                builder.column("ACCESSION_NUMBER").addString(protein.getAccessionNumber());
                builder.column("PROTEIN_DESCRIPTION").addString(protein.getDescription());
                builder.column("COVERAGE").addDouble(protein.getCoverage());
                abundances = protein.getAbundances();
                entrySet = abundances.entrySet();
                for (Map.Entry<Long, Double> entry : entrySet) {
                    column = (IColumn)sampleIdToAbundanceColumnMap.get(entry.getKey());
                    if (column == null) continue;
                    column.addDouble(entry.getValue());
                }
            }
            return builder.getModel();
        }
        catch (Exception e) {
            t /* !! */  = e;
            ** while (t /* !! */  != null)
        }
lbl-1000:
        // 1 sources

        {
            if (t /* !! */  instanceof HighLevelException) {
                throw (HighLevelException)t /* !! */ ;
            }
            t /* !! */  = t /* !! */ .getCause();
            continue;
        }
lbl61:
        // 1 sources

        throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
    }
}

