/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.ProteomicsDataServiceInternalLogger;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.authorization.validator.ParentSampleValidator;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.authorization.validator.RawDataSampleValidator;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ExperimentLoader;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleLoader;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IProteomicsDataServiceInternal;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.MsInjectionSample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProteomicsDataServiceInternal
extends AbstractServer<IProteomicsDataServiceInternal>
implements IProteomicsDataServiceInternal {
    private static final IValidator<Sample> PARENT_SAMPLE_VALIDATOR = new ParentSampleValidator();
    private static final IValidator<MsInjectionSample> RAW_DATA_SAMPLE_VALIDATOR = new RawDataSampleValidator();
    private static final IValidator<Experiment> EXPERIMENT_VALIDATOR = new ExperimentValidator();
    private ICommonBusinessObjectFactory commonBoFactory;
    private ISessionManager<Session> sessionManagerFromConstructor;
    private ExperimentLoader experimentLoader;
    private IBusinessObjectFactory boFactory;
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public ProteomicsDataServiceInternal() {
    }

    public ProteomicsDataServiceInternal(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, ICommonBusinessObjectFactory businessObjectFactory, IBusinessObjectFactory boFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(sessionManager, daoFactory, null, businessObjectFactory, boFactory, managedPropertyEvaluatorFactory);
    }

    ProteomicsDataServiceInternal(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonBusinessObjectFactory businessObjectFactory, IBusinessObjectFactory boFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.sessionManagerFromConstructor = sessionManager;
        this.commonBoFactory = businessObjectFactory;
        this.boFactory = boFactory;
        this.experimentLoader = new ExperimentLoader(this.getDAOFactory(), managedPropertyEvaluatorFactory);
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    public void replaceAutoWiredSesseionManagerByConstructorSessionManager() {
        this.sessionManager = this.sessionManagerFromConstructor;
    }

    @Override
    public IProteomicsDataServiceInternal createLogger(IInvocationLoggerContext context) {
        return new ProteomicsDataServiceInternalLogger(this.getSessionManager(), context);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @ReturnValueFilter(validatorClass=RawDataSampleValidator.class)
    public List<MsInjectionSample> listRawDataSamples(String sessionToken) {
        return this.loadAllRawDataSamples(this.getSession(sessionToken));
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void processRawData(String sessionToken, String dataSetProcessingKey, long[] rawDataSampleIDs, String dataSetType) {
        Session session = this.getSession(sessionToken);
        PersonPE person = session.tryGetPerson();
        List<MsInjectionSample> samples = this.loadAllRawDataSamples(session);
        Set<Long> sampleIDs = this.asSet(rawDataSampleIDs);
        ArrayList<String> dataSetCodes = new ArrayList<String>();
        HashMap<String, String> parameterBindings = new HashMap<String, String>();
        for (MsInjectionSample sample : samples) {
            Map<String, AbstractExternalData> latestDataSets;
            AbstractExternalData latestDataSet;
            if (!RAW_DATA_SAMPLE_VALIDATOR.isValid(person, sample) || !sampleIDs.contains(sample.getSample().getId()) || (latestDataSet = (latestDataSets = sample.getLatestDataSets()).get(dataSetType)) == null) continue;
            String code = latestDataSet.getCode();
            dataSetCodes.add(code);
            parameterBindings.put(code, sample.getSample().getCode());
        }
        this.processDataSets(session, dataSetProcessingKey, dataSetCodes, parameterBindings);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void processDataSets(String sessionToken, String dataSetProcessingKey, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes) {
        Session session = this.getSession(sessionToken);
        this.processDataSets(session, dataSetProcessingKey, dataSetCodes, new HashMap<String, String>());
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @ReturnValueFilter(validatorClass=ExperimentValidator.class)
    public List<Experiment> listExperiments(String sessionToken, String experimentTypeCode) {
        Session session = this.getSession(sessionToken);
        IDAOFactory daoFactory = this.getDAOFactory();
        IEntityTypeDAO entityTypeDAO = daoFactory.getEntityTypeDAO(EntityKind.EXPERIMENT);
        ExperimentTypePE type = (ExperimentTypePE)entityTypeDAO.tryToFindEntityTypeByCode(experimentTypeCode);
        List<ExperimentPE> experiments = daoFactory.getExperimentDAO().listExperimentsWithProperties(type, null, null);
        Collection<MetaprojectAssignmentPE> assignmentPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectAssignmentsForEntities(session.tryGetPerson(), experiments, EntityKind.EXPERIMENT);
        Map<Long, Set<Metaproject>> assignments = MetaprojectTranslator.translateMetaprojectAssignments(assignmentPEs);
        return ExperimentTranslator.translate(experiments, "", assignments, this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public List<AbstractExternalData> listDataSetsByExperiment(String sessionToken, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId experimentID) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.commonBoFactory.createDataSetTable(session);
        dataSetTable.loadByExperimentTechId(experimentID);
        List<DataPE> dataSetPEs = dataSetTable.getDataSets();
        Collection<MetaprojectAssignmentPE> assignmentPEs = this.getDAOFactory().getMetaprojectDAO().listMetaprojectAssignmentsForEntities(session.tryGetPerson(), dataSetPEs, EntityKind.DATA_SET);
        return DataSetTranslator.translate(dataSetPEs, "", "", MetaprojectTranslator.translateMetaprojectAssignments(assignmentPEs), this.managedPropertyEvaluatorFactory);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void processProteinResultDataSets(String sessionToken, String dataSetProcessingKey, String experimentType, long[] searchExperimentIDs) {
        Session session = this.getSession(sessionToken);
        PersonPE person = session.tryGetPerson();
        ArrayList<String> dataSetCodes = new ArrayList<String>();
        IExperimentDAO experimentDAO = this.getDAOFactory().getExperimentDAO();
        IDataDAO dataSetDAO = this.getDAOFactory().getDataDAO();
        long[] lArray = searchExperimentIDs;
        int n = searchExperimentIDs.length;
        int n2 = 0;
        while (n2 < n) {
            long experimentID = lArray[n2];
            ExperimentPE experiment = (ExperimentPE)experimentDAO.tryGetByTechId(new TechId(experimentID), new String[0]);
            String actualExperimentTypeCode = experiment.getExperimentType().getCode();
            if (!actualExperimentTypeCode.equals(experimentType)) {
                throw new UserFailureException("Experiment with technical id " + experimentID + " [" + experiment.getIdentifier() + "] is not of type " + experimentType + " but of type " + actualExperimentTypeCode + ".");
            }
            Experiment translatedExperiment = ExperimentTranslator.translate(experiment, "", null, this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]);
            if (EXPERIMENT_VALIDATOR.isValid(person, translatedExperiment)) {
                List<DataPE> dataSets = dataSetDAO.listDataSets(experiment);
                dataSetCodes.addAll(Code.extractCodes(dataSets));
            }
            ++n2;
        }
        this.processDataSets(session, dataSetProcessingKey, dataSetCodes, new HashMap<String, String>());
    }

    private List<MsInjectionSample> loadAllRawDataSamples(Session session) {
        List<Sample> samples = this.loadAccessableSamples(session);
        ArrayList<Sample> parentSamples = new ArrayList<Sample>();
        for (Sample sample : samples) {
            parentSamples.add(sample.getGeneratedFrom());
        }
        this.experimentLoader.enrichWithExperiments(parentSamples);
        Map<Sample, List<AbstractExternalData>> dataSetsBySamples = this.commonBoFactory.createDatasetLister(session).listAllDataSetsFor(samples);
        ArrayList<MsInjectionSample> result = new ArrayList<MsInjectionSample>();
        for (Map.Entry<Sample, List<AbstractExternalData>> entry : dataSetsBySamples.entrySet()) {
            result.add(new MsInjectionSample(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    protected List<Sample> loadAccessableSamples(Session session) {
        ISampleLoader sampleLoader = this.boFactory.createSampleLoader(session);
        List<Sample> samples = sampleLoader.listSamplesWithParentsByTypeAndSpace("MS_INJECTION", "MS_DATA");
        PersonPE person = session.tryGetPerson();
        ArrayList<Sample> validSamples = new ArrayList<Sample>();
        for (Sample sample : samples) {
            if (!PARENT_SAMPLE_VALIDATOR.isValid(person, sample)) continue;
            validSamples.add(sample);
        }
        return validSamples;
    }

    private void processDataSets(Session session, String dataSetProcessingKey, List<String> dataSetCodes, Map<String, String> parameterBindings) {
        String dataStoreServerCode = this.findDataStoreServer(dataSetProcessingKey);
        IDataSetTable dataSetTable = this.commonBoFactory.createDataSetTable(session);
        dataSetTable.processDatasets(dataSetProcessingKey, dataStoreServerCode, dataSetCodes, parameterBindings);
    }

    private String findDataStoreServer(String dataSetProcessingKey) {
        List<DataStorePE> dataStores = this.getDAOFactory().getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : dataStores) {
            Set<DataStoreServicePE> services = dataStore.getServices();
            for (DataStoreServicePE dataStoreService : services) {
                if (!DataStoreServiceKind.PROCESSING.equals(dataStoreService.getKind()) || !dataSetProcessingKey.equals(dataStoreService.getKey())) continue;
                return dataStore.getCode();
            }
        }
        throw new EnvironmentFailureException("No data store processing service with key '" + dataSetProcessingKey + "' found.");
    }

    private Set<Long> asSet(long[] ids) {
        HashSet<Long> result = new HashSet<Long>();
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            result.add(id);
            ++n2;
        }
        return result;
    }
}

