/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.ProbabilityToFDRCalculator;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.IdentifiedProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProbabilityFDRMapping;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinReferenceWithProtein;
import java.util.HashMap;
import java.util.Map;
import net.lemnik.eodsql.DataSet;

class ErrorModel {
    private final Map<Long, ProbabilityToFDRCalculator> calculators = new HashMap<Long, ProbabilityToFDRCalculator>();
    private final IProteinQueryDAO dao;

    ErrorModel(IProteinQueryDAO dao) {
        this.dao = dao;
    }

    boolean passProtein(ProteinReferenceWithProtein protein, double falseDiscoveryRate) {
        ProbabilityToFDRCalculator calculator = this.getCalculator(protein.getDataSetID());
        double fdr = calculator.calculateFDR(protein.getProbability());
        return Double.isNaN(fdr) || fdr <= falseDiscoveryRate;
    }

    void setFalseDiscoveryRateFor(IdentifiedProtein protein) {
        long dataSetID = protein.getDataSetID();
        double probability = protein.getProbability();
        protein.setFalseDiscoveryRate(this.calculateFalsDiscoveryRate(dataSetID, probability));
    }

    double calculateFalsDiscoveryRate(long dataSetID, double probability) {
        ProbabilityToFDRCalculator calculator = this.getCalculator(dataSetID);
        return calculator.calculateFDR(probability);
    }

    private ProbabilityToFDRCalculator getCalculator(long dataSetID) {
        ProbabilityToFDRCalculator calculator = this.calculators.get(dataSetID);
        if (calculator == null) {
            calculator = new ProbabilityToFDRCalculator();
            DataSet<ProbabilityFDRMapping> mappings = this.dao.getProbabilityFDRMapping(dataSetID);
            for (ProbabilityFDRMapping probabilityFDRMapping : mappings) {
                double probability = probabilityFDRMapping.getProbability();
                double falseDiscoveryRate = probabilityFDRMapping.getFalseDiscoveryRate();
                calculator.add(probability, falseDiscoveryRate);
            }
            mappings.close();
            calculator.init();
            this.calculators.put(dataSetID, calculator);
        }
        return calculator;
    }
}

