/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.CheckBoxGroupWithModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelChooserPanel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ResolutionChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.ImageDatasetChannel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageChannelsReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.utils.GuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.AnalysisProcedures;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetOverlayImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageTransformationInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.MarginData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ChannelChooser {
    private static final String OVERLAYS_MSG = "Overlays:";
    private static final String CHANNEL_MSG = "Channel:";
    private final IChanneledViewerFactory viewerFactory;
    private final IDefaultChannelState defaultChannelState;
    private final LayoutContainer imageContainer;
    private ResolutionChooser resolutionChooser;
    private LogicalImageReference basicImage;
    private Set<ImageDatasetChannel> selectedOverlayChannels;
    private List<String> basicChannelCodes;
    private String imageTransformationCodeOrNull;
    private Map<String, IntensityRange> rangesOrNull;

    public ChannelChooser(LogicalImageReference basicImage, IChanneledViewerFactory viewerFactory, IDefaultChannelState defaultChannelState) {
        this.basicImage = basicImage;
        this.viewerFactory = viewerFactory;
        this.imageContainer = new LayoutContainer();
        this.basicChannelCodes = ChannelChooser.getInitialChannelCodes(defaultChannelState, basicImage.getChannelsCodes());
        this.imageTransformationCodeOrNull = ChannelChooser.tryGetInitialImageTransformationCode(defaultChannelState, this.basicChannelCodes, basicImage.getImagetParameters());
        this.rangesOrNull = ChannelChooser.tryGetInitialIntensityRange(defaultChannelState, this.basicChannelCodes);
        this.defaultChannelState = defaultChannelState;
        this.selectedOverlayChannels = new HashSet<ImageDatasetChannel>();
    }

    public void refresh(LogicalImageReference updatedBasicImage) {
        this.basicImage = updatedBasicImage;
        this.refresh();
    }

    public void refresh() {
        LogicalImageChannelsReference state = new LogicalImageChannelsReference(this.basicImage, this.basicChannelCodes, this.imageTransformationCodeOrNull, this.rangesOrNull, this.selectedOverlayChannels);
        LayoutContainer view = this.viewerFactory.create(state, this.resolutionChooser != null ? this.resolutionChooser.getResolution() : null);
        this.imageContainer.removeAll();
        this.imageContainer.add((Widget)view);
        this.imageContainer.layout();
    }

    public void addViewerTo(final LayoutContainer container, IViewContext<IScreeningClientServiceAsync> context, AsyncCallback<Void> callback) {
        Text loading = new Text(context.getMessage("load_in_progress", new Object[0]));
        container.add((Widget)loading);
        context.getService().getImageDatasetResolutions(this.basicImage.getDatasetCode(), this.basicImage.getDatastoreCode(), (AsyncCallback<List<ImageResolution>>)new AbstractAsyncCallback<List<ImageResolution>>(context, (Widget)loading, context, callback){
            private final /* synthetic */ Widget val$loading;
            private final /* synthetic */ IViewContext val$context;
            private final /* synthetic */ AsyncCallback val$callback;
            {
                this.val$loading = widget;
                this.val$context = iViewContext;
                this.val$callback = asyncCallback;
                super($anonymous0);
            }

            @Override
            protected void process(List<ImageResolution> resolutions) {
                container.remove(this.val$loading);
                List<DatasetOverlayImagesReference> overlayDatasets = ChannelChooser.this.basicImage.getOverlayDatasets();
                if (overlayDatasets.size() > 0) {
                    container.add(ChannelChooser.this.createOverlayChannelsChooser(overlayDatasets, this.val$context));
                }
                if (ChannelChooser.this.basicImage.getChannelsCodes().size() > 0) {
                    Widget channelChooserWithLabel = ChannelChooser.this.createBasicChannelChooser(this.val$context);
                    container.add(channelChooserWithLabel);
                }
                container.add(ChannelChooser.this.createResolutionChooser(this.val$context, resolutions), (LayoutData)new MarginData(5, 0, 5, 0));
                container.add((Widget)ChannelChooser.this.imageContainer);
                container.layout();
                if (this.val$callback != null) {
                    this.val$callback.onSuccess(null);
                }
                ChannelChooser.this.refresh();
            }
        });
    }

    private static Map<String, List<DatasetOverlayImagesReference>> groupByAnalysisProcedure(List<DatasetOverlayImagesReference> overlayDatasets) {
        return GroupByMap.create(overlayDatasets, new IGroupKeyExtractor<String, DatasetOverlayImagesReference>(){

            @Override
            public String getKey(DatasetOverlayImagesReference dataset) {
                return dataset.tryGetAnalysisProcedure();
            }
        }).getMap();
    }

    private Widget createOverlayChannelsChooser(List<DatasetOverlayImagesReference> overlayDatasets, IViewContext<?> viewContext) {
        Map<String, List<DatasetOverlayImagesReference>> datasetsByAnalysisProcMap = ChannelChooser.groupByAnalysisProcedure(overlayDatasets);
        if (datasetsByAnalysisProcMap.size() > 1) {
            AnalysisProcedures analysisProcedures = new AnalysisProcedures(datasetsByAnalysisProcMap.keySet());
            LayoutContainer chooserPanel = new LayoutContainer();
            chooserPanel.setLayout((Layout)new RowLayout());
            LayoutContainer objectsChooserContainer = new LayoutContainer();
            AnalysisProcedureChooser.IAnalysisProcedureSelectionListener selectionListener = this.createAnalysisProcedureSelectionListener(datasetsByAnalysisProcMap, objectsChooserContainer);
            AnalysisProcedureChooser analysisProcedureChooser = AnalysisProcedureChooser.create(viewContext, analysisProcedures, WellSearchCriteria.AnalysisProcedureCriteria.createAllProcedures(), selectionListener);
            chooserPanel.add((Widget)analysisProcedureChooser);
            chooserPanel.add((Widget)objectsChooserContainer);
            return chooserPanel;
        }
        return this.createOverlayChannelsChooserForOneAnalysisProcedure(overlayDatasets);
    }

    private AnalysisProcedureChooser.IAnalysisProcedureSelectionListener createAnalysisProcedureSelectionListener(final Map<String, List<DatasetOverlayImagesReference>> datasetsByAnalysisProcMap, final LayoutContainer objectsChooserContainer) {
        return new AnalysisProcedureChooser.IAnalysisProcedureSelectionListener(){

            @Override
            public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria criteria) {
                ChannelChooser.this.refreshObjectChooser(criteria, datasetsByAnalysisProcMap, objectsChooserContainer);
            }
        };
    }

    private void refreshObjectChooser(WellSearchCriteria.AnalysisProcedureCriteria criteria, Map<String, List<DatasetOverlayImagesReference>> datasetsByAnalysisProcMap, LayoutContainer objectsChooserContainer) {
        String analysisProcedureCode = criteria.tryGetAnalysisProcedureCode();
        List<DatasetOverlayImagesReference> overlayDatasetsForOneAnalysisProc = datasetsByAnalysisProcMap.get(analysisProcedureCode);
        objectsChooserContainer.removeAll();
        if (overlayDatasetsForOneAnalysisProc != null && overlayDatasetsForOneAnalysisProc.size() > 0) {
            Widget objectsChooser = this.createOverlayChannelsChooserForOneAnalysisProcedure(overlayDatasetsForOneAnalysisProc);
            objectsChooserContainer.add(objectsChooser);
        }
        objectsChooserContainer.layout();
        this.setSelectedOverlayChannels(new HashSet<ImageDatasetChannel>());
    }

    private Widget createOverlayChannelsChooserForOneAnalysisProcedure(List<DatasetOverlayImagesReference> overlayDatasets) {
        List overlayChannelItems = ChannelChooser.createOverlayChannelItems(overlayDatasets);
        CheckBoxGroupWithModel<ImageDatasetChannel> checkBoxGroup = new CheckBoxGroupWithModel<ImageDatasetChannel>(overlayChannelItems);
        checkBoxGroup.addListener(new CheckBoxGroupWithModel.CheckBoxGroupListner<ImageDatasetChannel>(){

            @Override
            public void onChange(Set<ImageDatasetChannel> selected) {
                ChannelChooser.this.setSelectedOverlayChannels(selected);
            }
        });
        return GuiUtils.withLabel(checkBoxGroup, OVERLAYS_MSG);
    }

    private void setSelectedOverlayChannels(Set<ImageDatasetChannel> selected) {
        this.selectedOverlayChannels = selected;
        this.refresh();
    }

    private static List<LabeledItem<ImageDatasetChannel>> createOverlayChannelItems(List<? extends DatasetImagesReference> overlayDatasets) {
        ArrayList<LabeledItem<ImageDatasetChannel>> items = new ArrayList<LabeledItem<ImageDatasetChannel>>();
        for (DatasetImagesReference datasetImagesReference : overlayDatasets) {
            ImageDatasetParameters imageParams = datasetImagesReference.getImageParameters();
            int i = 0;
            while (i < imageParams.getChannelsNumber()) {
                InternalImageChannel channel = imageParams.getInternalChannels().get(i);
                String channelCode = channel.getCode();
                String channelLabel = channel.getLabel();
                LabeledItem<ImageDatasetChannel> item = ChannelChooser.createLabeledItem(datasetImagesReference, channelCode, channelLabel);
                items.add(item);
                ++i;
            }
        }
        return items;
    }

    private static LabeledItem<ImageDatasetChannel> createLabeledItem(DatasetImagesReference overlayDataset, String channelCode, String channelLabel) {
        ImageDatasetChannel overlayChannel = ChannelChooser.createImageDatasetChannel(overlayDataset, channelCode);
        return new LabeledItem<ImageDatasetChannel>(overlayChannel, channelLabel);
    }

    private static ImageDatasetChannel createImageDatasetChannel(DatasetImagesReference dataset, String channelCode) {
        return new ImageDatasetChannel(dataset.getDatasetCode(), dataset.getDatastoreHostUrl(), channelCode);
    }

    private Widget createBasicChannelChooser(IViewContext<IScreeningClientServiceAsync> viewContext) {
        ChannelChooserPanel channelChooser = new ChannelChooserPanel(viewContext, this.defaultChannelState, this.basicChannelCodes, this.basicImage.getImagetParameters());
        channelChooser.addSelectionChangedListener(new ChannelChooserPanel.ChannelSelectionListener(){

            @Override
            public void selectionChanged(List<String> newlySelectedChannels, String imageTransformationCodeOrNull, Map<String, IntensityRange> rangesOrNull) {
                ChannelChooser.this.basicChannelCodes = newlySelectedChannels;
                ChannelChooser.this.imageTransformationCodeOrNull = imageTransformationCodeOrNull;
                ChannelChooser.this.rangesOrNull = rangesOrNull;
                ChannelChooser.this.refresh();
            }
        });
        return GuiUtils.withLabel((Widget)channelChooser, CHANNEL_MSG, 0, 80);
    }

    private Widget createResolutionChooser(IViewContext<IScreeningClientServiceAsync> viewContext, List<ImageResolution> resolutions) {
        if (this.resolutionChooser == null) {
            this.resolutionChooser = new ResolutionChooser(viewContext, resolutions, this.defaultChannelState.tryGetDefaultResolution());
            this.resolutionChooser.addResolutionChangedListener(new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    ChannelChooser.this.defaultChannelState.setDefaultResolution(ChannelChooser.this.resolutionChooser.getResolution());
                    ChannelChooser.this.refresh();
                }
            });
        }
        return GuiUtils.withLabel((Widget)this.resolutionChooser, viewContext.getMessage("RESOLUTION_CHOOSER_LABEL", new Object[0]), 0, 80);
    }

    private static List<String> getInitialChannelCodes(IDefaultChannelState defaultChannelState, List<String> channels) {
        List<String> defaultChannels = defaultChannelState.tryGetDefaultChannels();
        if (defaultChannels == null || !channels.containsAll(defaultChannels)) {
            return channels;
        }
        return defaultChannels;
    }

    private static String tryGetInitialImageTransformationCode(IDefaultChannelState defaultChannelState, List<String> channels, ImageDatasetParameters imageParameters) {
        if (imageParameters != null) {
            String channel = channels.size() == 1 ? channels.get(0) : "Merged Channels";
            String initialTransformation = defaultChannelState.tryGetDefaultTransformation(channel);
            if ("$DEFAULT$".equals(initialTransformation)) {
                return null;
            }
            String defaultSelection = null;
            List<InternalImageTransformationInfo> transformations = imageParameters.getAvailableImageTransformationsFor(channel);
            for (InternalImageTransformationInfo transformation : transformations) {
                if (transformation.getCode().equals(initialTransformation)) {
                    return initialTransformation;
                }
                if (!transformation.isDefault() || defaultSelection != null) continue;
                defaultSelection = transformation.getCode();
            }
            return defaultSelection;
        }
        return null;
    }

    private static Map<String, IntensityRange> tryGetInitialIntensityRange(IDefaultChannelState defaultChannelState, List<String> channels) {
        HashMap<String, IntensityRange> ranges = new HashMap<String, IntensityRange>();
        for (String channel : channels) {
            IntensityRange rangeOrNull = defaultChannelState.tryGetIntensityRange(channel);
            ranges.put(channel, rangeOrNull);
        }
        return ranges;
    }

    public static interface IChanneledViewerFactory {
        public LayoutContainer create(LogicalImageChannelsReference var1, ImageResolution var2);
    }
}

