/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImagingDatasetGuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LogicalImageLayouter
extends LayoutContainer
implements ImagingDatasetGuiUtils.IDatasetImagesReferenceUpdater {
    private final ScreeningViewContext viewContext;
    private final WellLocation wellLocationOrNull;
    private final Map<ImageDatasetEnrichedReference, LogicalImageInfo> refsMap;

    public LogicalImageLayouter(ScreeningViewContext viewContext, WellLocation wellLocationOrNull, List<LogicalImageInfo> images) {
        this.viewContext = viewContext;
        this.wellLocationOrNull = wellLocationOrNull;
        this.refsMap = LogicalImageLayouter.createRefsMap(images);
    }

    @Override
    public void changeDisplayedImageDataset(ImageDatasetEnrichedReference dataset) {
        LogicalImageInfo imageInfo = this.refsMap.get(dataset);
        assert (imageInfo != null) : "cannot find logical image for " + dataset;
        this.removeAll();
        Widget viewerWidget = this.createImageViewer(imageInfo);
        this.add(viewerWidget);
        this.layout();
    }

    private Widget createImageViewer(LogicalImageInfo imageInfo) {
        LogicalImageReference logicalImageReference = new LogicalImageReference(imageInfo.getImageDataset(), this.wellLocationOrNull);
        LogicalImageViewer viewer = new LogicalImageViewer(logicalImageReference, this.viewContext, imageInfo.getExperimentIdentifier(), imageInfo.getExperimentPermId(), true);
        return viewer.getViewerWidget();
    }

    public List<ImageDatasetEnrichedReference> getDatasetImagesReferences() {
        return new ArrayList<ImageDatasetEnrichedReference>(this.refsMap.keySet());
    }

    private static Map<ImageDatasetEnrichedReference, LogicalImageInfo> createRefsMap(List<LogicalImageInfo> images) {
        HashMap<ImageDatasetEnrichedReference, LogicalImageInfo> map = new HashMap<ImageDatasetEnrichedReference, LogicalImageInfo>();
        for (LogicalImageInfo imageInfo : images) {
            ImageDatasetEnrichedReference ref = imageInfo.getImageDataset();
            map.put(ref, imageInfo);
        }
        return map;
    }
}

